# coding: utf-8

"""
    Inventory API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: inventory
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class StockItemHeader(BaseModel):
    """
    StockItemHeader
    """ # noqa: E501
    item_number: Optional[StrictStr] = Field(default=None, alias="ItemNumber")
    item_title: Optional[StrictStr] = Field(default=None, alias="ItemTitle")
    barcode_number: Optional[StrictStr] = Field(default=None, alias="BarcodeNumber")
    meta_data: Optional[StrictStr] = Field(default=None, alias="MetaData")
    is_variation_parent: Optional[StrictBool] = Field(default=None, alias="IsVariationParent")
    is_batched_stock_type: Optional[StrictBool] = Field(default=None, alias="isBatchedStockType")
    purchase_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="PurchasePrice")
    retail_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="RetailPrice")
    tax_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="TaxRate")
    postal_service_id: Optional[StrictStr] = Field(default=None, alias="PostalServiceId")
    postal_service_name: Optional[StrictStr] = Field(default=None, alias="PostalServiceName")
    category_id: Optional[StrictStr] = Field(default=None, alias="CategoryId")
    category_name: Optional[StrictStr] = Field(default=None, alias="CategoryName")
    package_group_id: Optional[StrictStr] = Field(default=None, alias="PackageGroupId")
    package_group_name: Optional[StrictStr] = Field(default=None, alias="PackageGroupName")
    height: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Height")
    width: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Width")
    depth: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Depth")
    weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Weight")
    creation_date: Optional[datetime] = Field(default=None, alias="CreationDate")
    inventory_tracking_type: Optional[StrictInt] = Field(default=None, alias="InventoryTrackingType")
    batch_number_scan_required: Optional[StrictBool] = Field(default=None, alias="BatchNumberScanRequired")
    serial_number_scan_required: Optional[StrictBool] = Field(default=None, alias="SerialNumberScanRequired")
    stock_item_id: Optional[StrictStr] = Field(default=None, alias="StockItemId")
    stock_item_int_id: Optional[StrictInt] = Field(default=None, alias="StockItemIntId")
    __properties: ClassVar[List[str]] = ["ItemNumber", "ItemTitle", "BarcodeNumber", "MetaData", "IsVariationParent", "isBatchedStockType", "PurchasePrice", "RetailPrice", "TaxRate", "PostalServiceId", "PostalServiceName", "CategoryId", "CategoryName", "PackageGroupId", "PackageGroupName", "Height", "Width", "Depth", "Weight", "CreationDate", "InventoryTrackingType", "BatchNumberScanRequired", "SerialNumberScanRequired", "StockItemId", "StockItemIntId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StockItemHeader from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "is_batched_stock_type",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StockItemHeader from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ItemNumber": obj.get("ItemNumber"),
            "ItemTitle": obj.get("ItemTitle"),
            "BarcodeNumber": obj.get("BarcodeNumber"),
            "MetaData": obj.get("MetaData"),
            "IsVariationParent": obj.get("IsVariationParent"),
            "isBatchedStockType": obj.get("isBatchedStockType"),
            "PurchasePrice": obj.get("PurchasePrice"),
            "RetailPrice": obj.get("RetailPrice"),
            "TaxRate": obj.get("TaxRate"),
            "PostalServiceId": obj.get("PostalServiceId"),
            "PostalServiceName": obj.get("PostalServiceName"),
            "CategoryId": obj.get("CategoryId"),
            "CategoryName": obj.get("CategoryName"),
            "PackageGroupId": obj.get("PackageGroupId"),
            "PackageGroupName": obj.get("PackageGroupName"),
            "Height": obj.get("Height"),
            "Width": obj.get("Width"),
            "Depth": obj.get("Depth"),
            "Weight": obj.get("Weight"),
            "CreationDate": obj.get("CreationDate"),
            "InventoryTrackingType": obj.get("InventoryTrackingType"),
            "BatchNumberScanRequired": obj.get("BatchNumberScanRequired"),
            "SerialNumberScanRequired": obj.get("SerialNumberScanRequired"),
            "StockItemId": obj.get("StockItemId"),
            "StockItemIntId": obj.get("StockItemIntId")
        })
        return _obj


