# coding: utf-8

"""
    Inventory API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: inventory
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class StockLocation(BaseModel):
    """
    StockLocation
    """ # noqa: E501
    stock_location_id: Optional[StrictStr] = Field(default=None, alias="StockLocationId")
    location_name: Optional[StrictStr] = Field(default=None, alias="LocationName")
    address1: Optional[StrictStr] = Field(default=None, alias="Address1")
    address2: Optional[StrictStr] = Field(default=None, alias="Address2")
    city: Optional[StrictStr] = Field(default=None, alias="City")
    county: Optional[StrictStr] = Field(default=None, alias="County")
    country: Optional[StrictStr] = Field(default=None, alias="Country")
    zip_code: Optional[StrictStr] = Field(default=None, alias="ZipCode")
    is_not_trackable: Optional[StrictBool] = Field(default=None, alias="IsNotTrackable")
    location_tag: Optional[StrictStr] = Field(default=None, alias="LocationTag")
    is_fulfillment_center: Optional[StrictBool] = Field(default=None, alias="IsFulfillmentCenter")
    count_in_order_until_acknowledgement: Optional[StrictBool] = Field(default=None, alias="CountInOrderUntilAcknowledgement")
    fulfilment_center_deduct_stock_when_processed: Optional[StrictBool] = Field(default=None, alias="FulfilmentCenterDeductStockWhenProcessed")
    is_warehouse_managed: Optional[StrictBool] = Field(default=None, alias="IsWarehouseManaged")
    stock_location_int_id: Optional[StrictInt] = Field(default=None, alias="StockLocationIntId")
    __properties: ClassVar[List[str]] = ["StockLocationId", "LocationName", "Address1", "Address2", "City", "County", "Country", "ZipCode", "IsNotTrackable", "LocationTag", "IsFulfillmentCenter", "CountInOrderUntilAcknowledgement", "FulfilmentCenterDeductStockWhenProcessed", "IsWarehouseManaged", "StockLocationIntId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StockLocation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StockLocation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "StockLocationId": obj.get("StockLocationId"),
            "LocationName": obj.get("LocationName"),
            "Address1": obj.get("Address1"),
            "Address2": obj.get("Address2"),
            "City": obj.get("City"),
            "County": obj.get("County"),
            "Country": obj.get("Country"),
            "ZipCode": obj.get("ZipCode"),
            "IsNotTrackable": obj.get("IsNotTrackable"),
            "LocationTag": obj.get("LocationTag"),
            "IsFulfillmentCenter": obj.get("IsFulfillmentCenter"),
            "CountInOrderUntilAcknowledgement": obj.get("CountInOrderUntilAcknowledgement"),
            "FulfilmentCenterDeductStockWhenProcessed": obj.get("FulfilmentCenterDeductStockWhenProcessed"),
            "IsWarehouseManaged": obj.get("IsWarehouseManaged"),
            "StockLocationIntId": obj.get("StockLocationIntId")
        })
        return _obj


