# coding: utf-8

"""
    Listings API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: listings
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.listings.models.linn_live_key_value import LinnLiveKeyValue
from typing import Optional, Set
from typing_extensions import Self

class AmazonAttribute(BaseModel):
    """
    AmazonAttribute
    """ # noqa: E501
    attr_name: Optional[StrictStr] = Field(default=None, alias="AttrName")
    display_name: Optional[StrictStr] = Field(default=None, alias="DisplayName")
    linnworks_property: Optional[StrictStr] = Field(default=None, alias="LinnworksProperty")
    listing_property: Optional[StrictStr] = Field(default=None, alias="ListingProperty")
    default_value: Optional[StrictStr] = Field(default=None, alias="DefaultValue")
    required: Optional[StrictStr] = Field(default=None, alias="Required")
    type: Optional[StrictStr] = Field(default=None, alias="Type")
    real_type: Optional[StrictStr] = Field(default=None, alias="RealType")
    valid_values: Optional[List[LinnLiveKeyValue]] = Field(default=None, alias="ValidValues")
    path: Optional[StrictStr] = Field(default=None, alias="Path")
    is_variation: Optional[StrictBool] = Field(default=None, alias="IsVariation")
    is_invalid_value: Optional[StrictBool] = Field(default=None, alias="IsInvalidValue")
    error_message: Optional[StrictStr] = Field(default=None, alias="ErrorMessage")
    can_be_variation: Optional[StrictBool] = Field(default=None, alias="CanBeVariation")
    __properties: ClassVar[List[str]] = ["AttrName", "DisplayName", "LinnworksProperty", "ListingProperty", "DefaultValue", "Required", "Type", "RealType", "ValidValues", "Path", "IsVariation", "IsInvalidValue", "ErrorMessage", "CanBeVariation"]

    @field_validator('required')
    def required_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Optional', 'Desired', 'Required']):
            raise ValueError("must be one of enum values ('Optional', 'Desired', 'Required')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Unknown', 'String', 'Integer', 'Decimal', 'Enum', 'Boolean', 'DateTime']):
            raise ValueError("must be one of enum values ('Unknown', 'String', 'Integer', 'Decimal', 'Enum', 'Boolean', 'DateTime')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AmazonAttribute from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "can_be_variation",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in valid_values (list)
        _items = []
        if self.valid_values:
            for _item_valid_values in self.valid_values:
                if _item_valid_values:
                    _items.append(_item_valid_values.to_dict())
            _dict['ValidValues'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AmazonAttribute from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "AttrName": obj.get("AttrName"),
            "DisplayName": obj.get("DisplayName"),
            "LinnworksProperty": obj.get("LinnworksProperty"),
            "ListingProperty": obj.get("ListingProperty"),
            "DefaultValue": obj.get("DefaultValue"),
            "Required": obj.get("Required"),
            "Type": obj.get("Type"),
            "RealType": obj.get("RealType"),
            "ValidValues": [LinnLiveKeyValue.from_dict(_item) for _item in obj["ValidValues"]] if obj.get("ValidValues") is not None else None,
            "Path": obj.get("Path"),
            "IsVariation": obj.get("IsVariation"),
            "IsInvalidValue": obj.get("IsInvalidValue"),
            "ErrorMessage": obj.get("ErrorMessage"),
            "CanBeVariation": obj.get("CanBeVariation")
        })
        return _obj


