# coding: utf-8

"""
    Listings API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: listings
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.listings.models.amazon_attribute import AmazonAttribute
from linnworks_api.generated.listings.models.key_value_generic_guid_double import KeyValueGenericGuidDouble
from typing import Optional, Set
from typing_extensions import Self

class AmazonVariation(BaseModel):
    """
    AmazonVariation
    """ # noqa: E501
    is_ignored: Optional[StrictBool] = Field(default=None, alias="IsIgnored")
    ignored_msg: Optional[StrictStr] = Field(default=None, alias="IgnoredMsg")
    collision_number: Optional[StrictInt] = Field(default=None, alias="CollisionNumber")
    stock_item_id: Optional[StrictStr] = Field(default=None, alias="StockItemId")
    sku: Optional[StrictStr] = Field(default=None, alias="SKU")
    title: Optional[StrictStr] = Field(default=None, alias="Title")
    barcode: Optional[StrictStr] = Field(default=None, alias="Barcode")
    price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Price")
    business_price: Optional[KeyValueGenericGuidDouble] = Field(default=None, alias="BusinessPrice")
    quantity: Optional[StrictInt] = Field(default=None, alias="Quantity")
    pictures: Optional[List[AmazonAttribute]] = Field(default=None, alias="Pictures")
    attributes: Optional[List[AmazonAttribute]] = Field(default=None, alias="Attributes")
    message_ids: Optional[List[StrictStr]] = Field(default=None, alias="MessageIds")
    __properties: ClassVar[List[str]] = ["IsIgnored", "IgnoredMsg", "CollisionNumber", "StockItemId", "SKU", "Title", "Barcode", "Price", "BusinessPrice", "Quantity", "Pictures", "Attributes", "MessageIds"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AmazonVariation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of business_price
        if self.business_price:
            _dict['BusinessPrice'] = self.business_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in pictures (list)
        _items = []
        if self.pictures:
            for _item_pictures in self.pictures:
                if _item_pictures:
                    _items.append(_item_pictures.to_dict())
            _dict['Pictures'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item_attributes in self.attributes:
                if _item_attributes:
                    _items.append(_item_attributes.to_dict())
            _dict['Attributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AmazonVariation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "IsIgnored": obj.get("IsIgnored"),
            "IgnoredMsg": obj.get("IgnoredMsg"),
            "CollisionNumber": obj.get("CollisionNumber"),
            "StockItemId": obj.get("StockItemId"),
            "SKU": obj.get("SKU"),
            "Title": obj.get("Title"),
            "Barcode": obj.get("Barcode"),
            "Price": obj.get("Price"),
            "BusinessPrice": KeyValueGenericGuidDouble.from_dict(obj["BusinessPrice"]) if obj.get("BusinessPrice") is not None else None,
            "Quantity": obj.get("Quantity"),
            "Pictures": [AmazonAttribute.from_dict(_item) for _item in obj["Pictures"]] if obj.get("Pictures") is not None else None,
            "Attributes": [AmazonAttribute.from_dict(_item) for _item in obj["Attributes"]] if obj.get("Attributes") is not None else None,
            "MessageIds": obj.get("MessageIds")
        })
        return _obj


