# coding: utf-8

"""
    Listings API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: listings
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.listings.models.child_option import ChildOption
from typing import Optional, Set
from typing_extensions import Self

class BigCommerceAssignedProducts(BaseModel):
    """
    BigCommerceAssignedProducts
    """ # noqa: E501
    stock_item_id: Optional[StrictStr] = Field(default=None, alias="StockItemId")
    child_id: Optional[StrictStr] = Field(default=None, alias="ChildId")
    sku_id: Optional[StrictInt] = Field(default=None, alias="SkuId")
    sku: Optional[StrictStr] = Field(default=None, alias="SKU")
    upc: Optional[StrictStr] = Field(default=None, alias="UPC")
    mpn: Optional[StrictStr] = Field(default=None, alias="MPN")
    gtin: Optional[StrictStr] = Field(default=None, alias="GTIN")
    name: Optional[StrictStr] = Field(default=None, alias="Name")
    price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Price")
    manage_stock: Optional[StrictBool] = Field(default=None, alias="ManageStock")
    collision_number: Optional[StrictInt] = Field(default=None, alias="CollisionNumber")
    status: Optional[StrictStr] = Field(default=None, alias="Status")
    quantity: Optional[StrictInt] = Field(default=None, alias="Quantity")
    weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Weight")
    depth: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Depth")
    height: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Height")
    width: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Width")
    in_stock_channel: Optional[StrictBool] = Field(default=None, alias="InStockChannel")
    product_image_url: Optional[StrictStr] = Field(default=None, alias="ProductImageURL")
    options_values: Optional[List[ChildOption]] = Field(default=None, alias="OptionsValues")
    sale_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="SalePrice")
    retail_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="RetailPrice")
    __properties: ClassVar[List[str]] = ["StockItemId", "ChildId", "SkuId", "SKU", "UPC", "MPN", "GTIN", "Name", "Price", "ManageStock", "CollisionNumber", "Status", "Quantity", "Weight", "Depth", "Height", "Width", "InStockChannel", "ProductImageURL", "OptionsValues", "SalePrice", "RetailPrice"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NOT_LISTED', 'OK', 'WAITING_FOR_LISTING', 'UPDATING', 'CREATING', 'DELETING', 'WAITING_FOR_UPDATE', 'PROCESSING', 'UPDATE_ERROR']):
            raise ValueError("must be one of enum values ('NOT_LISTED', 'OK', 'WAITING_FOR_LISTING', 'UPDATING', 'CREATING', 'DELETING', 'WAITING_FOR_UPDATE', 'PROCESSING', 'UPDATE_ERROR')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BigCommerceAssignedProducts from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in options_values (list)
        _items = []
        if self.options_values:
            for _item_options_values in self.options_values:
                if _item_options_values:
                    _items.append(_item_options_values.to_dict())
            _dict['OptionsValues'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BigCommerceAssignedProducts from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "StockItemId": obj.get("StockItemId"),
            "ChildId": obj.get("ChildId"),
            "SkuId": obj.get("SkuId"),
            "SKU": obj.get("SKU"),
            "UPC": obj.get("UPC"),
            "MPN": obj.get("MPN"),
            "GTIN": obj.get("GTIN"),
            "Name": obj.get("Name"),
            "Price": obj.get("Price"),
            "ManageStock": obj.get("ManageStock"),
            "CollisionNumber": obj.get("CollisionNumber"),
            "Status": obj.get("Status"),
            "Quantity": obj.get("Quantity"),
            "Weight": obj.get("Weight"),
            "Depth": obj.get("Depth"),
            "Height": obj.get("Height"),
            "Width": obj.get("Width"),
            "InStockChannel": obj.get("InStockChannel"),
            "ProductImageURL": obj.get("ProductImageURL"),
            "OptionsValues": [ChildOption.from_dict(_item) for _item in obj["OptionsValues"]] if obj.get("OptionsValues") is not None else None,
            "SalePrice": obj.get("SalePrice"),
            "RetailPrice": obj.get("RetailPrice")
        })
        return _obj


