# coding: utf-8

"""
    Listings API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: listings
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.listings.models.assigned_option_set import AssignedOptionSet
from linnworks_api.generated.listings.models.big_commerce_assigned_products import BigCommerceAssignedProducts
from linnworks_api.generated.listings.models.big_commerce_config_attributes import BigCommerceConfigAttributes
from linnworks_api.generated.listings.models.big_commerce_custom_field import BigCommerceCustomField
from linnworks_api.generated.listings.models.big_commerce_image_data import BigCommerceImageData
from linnworks_api.generated.listings.models.config_category import ConfigCategory
from linnworks_api.generated.listings.models.var_attribute import VarAttribute
from typing import Optional, Set
from typing_extensions import Self

class BigCommerceListing(BaseModel):
    """
    BigCommerceListing
    """ # noqa: E501
    adjustments: Optional[StrictInt] = Field(default=None, alias="Adjustments")
    width: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Width")
    height: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Height")
    depth: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Depth")
    attributes: Optional[List[BigCommerceConfigAttributes]] = Field(default=None, alias="Attributes")
    var_attributes: Optional[List[VarAttribute]] = Field(default=None, alias="VarAttributes")
    children: Optional[List[BigCommerceAssignedProducts]] = Field(default=None, alias="Children")
    old_children: Optional[List[BigCommerceAssignedProducts]] = Field(default=None, alias="OldChildren")
    option_set: Optional[AssignedOptionSet] = Field(default=None, alias="OptionSet")
    images: Optional[List[BigCommerceImageData]] = Field(default=None, alias="Images")
    version: Optional[StrictInt] = Field(default=None, alias="Version")
    listing_id: Optional[StrictStr] = Field(default=None, alias="ListingId")
    template_id: Optional[StrictStr] = Field(default=None, alias="TemplateId")
    inventory_item_id: Optional[StrictStr] = Field(default=None, alias="InventoryItemId")
    config_id: Optional[StrictStr] = Field(default=None, alias="ConfigId")
    used_config_name: Optional[StrictStr] = Field(default=None, alias="UsedConfigName")
    product_id: Optional[StrictInt] = Field(default=None, alias="ProductId")
    update_config: Optional[StrictBool] = Field(default=None, alias="UpdateConfig")
    type: Optional[StrictStr] = Field(default=None, alias="Type")
    listing_url: Optional[StrictStr] = Field(default=None, alias="ListingURL")
    name: Optional[StrictStr] = Field(default=None, alias="Name")
    description: Optional[StrictStr] = Field(default=None, alias="Description")
    short_description: Optional[StrictStr] = Field(default=None, alias="ShortDescription")
    sku: Optional[StrictStr] = Field(default=None, alias="SKU")
    barcode: Optional[StrictStr] = Field(default=None, alias="Barcode")
    title_source: Optional[StrictStr] = Field(default=None, alias="TitleSource")
    price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Price")
    weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Weight")
    show_listing: Optional[StrictBool] = Field(default=None, alias="ShowListing")
    manage_stock: Optional[StrictBool] = Field(default=None, alias="ManageStock")
    quantity: Optional[StrictInt] = Field(default=None, alias="Quantity")
    is_read_only: Optional[StrictBool] = Field(default=None, alias="IsReadOnly")
    categories: Optional[List[ConfigCategory]] = Field(default=None, alias="Categories")
    has_collisions: Optional[StrictBool] = Field(default=None, alias="HasCollisions")
    use_main_item_images: Optional[StrictBool] = Field(default=None, alias="UseMainItemImages")
    status: Optional[StrictStr] = Field(default=None, alias="Status")
    site: Optional[StrictStr] = Field(default=None, alias="Site")
    is_error_msg: Optional[StrictBool] = Field(default=None, alias="IsErrorMsg")
    custom_fields: Optional[List[BigCommerceCustomField]] = Field(default=None, alias="CustomFields")
    __properties: ClassVar[List[str]] = ["Adjustments", "Width", "Height", "Depth", "Attributes", "VarAttributes", "Children", "OldChildren", "OptionSet", "Images", "Version", "ListingId", "TemplateId", "InventoryItemId", "ConfigId", "UsedConfigName", "ProductId", "UpdateConfig", "Type", "ListingURL", "Name", "Description", "ShortDescription", "SKU", "Barcode", "TitleSource", "Price", "Weight", "ShowListing", "ManageStock", "Quantity", "IsReadOnly", "Categories", "HasCollisions", "UseMainItemImages", "Status", "Site", "IsErrorMsg", "CustomFields"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SIMPLE', 'VARIATION']):
            raise ValueError("must be one of enum values ('SIMPLE', 'VARIATION')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NOT_LISTED', 'OK', 'WAITING_FOR_LISTING', 'UPDATING', 'CREATING', 'DELETING', 'WAITING_FOR_UPDATE', 'PROCESSING', 'UPDATE_ERROR']):
            raise ValueError("must be one of enum values ('NOT_LISTED', 'OK', 'WAITING_FOR_LISTING', 'UPDATING', 'CREATING', 'DELETING', 'WAITING_FOR_UPDATE', 'PROCESSING', 'UPDATE_ERROR')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BigCommerceListing from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item_attributes in self.attributes:
                if _item_attributes:
                    _items.append(_item_attributes.to_dict())
            _dict['Attributes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in var_attributes (list)
        _items = []
        if self.var_attributes:
            for _item_var_attributes in self.var_attributes:
                if _item_var_attributes:
                    _items.append(_item_var_attributes.to_dict())
            _dict['VarAttributes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in children (list)
        _items = []
        if self.children:
            for _item_children in self.children:
                if _item_children:
                    _items.append(_item_children.to_dict())
            _dict['Children'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in old_children (list)
        _items = []
        if self.old_children:
            for _item_old_children in self.old_children:
                if _item_old_children:
                    _items.append(_item_old_children.to_dict())
            _dict['OldChildren'] = _items
        # override the default output from pydantic by calling `to_dict()` of option_set
        if self.option_set:
            _dict['OptionSet'] = self.option_set.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in images (list)
        _items = []
        if self.images:
            for _item_images in self.images:
                if _item_images:
                    _items.append(_item_images.to_dict())
            _dict['Images'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in categories (list)
        _items = []
        if self.categories:
            for _item_categories in self.categories:
                if _item_categories:
                    _items.append(_item_categories.to_dict())
            _dict['Categories'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in custom_fields (list)
        _items = []
        if self.custom_fields:
            for _item_custom_fields in self.custom_fields:
                if _item_custom_fields:
                    _items.append(_item_custom_fields.to_dict())
            _dict['CustomFields'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BigCommerceListing from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Adjustments": obj.get("Adjustments"),
            "Width": obj.get("Width"),
            "Height": obj.get("Height"),
            "Depth": obj.get("Depth"),
            "Attributes": [BigCommerceConfigAttributes.from_dict(_item) for _item in obj["Attributes"]] if obj.get("Attributes") is not None else None,
            "VarAttributes": [VarAttribute.from_dict(_item) for _item in obj["VarAttributes"]] if obj.get("VarAttributes") is not None else None,
            "Children": [BigCommerceAssignedProducts.from_dict(_item) for _item in obj["Children"]] if obj.get("Children") is not None else None,
            "OldChildren": [BigCommerceAssignedProducts.from_dict(_item) for _item in obj["OldChildren"]] if obj.get("OldChildren") is not None else None,
            "OptionSet": AssignedOptionSet.from_dict(obj["OptionSet"]) if obj.get("OptionSet") is not None else None,
            "Images": [BigCommerceImageData.from_dict(_item) for _item in obj["Images"]] if obj.get("Images") is not None else None,
            "Version": obj.get("Version"),
            "ListingId": obj.get("ListingId"),
            "TemplateId": obj.get("TemplateId"),
            "InventoryItemId": obj.get("InventoryItemId"),
            "ConfigId": obj.get("ConfigId"),
            "UsedConfigName": obj.get("UsedConfigName"),
            "ProductId": obj.get("ProductId"),
            "UpdateConfig": obj.get("UpdateConfig"),
            "Type": obj.get("Type"),
            "ListingURL": obj.get("ListingURL"),
            "Name": obj.get("Name"),
            "Description": obj.get("Description"),
            "ShortDescription": obj.get("ShortDescription"),
            "SKU": obj.get("SKU"),
            "Barcode": obj.get("Barcode"),
            "TitleSource": obj.get("TitleSource"),
            "Price": obj.get("Price"),
            "Weight": obj.get("Weight"),
            "ShowListing": obj.get("ShowListing"),
            "ManageStock": obj.get("ManageStock"),
            "Quantity": obj.get("Quantity"),
            "IsReadOnly": obj.get("IsReadOnly"),
            "Categories": [ConfigCategory.from_dict(_item) for _item in obj["Categories"]] if obj.get("Categories") is not None else None,
            "HasCollisions": obj.get("HasCollisions"),
            "UseMainItemImages": obj.get("UseMainItemImages"),
            "Status": obj.get("Status"),
            "Site": obj.get("Site"),
            "IsErrorMsg": obj.get("IsErrorMsg"),
            "CustomFields": [BigCommerceCustomField.from_dict(_item) for _item in obj["CustomFields"]] if obj.get("CustomFields") is not None else None
        })
        return _obj


