# coding: utf-8

"""
    Listings API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: listings
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.listings.models.e_bay_item import EBayItem
from linnworks_api.generated.listings.models.ebay_listing_audit import EbayListingAudit
from typing import Optional, Set
from typing_extensions import Self

class SetListingStrikeOffStateRequest(BaseModel):
    """
    SetListingStrikeOffStateRequest
    """ # noqa: E501
    listing_audits: Optional[List[EbayListingAudit]] = Field(default=None, description="Listing audit details", alias="ListingAudits")
    listings: Optional[List[EBayItem]] = Field(default=None, description="Channel Listings", alias="Listings")
    strike_reason: Optional[StrictStr] = Field(default=None, description="Reason of strike off", alias="StrikeReason")
    strike_off_state: Optional[StrictBool] = Field(default=None, description="Listing strike off state", alias="StrikeOffState")
    listings_status: Optional[StrictStr] = Field(default=None, description="Status of listings search", alias="ListingsStatus")
    __properties: ClassVar[List[str]] = ["ListingAudits", "Listings", "StrikeReason", "StrikeOffState", "ListingsStatus"]

    @field_validator('listings_status')
    def listings_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['active', 'pendingrelist', 'ended']):
            raise ValueError("must be one of enum values ('active', 'pendingrelist', 'ended')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SetListingStrikeOffStateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in listing_audits (list)
        _items = []
        if self.listing_audits:
            for _item_listing_audits in self.listing_audits:
                if _item_listing_audits:
                    _items.append(_item_listing_audits.to_dict())
            _dict['ListingAudits'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in listings (list)
        _items = []
        if self.listings:
            for _item_listings in self.listings:
                if _item_listings:
                    _items.append(_item_listings.to_dict())
            _dict['Listings'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SetListingStrikeOffStateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ListingAudits": [EbayListingAudit.from_dict(_item) for _item in obj["ListingAudits"]] if obj.get("ListingAudits") is not None else None,
            "Listings": [EBayItem.from_dict(_item) for _item in obj["Listings"]] if obj.get("Listings") is not None else None,
            "StrikeReason": obj.get("StrikeReason"),
            "StrikeOffState": obj.get("StrikeOffState"),
            "ListingsStatus": obj.get("ListingsStatus")
        })
        return _obj


