# coding: utf-8

"""
    Listings API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: listings
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.listings.models.ebay_price_rule import EbayPriceRule
from linnworks_api.generated.listings.models.ebay_shipping_service import EbayShippingService
from linnworks_api.generated.listings.models.ebay_weight_rule import EbayWeightRule
from linnworks_api.generated.listings.models.key_value import KeyValue
from typing import Optional, Set
from typing_extensions import Self

class Shipping(BaseModel):
    """
    Shipping
    """ # noqa: E501
    shipping_service: Optional[EbayShippingService] = Field(default=None, alias="ShippingService")
    price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Price")
    price_extended_property: Optional[StrictStr] = Field(default=None, alias="Price_ExtendedProperty")
    additional_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="AdditionalPrice")
    additional_price_extended_property: Optional[StrictStr] = Field(default=None, alias="AdditionalPrice_ExtendedProperty")
    handling_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="HandlingPrice")
    shipping_locations: Optional[List[KeyValue]] = Field(default=None, alias="ShippingLocations")
    weight_rules: Optional[List[EbayWeightRule]] = Field(default=None, alias="WeightRules")
    price_association_rules: Optional[List[EbayPriceRule]] = Field(default=None, alias="PriceAssociationRules")
    __properties: ClassVar[List[str]] = ["ShippingService", "Price", "Price_ExtendedProperty", "AdditionalPrice", "AdditionalPrice_ExtendedProperty", "HandlingPrice", "ShippingLocations", "WeightRules", "PriceAssociationRules"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Shipping from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of shipping_service
        if self.shipping_service:
            _dict['ShippingService'] = self.shipping_service.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in shipping_locations (list)
        _items = []
        if self.shipping_locations:
            for _item_shipping_locations in self.shipping_locations:
                if _item_shipping_locations:
                    _items.append(_item_shipping_locations.to_dict())
            _dict['ShippingLocations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in weight_rules (list)
        _items = []
        if self.weight_rules:
            for _item_weight_rules in self.weight_rules:
                if _item_weight_rules:
                    _items.append(_item_weight_rules.to_dict())
            _dict['WeightRules'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in price_association_rules (list)
        _items = []
        if self.price_association_rules:
            for _item_price_association_rules in self.price_association_rules:
                if _item_price_association_rules:
                    _items.append(_item_price_association_rules.to_dict())
            _dict['PriceAssociationRules'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Shipping from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ShippingService": EbayShippingService.from_dict(obj["ShippingService"]) if obj.get("ShippingService") is not None else None,
            "Price": obj.get("Price"),
            "Price_ExtendedProperty": obj.get("Price_ExtendedProperty"),
            "AdditionalPrice": obj.get("AdditionalPrice"),
            "AdditionalPrice_ExtendedProperty": obj.get("AdditionalPrice_ExtendedProperty"),
            "HandlingPrice": obj.get("HandlingPrice"),
            "ShippingLocations": [KeyValue.from_dict(_item) for _item in obj["ShippingLocations"]] if obj.get("ShippingLocations") is not None else None,
            "WeightRules": [EbayWeightRule.from_dict(_item) for _item in obj["WeightRules"]] if obj.get("WeightRules") is not None else None,
            "PriceAssociationRules": [EbayPriceRule.from_dict(_item) for _item in obj["PriceAssociationRules"]] if obj.get("PriceAssociationRules") is not None else None
        })
        return _obj


