# coding: utf-8

"""
    Open Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: openorders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class GetViewStatsRequest(BaseModel):
    """
    GetViewStatsRequest
    """ # noqa: E501
    location_id: Optional[StrictStr] = Field(default=None, alias="LocationId")
    view_id: Optional[StrictInt] = Field(default=None, alias="ViewId")
    user_id: Optional[StrictInt] = Field(default=None, alias="UserId")
    include_user_management: Optional[StrictBool] = Field(default=None, alias="IncludeUserManagement")
    only_visible: Optional[StrictBool] = Field(default=None, alias="OnlyVisible")
    rebuild_cache_if_required: Optional[StrictBool] = Field(default=None, description="If only the currently built stats are required, pass false here. Useful for polling whether a long running cache build has finished  The default is true.", alias="RebuildCacheIfRequired")
    recalculate_view_if_required: Optional[StrictBool] = Field(default=None, alias="RecalculateViewIfRequired")
    __properties: ClassVar[List[str]] = ["LocationId", "ViewId", "UserId", "IncludeUserManagement", "OnlyVisible", "RebuildCacheIfRequired", "RecalculateViewIfRequired"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetViewStatsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetViewStatsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "LocationId": obj.get("LocationId"),
            "ViewId": obj.get("ViewId"),
            "UserId": obj.get("UserId"),
            "IncludeUserManagement": obj.get("IncludeUserManagement"),
            "OnlyVisible": obj.get("OnlyVisible"),
            "RebuildCacheIfRequired": obj.get("RebuildCacheIfRequired"),
            "RecalculateViewIfRequired": obj.get("RecalculateViewIfRequired")
        })
        return _obj


