# coding: utf-8

"""
    Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: orders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.orders.models.calc_bin import CalcBin
from linnworks_api.generated.orders.models.calc_order_item import CalcOrderItem
from linnworks_api.generated.orders.models.packing_result import PackingResult
from typing import Optional, Set
from typing_extensions import Self

class CalcOrderHeader(BaseModel):
    """
    CalcOrderHeader
    """ # noqa: E501
    pk_order_id: Optional[StrictStr] = Field(default=None, alias="pkOrderID")
    n_order_id: Optional[StrictInt] = Field(default=None, alias="nOrderId")
    fk_postal_service_id: Optional[StrictStr] = Field(default=None, alias="fkPostalServiceId")
    fk_country_id: Optional[StrictStr] = Field(default=None, alias="fkCountryId")
    c_country: Optional[StrictStr] = Field(default=None, alias="cCountry")
    item_weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ItemWeight")
    fk_packaging_group_id: Optional[StrictStr] = Field(default=None, alias="fkPackagingGroupId")
    fk_packaging_type_id: Optional[StrictStr] = Field(default=None, alias="fkPackagingTypeId")
    is_split_packaging: Optional[StrictBool] = Field(default=None, alias="IsSplitPackaging")
    packaging_weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="PackagingWeight")
    total_weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="TotalWeight")
    total_width: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="TotalWidth")
    total_height: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="TotalHeight")
    total_depth: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="TotalDepth")
    manual_adjust: Optional[StrictBool] = Field(default=None, alias="ManualAdjust")
    can_auto_split: Optional[StrictBool] = Field(default=None, alias="CanAutoSplit")
    is_auto_split: Optional[StrictBool] = Field(default=None, alias="IsAutoSplit")
    split_package_count: Optional[StrictInt] = Field(default=None, alias="SplitPackageCount")
    label_printed: Optional[StrictBool] = Field(default=None, alias="LabelPrinted")
    calculation_hints: Optional[List[StrictStr]] = Field(default=None, alias="CalculationHints")
    items: Optional[List[CalcOrderItem]] = Field(default=None, alias="Items")
    bins: Optional[List[CalcBin]] = Field(default=None, alias="Bins")
    three_dim_packaging: Optional[PackingResult] = Field(default=None, alias="ThreeDimPackaging")
    dim_method: Optional[StrictStr] = Field(default=None, alias="DimMethod")
    __properties: ClassVar[List[str]] = ["pkOrderID", "nOrderId", "fkPostalServiceId", "fkCountryId", "cCountry", "ItemWeight", "fkPackagingGroupId", "fkPackagingTypeId", "IsSplitPackaging", "PackagingWeight", "TotalWeight", "TotalWidth", "TotalHeight", "TotalDepth", "ManualAdjust", "CanAutoSplit", "IsAutoSplit", "SplitPackageCount", "LabelPrinted", "CalculationHints", "Items", "Bins", "ThreeDimPackaging", "DimMethod"]

    @field_validator('dim_method')
    def dim_method_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['LEGACY', 'MAX', 'STACKED', 'WEIGHTFIT', 'THREEDIM_ALL', 'THREEDIM_ITEMS']):
            raise ValueError("must be one of enum values ('LEGACY', 'MAX', 'STACKED', 'WEIGHTFIT', 'THREEDIM_ALL', 'THREEDIM_ITEMS')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CalcOrderHeader from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "is_split_packaging",
            "can_auto_split",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['Items'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in bins (list)
        _items = []
        if self.bins:
            for _item_bins in self.bins:
                if _item_bins:
                    _items.append(_item_bins.to_dict())
            _dict['Bins'] = _items
        # override the default output from pydantic by calling `to_dict()` of three_dim_packaging
        if self.three_dim_packaging:
            _dict['ThreeDimPackaging'] = self.three_dim_packaging.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CalcOrderHeader from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pkOrderID": obj.get("pkOrderID"),
            "nOrderId": obj.get("nOrderId"),
            "fkPostalServiceId": obj.get("fkPostalServiceId"),
            "fkCountryId": obj.get("fkCountryId"),
            "cCountry": obj.get("cCountry"),
            "ItemWeight": obj.get("ItemWeight"),
            "fkPackagingGroupId": obj.get("fkPackagingGroupId"),
            "fkPackagingTypeId": obj.get("fkPackagingTypeId"),
            "IsSplitPackaging": obj.get("IsSplitPackaging"),
            "PackagingWeight": obj.get("PackagingWeight"),
            "TotalWeight": obj.get("TotalWeight"),
            "TotalWidth": obj.get("TotalWidth"),
            "TotalHeight": obj.get("TotalHeight"),
            "TotalDepth": obj.get("TotalDepth"),
            "ManualAdjust": obj.get("ManualAdjust"),
            "CanAutoSplit": obj.get("CanAutoSplit"),
            "IsAutoSplit": obj.get("IsAutoSplit"),
            "SplitPackageCount": obj.get("SplitPackageCount"),
            "LabelPrinted": obj.get("LabelPrinted"),
            "CalculationHints": obj.get("CalculationHints"),
            "Items": [CalcOrderItem.from_dict(_item) for _item in obj["Items"]] if obj.get("Items") is not None else None,
            "Bins": [CalcBin.from_dict(_item) for _item in obj["Bins"]] if obj.get("Bins") is not None else None,
            "ThreeDimPackaging": PackingResult.from_dict(obj["ThreeDimPackaging"]) if obj.get("ThreeDimPackaging") is not None else None,
            "DimMethod": obj.get("DimMethod")
        })
        return _obj


