# coding: utf-8

"""
    Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: orders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.orders.models.stock_item_box_configuration import StockItemBoxConfiguration
from typing import Optional, Set
from typing_extensions import Self

class CalcOrderItem(BaseModel):
    """
    CalcOrderItem
    """ # noqa: E501
    fk_stock_item_id: Optional[StrictStr] = Field(default=None, alias="fkStockItemId")
    fk_order_item_id: Optional[StrictStr] = Field(default=None, alias="fkOrderItemId")
    stock_item_int_id: Optional[StrictInt] = Field(default=None, alias="StockItemIntId")
    sku: Optional[StrictStr] = Field(default=None, alias="SKU")
    n_qty: Optional[StrictInt] = Field(default=None, alias="nQty")
    item_weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ItemWeight")
    dim_height: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="DimHeight")
    dim_width: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="DimWidth")
    dim_depth: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="DimDepth")
    package_group: Optional[StrictStr] = Field(default=None, alias="PackageGroup")
    fk_composite_parent_row_id: Optional[StrictStr] = Field(default=None, alias="fkCompositeParentRowId")
    is_composite_child: Optional[StrictBool] = Field(default=None, alias="IsCompositeChild")
    boxes: Optional[List[StockItemBoxConfiguration]] = Field(default=None, alias="Boxes")
    __properties: ClassVar[List[str]] = ["fkStockItemId", "fkOrderItemId", "StockItemIntId", "SKU", "nQty", "ItemWeight", "DimHeight", "DimWidth", "DimDepth", "PackageGroup", "fkCompositeParentRowId", "IsCompositeChild", "Boxes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CalcOrderItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "is_composite_child",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in boxes (list)
        _items = []
        if self.boxes:
            for _item_boxes in self.boxes:
                if _item_boxes:
                    _items.append(_item_boxes.to_dict())
            _dict['Boxes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CalcOrderItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fkStockItemId": obj.get("fkStockItemId"),
            "fkOrderItemId": obj.get("fkOrderItemId"),
            "StockItemIntId": obj.get("StockItemIntId"),
            "SKU": obj.get("SKU"),
            "nQty": obj.get("nQty"),
            "ItemWeight": obj.get("ItemWeight"),
            "DimHeight": obj.get("DimHeight"),
            "DimWidth": obj.get("DimWidth"),
            "DimDepth": obj.get("DimDepth"),
            "PackageGroup": obj.get("PackageGroup"),
            "fkCompositeParentRowId": obj.get("fkCompositeParentRowId"),
            "IsCompositeChild": obj.get("IsCompositeChild"),
            "Boxes": [StockItemBoxConfiguration.from_dict(_item) for _item in obj["Boxes"]] if obj.get("Boxes") is not None else None
        })
        return _obj


