# coding: utf-8

"""
    Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: orders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.orders.models.channel_order_item_option import ChannelOrderItemOption
from linnworks_api.generated.orders.models.channel_order_item_tax import ChannelOrderItemTax
from typing import Optional, Set
from typing_extensions import Self

class ChannelOrderItem(BaseModel):
    """
    ChannelOrderItem
    """ # noqa: E501
    tax_cost_inclusive: Optional[StrictBool] = Field(default=None, alias="TaxCostInclusive")
    use_channel_tax: Optional[StrictBool] = Field(default=None, alias="UseChannelTax")
    price_per_unit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="PricePerUnit")
    postal_service_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="PostalServiceCost")
    qty: Optional[StrictInt] = Field(default=None, alias="Qty")
    tax_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="TaxRate")
    line_discount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="LineDiscount")
    line_refund: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="LineRefund")
    refund_quantity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="RefundQuantity")
    shipping_refund: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ShippingRefund")
    total_refund: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="TotalRefund")
    item_number: Optional[StrictStr] = Field(default=None, alias="ItemNumber")
    channel_reference_id: Optional[StrictStr] = Field(default=None, alias="ChannelReferenceId")
    channel_sku: Optional[StrictStr] = Field(default=None, alias="ChannelSKU")
    is_service: Optional[StrictBool] = Field(default=None, alias="IsService")
    item_title: Optional[StrictStr] = Field(default=None, alias="ItemTitle")
    options: Optional[List[ChannelOrderItemOption]] = Field(default=None, alias="Options")
    taxes: Optional[List[ChannelOrderItemTax]] = Field(default=None, alias="Taxes")
    __properties: ClassVar[List[str]] = ["TaxCostInclusive", "UseChannelTax", "PricePerUnit", "PostalServiceCost", "Qty", "TaxRate", "LineDiscount", "LineRefund", "RefundQuantity", "ShippingRefund", "TotalRefund", "ItemNumber", "ChannelReferenceId", "ChannelSKU", "IsService", "ItemTitle", "Options", "Taxes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChannelOrderItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in options (list)
        _items = []
        if self.options:
            for _item_options in self.options:
                if _item_options:
                    _items.append(_item_options.to_dict())
            _dict['Options'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in taxes (list)
        _items = []
        if self.taxes:
            for _item_taxes in self.taxes:
                if _item_taxes:
                    _items.append(_item_taxes.to_dict())
            _dict['Taxes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChannelOrderItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "TaxCostInclusive": obj.get("TaxCostInclusive"),
            "UseChannelTax": obj.get("UseChannelTax"),
            "PricePerUnit": obj.get("PricePerUnit"),
            "PostalServiceCost": obj.get("PostalServiceCost"),
            "Qty": obj.get("Qty"),
            "TaxRate": obj.get("TaxRate"),
            "LineDiscount": obj.get("LineDiscount"),
            "LineRefund": obj.get("LineRefund"),
            "RefundQuantity": obj.get("RefundQuantity"),
            "ShippingRefund": obj.get("ShippingRefund"),
            "TotalRefund": obj.get("TotalRefund"),
            "ItemNumber": obj.get("ItemNumber"),
            "ChannelReferenceId": obj.get("ChannelReferenceId"),
            "ChannelSKU": obj.get("ChannelSKU"),
            "IsService": obj.get("IsService"),
            "ItemTitle": obj.get("ItemTitle"),
            "Options": [ChannelOrderItemOption.from_dict(_item) for _item in obj["Options"]] if obj.get("Options") is not None else None,
            "Taxes": [ChannelOrderItemTax.from_dict(_item) for _item in obj["Taxes"]] if obj.get("Taxes") is not None else None
        })
        return _obj


