# coding: utf-8

"""
    Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: orders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.orders.models.order_customer_info import OrderCustomerInfo
from linnworks_api.generated.orders.models.order_fulfillment_state import OrderFulfillmentState
from linnworks_api.generated.orders.models.order_general_info import OrderGeneralInfo
from linnworks_api.generated.orders.models.order_item import OrderItem
from linnworks_api.generated.orders.models.order_shipping_info import OrderShippingInfo
from linnworks_api.generated.orders.models.order_tax_info import OrderTaxInfo
from linnworks_api.generated.orders.models.order_totals_info import OrderTotalsInfo
from typing import Optional, Set
from typing_extensions import Self

class OpenOrder(BaseModel):
    """
    OpenOrder
    """ # noqa: E501
    num_order_id: Optional[StrictInt] = Field(default=None, alias="NumOrderId")
    general_info: Optional[OrderGeneralInfo] = Field(default=None, alias="GeneralInfo")
    shipping_info: Optional[OrderShippingInfo] = Field(default=None, alias="ShippingInfo")
    customer_info: Optional[OrderCustomerInfo] = Field(default=None, alias="CustomerInfo")
    totals_info: Optional[OrderTotalsInfo] = Field(default=None, alias="TotalsInfo")
    tax_info: Optional[OrderTaxInfo] = Field(default=None, alias="TaxInfo")
    folder_name: Optional[List[StrictStr]] = Field(default=None, alias="FolderName")
    is_post_filtered_out: Optional[StrictBool] = Field(default=None, alias="IsPostFilteredOut")
    can_fulfil: Optional[StrictBool] = Field(default=None, alias="CanFulfil")
    fulfillment: Optional[OrderFulfillmentState] = Field(default=None, alias="Fulfillment")
    items: Optional[List[OrderItem]] = Field(default=None, alias="Items")
    has_items: Optional[StrictBool] = Field(default=None, alias="HasItems")
    total_items_sum: Optional[StrictInt] = Field(default=None, alias="TotalItemsSum")
    order_id: Optional[StrictStr] = Field(default=None, alias="OrderId")
    __properties: ClassVar[List[str]] = ["NumOrderId", "GeneralInfo", "ShippingInfo", "CustomerInfo", "TotalsInfo", "TaxInfo", "FolderName", "IsPostFilteredOut", "CanFulfil", "Fulfillment", "Items", "HasItems", "TotalItemsSum", "OrderId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OpenOrder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "has_items",
            "total_items_sum",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of general_info
        if self.general_info:
            _dict['GeneralInfo'] = self.general_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of shipping_info
        if self.shipping_info:
            _dict['ShippingInfo'] = self.shipping_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of customer_info
        if self.customer_info:
            _dict['CustomerInfo'] = self.customer_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of totals_info
        if self.totals_info:
            _dict['TotalsInfo'] = self.totals_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tax_info
        if self.tax_info:
            _dict['TaxInfo'] = self.tax_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fulfillment
        if self.fulfillment:
            _dict['Fulfillment'] = self.fulfillment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['Items'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OpenOrder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "NumOrderId": obj.get("NumOrderId"),
            "GeneralInfo": OrderGeneralInfo.from_dict(obj["GeneralInfo"]) if obj.get("GeneralInfo") is not None else None,
            "ShippingInfo": OrderShippingInfo.from_dict(obj["ShippingInfo"]) if obj.get("ShippingInfo") is not None else None,
            "CustomerInfo": OrderCustomerInfo.from_dict(obj["CustomerInfo"]) if obj.get("CustomerInfo") is not None else None,
            "TotalsInfo": OrderTotalsInfo.from_dict(obj["TotalsInfo"]) if obj.get("TotalsInfo") is not None else None,
            "TaxInfo": OrderTaxInfo.from_dict(obj["TaxInfo"]) if obj.get("TaxInfo") is not None else None,
            "FolderName": obj.get("FolderName"),
            "IsPostFilteredOut": obj.get("IsPostFilteredOut"),
            "CanFulfil": obj.get("CanFulfil"),
            "Fulfillment": OrderFulfillmentState.from_dict(obj["Fulfillment"]) if obj.get("Fulfillment") is not None else None,
            "Items": [OrderItem.from_dict(_item) for _item in obj["Items"]] if obj.get("Items") is not None else None,
            "HasItems": obj.get("HasItems"),
            "TotalItemsSum": obj.get("TotalItemsSum"),
            "OrderId": obj.get("OrderId")
        })
        return _obj


