# coding: utf-8

"""
    Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: orders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.orders.models.order_packaging_split_item import OrderPackagingSplitItem
from typing import Optional, Set
from typing_extensions import Self

class OrderPackagingSplit(BaseModel):
    """
    OrderPackagingSplit
    """ # noqa: E501
    pk_bin_id: Optional[StrictStr] = Field(default=None, alias="pkBinId")
    pk_postal_service_id: Optional[StrictStr] = Field(default=None, alias="pkPostalServiceId")
    packaging_weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="PackagingWeight")
    fk_packaging_type_id: Optional[StrictStr] = Field(default=None, alias="fkPackagingTypeId")
    items: Optional[List[OrderPackagingSplitItem]] = Field(default=None, alias="Items")
    total_weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="TotalWeight")
    width: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Width")
    height: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Height")
    depth: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Depth")
    tracking_numbers: Optional[StrictStr] = Field(default=None, alias="TrackingNumbers")
    __properties: ClassVar[List[str]] = ["pkBinId", "pkPostalServiceId", "PackagingWeight", "fkPackagingTypeId", "Items", "TotalWeight", "Width", "Height", "Depth", "TrackingNumbers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrderPackagingSplit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "tracking_numbers",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['Items'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrderPackagingSplit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pkBinId": obj.get("pkBinId"),
            "pkPostalServiceId": obj.get("pkPostalServiceId"),
            "PackagingWeight": obj.get("PackagingWeight"),
            "fkPackagingTypeId": obj.get("fkPackagingTypeId"),
            "Items": [OrderPackagingSplitItem.from_dict(_item) for _item in obj["Items"]] if obj.get("Items") is not None else None,
            "TotalWeight": obj.get("TotalWeight"),
            "Width": obj.get("Width"),
            "Height": obj.get("Height"),
            "Depth": obj.get("Depth"),
            "TrackingNumbers": obj.get("TrackingNumbers")
        })
        return _obj


