# coding: utf-8

"""
    Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: orders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.orders.models.order_item_shipping_batch_with_row import OrderItemShippingBatchWithRow
from typing import Optional, Set
from typing_extensions import Self

class OrderPackagingSplitItem(BaseModel):
    """
    OrderPackagingSplitItem
    """ # noqa: E501
    assigned_batches: Optional[List[OrderItemShippingBatchWithRow]] = Field(default=None, alias="AssignedBatches")
    row_id: Optional[StrictStr] = Field(default=None, alias="RowId")
    box_id: Optional[StrictInt] = Field(default=None, alias="BoxId")
    quantity: Optional[StrictInt] = Field(default=None, alias="Quantity")
    tracking_number: Optional[StrictStr] = Field(default=None, alias="TrackingNumber")
    weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Weight")
    sku: Optional[StrictStr] = Field(default=None, alias="SKU")
    title: Optional[StrictStr] = Field(default=None, alias="Title")
    is_batched: Optional[StrictBool] = Field(default=None, alias="IsBatched")
    __properties: ClassVar[List[str]] = ["AssignedBatches", "RowId", "BoxId", "Quantity", "TrackingNumber", "Weight", "SKU", "Title", "IsBatched"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrderPackagingSplitItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "box_id",
            "is_batched",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in assigned_batches (list)
        _items = []
        if self.assigned_batches:
            for _item_assigned_batches in self.assigned_batches:
                if _item_assigned_batches:
                    _items.append(_item_assigned_batches.to_dict())
            _dict['AssignedBatches'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrderPackagingSplitItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "AssignedBatches": [OrderItemShippingBatchWithRow.from_dict(_item) for _item in obj["AssignedBatches"]] if obj.get("AssignedBatches") is not None else None,
            "RowId": obj.get("RowId"),
            "BoxId": obj.get("BoxId"),
            "Quantity": obj.get("Quantity"),
            "TrackingNumber": obj.get("TrackingNumber"),
            "Weight": obj.get("Weight"),
            "SKU": obj.get("SKU"),
            "Title": obj.get("Title"),
            "IsBatched": obj.get("IsBatched")
        })
        return _obj


