# coding: utf-8

"""
    Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: orders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.orders.models.order_split import OrderSplit
from typing import Optional, Set
from typing_extensions import Self

class OrdersSplitOrderRequest(BaseModel):
    """
    OrdersSplitOrderRequest
    """ # noqa: E501
    order_id: Optional[StrictStr] = Field(default=None, description="Order id", alias="orderId")
    new_orders: Optional[List[OrderSplit]] = Field(default=None, description="New orders", alias="newOrders")
    type: Optional[StrictStr] = Field(default=None, description="Split type")
    fulfilment_location_id: Optional[StrictStr] = Field(default=None, description="Current fulfilment center", alias="fulfilmentLocationId")
    recalc_packaging: Optional[StrictBool] = Field(default=None, description="Whether or not to recalculate the order packaging", alias="recalcPackaging")
    fulfillment_status: Optional[StrictStr] = Field(default=None, description="Optional, if provided the fulfillment status for the newly created orders will be set to this", alias="fulfillmentStatus")
    __properties: ClassVar[List[str]] = ["orderId", "newOrders", "type", "fulfilmentLocationId", "recalcPackaging", "fulfillmentStatus"]

    @field_validator('fulfillment_status')
    def fulfillment_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Unassigned', 'Assigned', 'Submitted', 'Accepted']):
            raise ValueError("must be one of enum values ('Unassigned', 'Assigned', 'Submitted', 'Accepted')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrdersSplitOrderRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in new_orders (list)
        _items = []
        if self.new_orders:
            for _item_new_orders in self.new_orders:
                if _item_new_orders:
                    _items.append(_item_new_orders.to_dict())
            _dict['newOrders'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrdersSplitOrderRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orderId": obj.get("orderId"),
            "newOrders": [OrderSplit.from_dict(_item) for _item in obj["newOrders"]] if obj.get("newOrders") is not None else None,
            "type": obj.get("type"),
            "fulfilmentLocationId": obj.get("fulfilmentLocationId"),
            "recalcPackaging": obj.get("recalcPackaging"),
            "fulfillmentStatus": obj.get("fulfillmentStatus")
        })
        return _obj


