# coding: utf-8

"""
    Picking API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: picking
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.picking.models.bin_rack_stock_item import BinRackStockItem
from linnworks_api.generated.picking.models.pick_wave_allocate_check_result import PickWaveAllocateCheckResult
from linnworks_api.generated.picking.models.picking_wave_detailed import PickingWaveDetailed
from linnworks_api.generated.picking.models.stock_item_info import StockItemInfo
from typing import Optional, Set
from typing_extensions import Self

class GeneratePickingWaveResponse(BaseModel):
    """
    GeneratePickingWaveResponse
    """ # noqa: E501
    validation_results: Optional[List[PickWaveAllocateCheckResult]] = Field(default=None, description="Validation errors if generate fails.", alias="ValidationResults")
    picking_waves: Optional[List[PickingWaveDetailed]] = Field(default=None, description="Pickwaves", alias="PickingWaves")
    skus: Optional[List[StockItemInfo]] = Field(default=None, description="List of SKUs.", alias="Skus")
    bins: Optional[List[BinRackStockItem]] = Field(default=None, description="List of bins and batches of items in the bins.", alias="Bins")
    __properties: ClassVar[List[str]] = ["ValidationResults", "PickingWaves", "Skus", "Bins"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GeneratePickingWaveResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in validation_results (list)
        _items = []
        if self.validation_results:
            for _item_validation_results in self.validation_results:
                if _item_validation_results:
                    _items.append(_item_validation_results.to_dict())
            _dict['ValidationResults'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in picking_waves (list)
        _items = []
        if self.picking_waves:
            for _item_picking_waves in self.picking_waves:
                if _item_picking_waves:
                    _items.append(_item_picking_waves.to_dict())
            _dict['PickingWaves'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in skus (list)
        _items = []
        if self.skus:
            for _item_skus in self.skus:
                if _item_skus:
                    _items.append(_item_skus.to_dict())
            _dict['Skus'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in bins (list)
        _items = []
        if self.bins:
            for _item_bins in self.bins:
                if _item_bins:
                    _items.append(_item_bins.to_dict())
            _dict['Bins'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GeneratePickingWaveResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ValidationResults": [PickWaveAllocateCheckResult.from_dict(_item) for _item in obj["ValidationResults"]] if obj.get("ValidationResults") is not None else None,
            "PickingWaves": [PickingWaveDetailed.from_dict(_item) for _item in obj["PickingWaves"]] if obj.get("PickingWaves") is not None else None,
            "Skus": [StockItemInfo.from_dict(_item) for _item in obj["Skus"]] if obj.get("Skus") is not None else None,
            "Bins": [BinRackStockItem.from_dict(_item) for _item in obj["Bins"]] if obj.get("Bins") is not None else None
        })
        return _obj


