# coding: utf-8

"""
    Picking API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: picking
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class GetPickingWavesRequest(BaseModel):
    """
    Request for getting all pickwaves irrespective of user.
    """ # noqa: E501
    state: Optional[StrictStr] = Field(default=None, description="Pickwave state (optional), if not supplied then all states.", alias="State")
    location_id: Optional[StrictStr] = Field(default=None, description="Location id for waves", alias="LocationId")
    detail_level: Optional[StrictStr] = Field(default=None, description="Detail level, if not supplied then all is assumed", alias="DetailLevel")
    __properties: ClassVar[List[str]] = ["State", "LocationId", "DetailLevel"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Unallocated', 'Allocated', 'InProgress', 'Paused', 'Complete', 'Abandoned', 'Packing', 'Shipped']):
            raise ValueError("must be one of enum values ('Unallocated', 'Allocated', 'InProgress', 'Paused', 'Complete', 'Abandoned', 'Packing', 'Shipped')")
        return value

    @field_validator('detail_level')
    def detail_level_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['All', 'OnlyPickWave']):
            raise ValueError("must be one of enum values ('All', 'OnlyPickWave')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetPickingWavesRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetPickingWavesRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "State": obj.get("State"),
            "LocationId": obj.get("LocationId"),
            "DetailLevel": obj.get("DetailLevel")
        })
        return _obj


