# coding: utf-8

"""
    Picking API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: picking
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.picking.models.picking_wave_generate_multi import PickingWaveGenerateMulti
from linnworks_api.generated.picking.models.picking_wave_generate_order import PickingWaveGenerateOrder
from typing import Optional, Set
from typing_extensions import Self

class PickingWaveGenerate(BaseModel):
    """
    PickingWaveGenerate
    """ # noqa: E501
    location_id: Optional[StrictStr] = Field(default=None, description="Location Id", alias="LocationId")
    user_id: Optional[StrictInt] = Field(default=None, description="Allocated user id", alias="UserId")
    sorting_type: Optional[StrictStr] = Field(default=None, alias="SortingType")
    orders: Optional[List[PickingWaveGenerateOrder]] = Field(default=None, description="Pickwave items", alias="Orders")
    pickwaves: Optional[List[PickingWaveGenerateMulti]] = Field(default=None, description="Collection of pickwaves and their orders to generate. All order singular or composite child row ids must be provided, if batches exist on the order item then batch id must be supplied);", alias="Pickwaves")
    group_type: Optional[StrictStr] = Field(default=None, description="Pickwave group type", alias="GroupType")
    __properties: ClassVar[List[str]] = ["LocationId", "UserId", "SortingType", "Orders", "Pickwaves", "GroupType"]

    @field_validator('sorting_type')
    def sorting_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['BinPriority', 'OrderView']):
            raise ValueError("must be one of enum values ('BinPriority', 'OrderView')")
        return value

    @field_validator('group_type')
    def group_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Items', 'Orders']):
            raise ValueError("must be one of enum values ('Items', 'Orders')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PickingWaveGenerate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in orders (list)
        _items = []
        if self.orders:
            for _item_orders in self.orders:
                if _item_orders:
                    _items.append(_item_orders.to_dict())
            _dict['Orders'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in pickwaves (list)
        _items = []
        if self.pickwaves:
            for _item_pickwaves in self.pickwaves:
                if _item_pickwaves:
                    _items.append(_item_pickwaves.to_dict())
            _dict['Pickwaves'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PickingWaveGenerate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "LocationId": obj.get("LocationId"),
            "UserId": obj.get("UserId"),
            "SortingType": obj.get("SortingType"),
            "Orders": [PickingWaveGenerateOrder.from_dict(_item) for _item in obj["Orders"]] if obj.get("Orders") is not None else None,
            "Pickwaves": [PickingWaveGenerateMulti.from_dict(_item) for _item in obj["Pickwaves"]] if obj.get("Pickwaves") is not None else None,
            "GroupType": obj.get("GroupType")
        })
        return _obj


