# coding: utf-8

"""
    Picking API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: picking
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PickingWaveUpdateRequest(BaseModel):
    """
    PickingWaveUpdateRequest
    """ # noqa: E501
    picking_wave_id: Optional[StrictInt] = Field(default=None, description="Pickwave id", alias="PickingWaveId")
    user_id: Optional[StrictInt] = Field(default=None, description="Allocated user id, null will keep the current assigned user, -1 will de-allocated the user from the pickwave.", alias="UserId")
    state: Optional[StrictStr] = Field(default=None, description="Current state of pickwave", alias="State")
    start_time: Optional[datetime] = Field(default=None, description="Start date time of pickwave", alias="StartTime")
    end_time: Optional[datetime] = Field(default=None, description="End date time of pickwave", alias="EndTime")
    __properties: ClassVar[List[str]] = ["PickingWaveId", "UserId", "State", "StartTime", "EndTime"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Unallocated', 'Allocated', 'InProgress', 'Paused', 'Complete', 'Abandoned', 'Packing', 'Shipped']):
            raise ValueError("must be one of enum values ('Unallocated', 'Allocated', 'InProgress', 'Paused', 'Complete', 'Abandoned', 'Packing', 'Shipped')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PickingWaveUpdateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PickingWaveUpdateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "PickingWaveId": obj.get("PickingWaveId"),
            "UserId": obj.get("UserId"),
            "State": obj.get("State"),
            "StartTime": obj.get("StartTime"),
            "EndTime": obj.get("EndTime")
        })
        return _obj


