# coding: utf-8

"""
    Print Service API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: printservice
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.printservice.models.print_error import PrintError
from typing import Optional, Set
from typing_extensions import Self

class CreatePDFResult(BaseModel):
    """
    CreatePDFResult
    """ # noqa: E501
    keyed_error: Optional[List[PrintError]] = Field(default=None, alias="KeyedError")
    url: Optional[StrictStr] = Field(default=None, description="URL to PDF file", alias="URL")
    ids_processed: Optional[List[StrictStr]] = Field(default=None, description="List of processed order or item IDs", alias="IdsProcessed")
    processed_ids: Optional[Dict[str, List[StrictStr]]] = Field(default=None, alias="ProcessedIds")
    page_count: Optional[StrictInt] = Field(default=None, alias="PageCount")
    print_errors: Optional[List[StrictStr]] = Field(default=None, description="List of OrderId / Error message", alias="PrintErrors")
    __properties: ClassVar[List[str]] = ["KeyedError", "URL", "IdsProcessed", "ProcessedIds", "PageCount", "PrintErrors"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreatePDFResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in keyed_error (list)
        _items = []
        if self.keyed_error:
            for _item_keyed_error in self.keyed_error:
                if _item_keyed_error:
                    _items.append(_item_keyed_error.to_dict())
            _dict['KeyedError'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreatePDFResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "KeyedError": [PrintError.from_dict(_item) for _item in obj["KeyedError"]] if obj.get("KeyedError") is not None else None,
            "URL": obj.get("URL"),
            "IdsProcessed": obj.get("IdsProcessed"),
            "ProcessedIds": obj.get("ProcessedIds"),
            "PageCount": obj.get("PageCount"),
            "PrintErrors": obj.get("PrintErrors")
        })
        return _obj


