# coding: utf-8

"""
    Print Service API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: printservice
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.printservice.models.key_value_string_int32 import KeyValueStringInt32
from typing import Optional, Set
from typing_extensions import Self

class PrintServiceCreateReturnShippingLabelsPDFWithSKUsRequest(BaseModel):
    """
    PrintServiceCreateReturnShippingLabelsPDFWithSKUsRequest
    """ # noqa: E501
    reference_num: Optional[StrictStr] = Field(default=None, description="Reference number of the order to print return labels for", alias="referenceNum")
    skus_and_quantities: Optional[List[KeyValueStringInt32]] = Field(default=None, description="A list of the SKUs and quantities to include. If empty then same as the outbound shipment", alias="SKUsAndQuantities")
    return_postal_service_name: Optional[StrictStr] = Field(default=None, description="Name of the postal service to use. If null then specified in settings or same as the outbound shipment", alias="returnPostalServiceName")
    __properties: ClassVar[List[str]] = ["referenceNum", "SKUsAndQuantities", "returnPostalServiceName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PrintServiceCreateReturnShippingLabelsPDFWithSKUsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in skus_and_quantities (list)
        _items = []
        if self.skus_and_quantities:
            for _item_skus_and_quantities in self.skus_and_quantities:
                if _item_skus_and_quantities:
                    _items.append(_item_skus_and_quantities.to_dict())
            _dict['SKUsAndQuantities'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PrintServiceCreateReturnShippingLabelsPDFWithSKUsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "referenceNum": obj.get("referenceNum"),
            "SKUsAndQuantities": [KeyValueStringInt32.from_dict(_item) for _item in obj["SKUsAndQuantities"]] if obj.get("SKUsAndQuantities") is not None else None,
            "returnPostalServiceName": obj.get("returnPostalServiceName")
        })
        return _obj


