# coding: utf-8

"""
    Processed Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: processedorders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.processedorders.models.order_item_return_info_batched import OrderItemReturnInfoBatched
from typing import Optional, Set
from typing_extensions import Self

class OrderItemReturnInfo(BaseModel):
    """
    OrderItemReturnInfo
    """ # noqa: E501
    child_items: Optional[List[OrderItemReturnInfo]] = Field(default=None, alias="ChildItems")
    batches: Optional[List[OrderItemReturnInfoBatched]] = Field(default=None, alias="Batches")
    order_id: Optional[StrictStr] = Field(default=None, alias="OrderId")
    fk_order_item_row_id: Optional[StrictStr] = Field(default=None, alias="fkOrderItemRowId")
    parent_row_id: Optional[StrictStr] = Field(default=None, alias="ParentRowId")
    returnable_qty: Optional[StrictInt] = Field(default=None, alias="ReturnableQty")
    order_qty: Optional[StrictInt] = Field(default=None, alias="OrderQty")
    returned_qty: Optional[StrictInt] = Field(default=None, alias="ReturnedQty")
    sku: Optional[StrictStr] = Field(default=None, alias="SKU")
    item_title: Optional[StrictStr] = Field(default=None, alias="ItemTitle")
    unit_value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="UnitValue")
    tax_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="TaxRate")
    tax_cost_inclusive: Optional[StrictBool] = Field(default=None, alias="TaxCostInclusive")
    currency: Optional[StrictStr] = Field(default=None, alias="Currency")
    is_composite_parent: Optional[StrictBool] = Field(default=None, alias="IsCompositeParent")
    is_partial_composite_return: Optional[StrictBool] = Field(default=None, alias="IsPartialCompositeReturn")
    parent_ratio: Optional[StrictInt] = Field(default=None, alias="ParentRatio")
    pk_stock_item_id: Optional[StrictStr] = Field(default=None, alias="pkStockItemId")
    resent_qty: Optional[StrictInt] = Field(default=None, alias="ResentQty")
    fk_refund_row_id: Optional[StrictStr] = Field(default=None, alias="fkRefundRowId")
    __properties: ClassVar[List[str]] = ["ChildItems", "Batches", "OrderId", "fkOrderItemRowId", "ParentRowId", "ReturnableQty", "OrderQty", "ReturnedQty", "SKU", "ItemTitle", "UnitValue", "TaxRate", "TaxCostInclusive", "Currency", "IsCompositeParent", "IsPartialCompositeReturn", "ParentRatio", "pkStockItemId", "ResentQty", "fkRefundRowId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrderItemReturnInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "order_id",
            "returnable_qty",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in child_items (list)
        _items = []
        if self.child_items:
            for _item_child_items in self.child_items:
                if _item_child_items:
                    _items.append(_item_child_items.to_dict())
            _dict['ChildItems'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in batches (list)
        _items = []
        if self.batches:
            for _item_batches in self.batches:
                if _item_batches:
                    _items.append(_item_batches.to_dict())
            _dict['Batches'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrderItemReturnInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ChildItems": [OrderItemReturnInfo.from_dict(_item) for _item in obj["ChildItems"]] if obj.get("ChildItems") is not None else None,
            "Batches": [OrderItemReturnInfoBatched.from_dict(_item) for _item in obj["Batches"]] if obj.get("Batches") is not None else None,
            "OrderId": obj.get("OrderId"),
            "fkOrderItemRowId": obj.get("fkOrderItemRowId"),
            "ParentRowId": obj.get("ParentRowId"),
            "ReturnableQty": obj.get("ReturnableQty"),
            "OrderQty": obj.get("OrderQty"),
            "ReturnedQty": obj.get("ReturnedQty"),
            "SKU": obj.get("SKU"),
            "ItemTitle": obj.get("ItemTitle"),
            "UnitValue": obj.get("UnitValue"),
            "TaxRate": obj.get("TaxRate"),
            "TaxCostInclusive": obj.get("TaxCostInclusive"),
            "Currency": obj.get("Currency"),
            "IsCompositeParent": obj.get("IsCompositeParent"),
            "IsPartialCompositeReturn": obj.get("IsPartialCompositeReturn"),
            "ParentRatio": obj.get("ParentRatio"),
            "pkStockItemId": obj.get("pkStockItemId"),
            "ResentQty": obj.get("ResentQty"),
            "fkRefundRowId": obj.get("fkRefundRowId")
        })
        return _obj

# TODO: Rewrite to not use raise_errors
OrderItemReturnInfo.model_rebuild(raise_errors=False)

