# coding: utf-8

"""
    Processed Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: processedorders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.processedorders.models.row_qty import RowQty
from typing import Optional, Set
from typing_extensions import Self

class ProcessedOrdersCreateExchangeRequest(BaseModel):
    """
    ProcessedOrdersCreateExchangeRequest
    """ # noqa: E501
    pk_order_id: Optional[StrictStr] = Field(default=None, description="The order id", alias="pkOrderId")
    exchange_items: Optional[List[RowQty]] = Field(default=None, description="A list of items to be exchanged, including quantity, scrap, refund, etc.", alias="exchangeItems")
    despatch_location: Optional[StrictStr] = Field(default=None, description="The id of the location to despatch replacement items from", alias="despatchLocation")
    return_location: Optional[StrictStr] = Field(default=None, description="The id of the location to return stock to", alias="returnLocation")
    channel_reason: Optional[StrictStr] = Field(default=None, description="Channel reason - required if a refund on the channel is required", alias="channelReason")
    channel_sub_reason: Optional[StrictStr] = Field(default=None, description="Channel subreason - required if a refund on the channel is required.", alias="channelSubReason")
    category: Optional[StrictStr] = Field(default=None, description="The refund category")
    reason: Optional[StrictStr] = Field(default=None, description="The reason for the reason")
    is_booking: Optional[StrictBool] = Field(default=None, description="True if it is a exchange booking, False if it is a new exchange", alias="isBooking")
    ignored_validation: Optional[StrictBool] = Field(default=None, description="True if failed validation has been ignored (see IsRefundValid). Otherwise, false. When set to true, refunds will not be automatically actioned on the channel. Ignored if creating a booking as a refund is not created at this stage.", alias="ignoredValidation")
    __properties: ClassVar[List[str]] = ["pkOrderId", "exchangeItems", "despatchLocation", "returnLocation", "channelReason", "channelSubReason", "category", "reason", "isBooking", "ignoredValidation"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProcessedOrdersCreateExchangeRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in exchange_items (list)
        _items = []
        if self.exchange_items:
            for _item_exchange_items in self.exchange_items:
                if _item_exchange_items:
                    _items.append(_item_exchange_items.to_dict())
            _dict['exchangeItems'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProcessedOrdersCreateExchangeRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pkOrderId": obj.get("pkOrderId"),
            "exchangeItems": [RowQty.from_dict(_item) for _item in obj["exchangeItems"]] if obj.get("exchangeItems") is not None else None,
            "despatchLocation": obj.get("despatchLocation"),
            "returnLocation": obj.get("returnLocation"),
            "channelReason": obj.get("channelReason"),
            "channelSubReason": obj.get("channelSubReason"),
            "category": obj.get("category"),
            "reason": obj.get("reason"),
            "isBooking": obj.get("isBooking"),
            "ignoredValidation": obj.get("ignoredValidation")
        })
        return _obj


