# coding: utf-8

"""
    Processed Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: processedorders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class RefundInfo(BaseModel):
    """
    RefundInfo
    """ # noqa: E501
    pk_refund_row_id: Optional[StrictStr] = Field(default=None, alias="pkRefundRowId")
    sku: Optional[StrictStr] = Field(default=None, alias="SKU")
    item_title: Optional[StrictStr] = Field(default=None, alias="ItemTitle")
    is_item: Optional[StrictBool] = Field(default=None, alias="IsItem")
    is_service: Optional[StrictBool] = Field(default=None, alias="IsService")
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Amount")
    reason: Optional[StrictStr] = Field(default=None, alias="Reason")
    actioned: Optional[StrictBool] = Field(default=None, alias="Actioned")
    action_date: Optional[datetime] = Field(default=None, alias="ActionDate")
    return_reference: Optional[StrictStr] = Field(default=None, alias="ReturnReference")
    cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Cost")
    refund_status: Optional[StrictStr] = Field(default=None, alias="RefundStatus")
    ignored_validation: Optional[StrictBool] = Field(default=None, alias="IgnoredValidation")
    fk_order_item_row_id: Optional[StrictStr] = Field(default=None, alias="fkOrderItemRowId")
    should_serialize_channel_reason: Optional[StrictBool] = Field(default=None, alias="ShouldSerializeChannelReason")
    channel_reason: Optional[StrictStr] = Field(default=None, alias="ChannelReason")
    should_serialize_channel_reason_sec: Optional[StrictBool] = Field(default=None, alias="ShouldSerializeChannelReasonSec")
    channel_reason_sec: Optional[StrictStr] = Field(default=None, alias="ChannelReasonSec")
    is_new: Optional[StrictBool] = Field(default=None, alias="IsNew")
    __properties: ClassVar[List[str]] = ["pkRefundRowId", "SKU", "ItemTitle", "IsItem", "IsService", "Amount", "Reason", "Actioned", "ActionDate", "ReturnReference", "Cost", "RefundStatus", "IgnoredValidation", "fkOrderItemRowId", "ShouldSerializeChannelReason", "ChannelReason", "ShouldSerializeChannelReasonSec", "ChannelReasonSec", "IsNew"]

    @field_validator('refund_status')
    def refund_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['OPEN', 'PROCESSED', 'ERROR', 'ERROR_ACKED', 'PENDING']):
            raise ValueError("must be one of enum values ('OPEN', 'PROCESSED', 'ERROR', 'ERROR_ACKED', 'PENDING')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RefundInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "should_serialize_channel_reason",
            "should_serialize_channel_reason_sec",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RefundInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pkRefundRowId": obj.get("pkRefundRowId"),
            "SKU": obj.get("SKU"),
            "ItemTitle": obj.get("ItemTitle"),
            "IsItem": obj.get("IsItem"),
            "IsService": obj.get("IsService"),
            "Amount": obj.get("Amount"),
            "Reason": obj.get("Reason"),
            "Actioned": obj.get("Actioned"),
            "ActionDate": obj.get("ActionDate"),
            "ReturnReference": obj.get("ReturnReference"),
            "Cost": obj.get("Cost"),
            "RefundStatus": obj.get("RefundStatus"),
            "IgnoredValidation": obj.get("IgnoredValidation"),
            "fkOrderItemRowId": obj.get("fkOrderItemRowId"),
            "ShouldSerializeChannelReason": obj.get("ShouldSerializeChannelReason"),
            "ChannelReason": obj.get("ChannelReason"),
            "ShouldSerializeChannelReasonSec": obj.get("ShouldSerializeChannelReasonSec"),
            "ChannelReasonSec": obj.get("ChannelReasonSec"),
            "IsNew": obj.get("IsNew")
        })
        return _obj


