# coding: utf-8

"""
    Processed Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: processedorders
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.processedorders.models.channel_refund_reason import ChannelRefundReason
from linnworks_api.generated.processedorders.models.channel_refund_sub_reason import ChannelRefundSubReason
from typing import Optional, Set
from typing_extensions import Self

class ServiceItem(BaseModel):
    """
    ServiceItem
    """ # noqa: E501
    pk_order_item_row_id: Optional[StrictStr] = Field(default=None, alias="pkOrderItemRowId")
    service_name: Optional[StrictStr] = Field(default=None, alias="ServiceName")
    service_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ServiceCost")
    default_channel_reason: Optional[ChannelRefundReason] = Field(default=None, alias="DefaultChannelReason")
    default_channel_sub_reason: Optional[ChannelRefundSubReason] = Field(default=None, alias="DefaultChannelSubReason")
    item_number: Optional[StrictStr] = Field(default=None, alias="ItemNumber")
    allows_automated_refund: Optional[StrictBool] = Field(default=None, alias="AllowsAutomatedRefund")
    __properties: ClassVar[List[str]] = ["pkOrderItemRowId", "ServiceName", "ServiceCost", "DefaultChannelReason", "DefaultChannelSubReason", "ItemNumber", "AllowsAutomatedRefund"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ServiceItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of default_channel_reason
        if self.default_channel_reason:
            _dict['DefaultChannelReason'] = self.default_channel_reason.to_dict()
        # override the default output from pydantic by calling `to_dict()` of default_channel_sub_reason
        if self.default_channel_sub_reason:
            _dict['DefaultChannelSubReason'] = self.default_channel_sub_reason.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ServiceItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pkOrderItemRowId": obj.get("pkOrderItemRowId"),
            "ServiceName": obj.get("ServiceName"),
            "ServiceCost": obj.get("ServiceCost"),
            "DefaultChannelReason": ChannelRefundReason.from_dict(obj["DefaultChannelReason"]) if obj.get("DefaultChannelReason") is not None else None,
            "DefaultChannelSubReason": ChannelRefundSubReason.from_dict(obj["DefaultChannelSubReason"]) if obj.get("DefaultChannelSubReason") is not None else None,
            "ItemNumber": obj.get("ItemNumber"),
            "AllowsAutomatedRefund": obj.get("AllowsAutomatedRefund")
        })
        return _obj


