# linnworks_api.generated.purchaseorder.PurchaseOrderApi

All URIs are relative to *https://eu-ext.linnworks.net*

Method | HTTP request | Description
------------- | ------------- | -------------
[**add_additional_cost_types**](PurchaseOrderApi.md#add_additional_cost_types) | **POST** /api/PurchaseOrder/Add_AdditionalCostTypes | Add_AdditionalCostTypes
[**add_purchase_order_extended_property**](PurchaseOrderApi.md#add_purchase_order_extended_property) | **POST** /api/PurchaseOrder/Add_PurchaseOrderExtendedProperty | Add_PurchaseOrderExtendedProperty
[**add_purchase_order_item**](PurchaseOrderApi.md#add_purchase_order_item) | **POST** /api/PurchaseOrder/Add_PurchaseOrderItem | Add_PurchaseOrderItem
[**add_purchase_order_note**](PurchaseOrderApi.md#add_purchase_order_note) | **POST** /api/PurchaseOrder/Add_PurchaseOrderNote | Add_PurchaseOrderNote
[**change_purchase_order_status**](PurchaseOrderApi.md#change_purchase_order_status) | **POST** /api/PurchaseOrder/Change_PurchaseOrderStatus | Change_PurchaseOrderStatus
[**create_pos_from_inventory**](PurchaseOrderApi.md#create_pos_from_inventory) | **POST** /api/PurchaseOrder/CreatePOsFromInventory | CreatePOsFromInventory
[**create_purchase_order_initial**](PurchaseOrderApi.md#create_purchase_order_initial) | **POST** /api/PurchaseOrder/Create_PurchaseOrder_Initial | Create_PurchaseOrder_Initial
[**delete_additional_cost_types**](PurchaseOrderApi.md#delete_additional_cost_types) | **POST** /api/PurchaseOrder/Delete_AdditionalCostTypes | Delete_AdditionalCostTypes
[**delete_purchase_order**](PurchaseOrderApi.md#delete_purchase_order) | **POST** /api/PurchaseOrder/Delete_PurchaseOrder | Delete_PurchaseOrder
[**delete_purchase_order_extended_property**](PurchaseOrderApi.md#delete_purchase_order_extended_property) | **POST** /api/PurchaseOrder/Delete_PurchaseOrderExtendedProperty | Delete_PurchaseOrderExtendedProperty
[**delete_purchase_order_item**](PurchaseOrderApi.md#delete_purchase_order_item) | **POST** /api/PurchaseOrder/Delete_PurchaseOrderItem | Delete_PurchaseOrderItem
[**delete_purchase_order_note**](PurchaseOrderApi.md#delete_purchase_order_note) | **POST** /api/PurchaseOrder/Delete_PurchaseOrderNote | Delete_PurchaseOrderNote
[**deliver_purchase_item**](PurchaseOrderApi.md#deliver_purchase_item) | **POST** /api/PurchaseOrder/Deliver_PurchaseItem | Deliver_PurchaseItem
[**deliver_purchase_item_all**](PurchaseOrderApi.md#deliver_purchase_item_all) | **POST** /api/PurchaseOrder/Deliver_PurchaseItemAll | Deliver_PurchaseItemAll
[**deliver_purchase_item_all_except_batch_items**](PurchaseOrderApi.md#deliver_purchase_item_all_except_batch_items) | **POST** /api/PurchaseOrder/Deliver_PurchaseItemAll_ExceptBatchItems | Deliver_PurchaseItemAll_ExceptBatchItems
[**deliver_purchase_items_with_quantity**](PurchaseOrderApi.md#deliver_purchase_items_with_quantity) | **POST** /api/PurchaseOrder/Deliver_PurchaseItems_WithQuantity | Deliver_PurchaseItems_WithQuantity
[**export_purchase_order**](PurchaseOrderApi.md#export_purchase_order) | **POST** /api/PurchaseOrder/ExportPurchaseOrder | ExportPurchaseOrder
[**find_stock_item**](PurchaseOrderApi.md#find_stock_item) | **POST** /api/PurchaseOrder/FindStockItem | FindStockItem
[**get_additional_cost**](PurchaseOrderApi.md#get_additional_cost) | **POST** /api/PurchaseOrder/Get_Additional_Cost | Get_Additional_Cost
[**get_additional_cost_types**](PurchaseOrderApi.md#get_additional_cost_types) | **POST** /api/PurchaseOrder/Get_AdditionalCostTypes | Get_AdditionalCostTypes
[**get_delivered_records**](PurchaseOrderApi.md#get_delivered_records) | **POST** /api/PurchaseOrder/Get_DeliveredRecords | Get_DeliveredRecords
[**get_email_csv_file**](PurchaseOrderApi.md#get_email_csv_file) | **POST** /api/PurchaseOrder/Get_EmailCSVFile | Get_EmailCSVFile
[**get_emails_sent**](PurchaseOrderApi.md#get_emails_sent) | **POST** /api/PurchaseOrder/Get_EmailsSent | Get_EmailsSent
[**get_payment_statement**](PurchaseOrderApi.md#get_payment_statement) | **POST** /api/PurchaseOrder/Get_Payment_Statement | Get_Payment_Statement
[**get_purchase_order**](PurchaseOrderApi.md#get_purchase_order) | **POST** /api/PurchaseOrder/Get_PurchaseOrder | Get_PurchaseOrder
[**get_purchase_order_audit**](PurchaseOrderApi.md#get_purchase_order_audit) | **POST** /api/PurchaseOrder/Get_PurchaseOrderAudit | Get_PurchaseOrderAudit
[**get_purchase_order_extended_property**](PurchaseOrderApi.md#get_purchase_order_extended_property) | **POST** /api/PurchaseOrder/Get_PurchaseOrderExtendedProperty | Get_PurchaseOrderExtendedProperty
[**get_purchase_order_note**](PurchaseOrderApi.md#get_purchase_order_note) | **POST** /api/PurchaseOrder/Get_PurchaseOrderNote | Get_PurchaseOrderNote
[**get_purchase_order_status_list**](PurchaseOrderApi.md#get_purchase_order_status_list) | **POST** /api/PurchaseOrder/GetPurchaseOrderStatusList | GetPurchaseOrderStatusList
[**get_purchase_orders_with_stock_items**](PurchaseOrderApi.md#get_purchase_orders_with_stock_items) | **POST** /api/PurchaseOrder/GetPurchaseOrdersWithStockItems | GetPurchaseOrdersWithStockItems
[**modify_additional_cost**](PurchaseOrderApi.md#modify_additional_cost) | **POST** /api/PurchaseOrder/Modify_AdditionalCost | Modify_AdditionalCost
[**modify_additional_cost_allocation**](PurchaseOrderApi.md#modify_additional_cost_allocation) | **POST** /api/PurchaseOrder/Modify_AdditionalCostAllocation | Modify_AdditionalCostAllocation
[**modify_payment_statement**](PurchaseOrderApi.md#modify_payment_statement) | **POST** /api/PurchaseOrder/Modify_PaymentStatement | Modify_PaymentStatement
[**modify_purchase_order_items_bulk**](PurchaseOrderApi.md#modify_purchase_order_items_bulk) | **POST** /api/PurchaseOrder/Modify_PurchaseOrderItems_Bulk | Modify_PurchaseOrderItems_Bulk
[**search_purchase_orders**](PurchaseOrderApi.md#search_purchase_orders) | **POST** /api/PurchaseOrder/Search_PurchaseOrders | Search_PurchaseOrders
[**search_purchase_orders2**](PurchaseOrderApi.md#search_purchase_orders2) | **POST** /api/PurchaseOrder/Search_PurchaseOrders2 | Search_PurchaseOrders2
[**update_additional_cost_types**](PurchaseOrderApi.md#update_additional_cost_types) | **POST** /api/PurchaseOrder/Update_AdditionalCostTypes | Update_AdditionalCostTypes
[**update_purchase_order_extended_property**](PurchaseOrderApi.md#update_purchase_order_extended_property) | **POST** /api/PurchaseOrder/Update_PurchaseOrderExtendedProperty | Update_PurchaseOrderExtendedProperty
[**update_purchase_order_header**](PurchaseOrderApi.md#update_purchase_order_header) | **POST** /api/PurchaseOrder/Update_PurchaseOrderHeader | Update_PurchaseOrderHeader
[**update_purchase_order_item**](PurchaseOrderApi.md#update_purchase_order_item) | **POST** /api/PurchaseOrder/Update_PurchaseOrderItem | Update_PurchaseOrderItem


# **add_additional_cost_types**
> AddAdditionalCostTypesResponse add_additional_cost_types(purchase_order_add_additional_cost_types_request)

Add_AdditionalCostTypes

Add new additional cost type <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.ChangeAdditionalTypesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.add_additional_cost_types_response import AddAdditionalCostTypesResponse
from linnworks_api.generated.purchaseorder.models.purchase_order_add_additional_cost_types_request import PurchaseOrderAddAdditionalCostTypesRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_add_additional_cost_types_request = linnworks_api.generated.purchaseorder.PurchaseOrderAddAdditionalCostTypesRequest() # PurchaseOrderAddAdditionalCostTypesRequest | 

    try:
        # Add_AdditionalCostTypes
        api_response = api_instance.add_additional_cost_types(purchase_order_add_additional_cost_types_request)
        print("The response of PurchaseOrderApi->add_additional_cost_types:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->add_additional_cost_types: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_add_additional_cost_types_request** | [**PurchaseOrderAddAdditionalCostTypesRequest**](PurchaseOrderAddAdditionalCostTypesRequest.md)|  | 

### Return type

[**AddAdditionalCostTypesResponse**](AddAdditionalCostTypesResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **add_purchase_order_extended_property**
> AddPurchaseOrderExtendedPropertyResponse add_purchase_order_extended_property(purchase_order_add_purchase_order_extended_property_request)

Add_PurchaseOrderExtendedProperty

Adds extended properties to a purchase order. Property name must be unique otherwise the method throws an error. Maxium number of extended properties allowed for a single purchase order is 50. If total count of extended properties exceeds 50 an error will be thrown. <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.EditPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.add_purchase_order_extended_property_response import AddPurchaseOrderExtendedPropertyResponse
from linnworks_api.generated.purchaseorder.models.purchase_order_add_purchase_order_extended_property_request import PurchaseOrderAddPurchaseOrderExtendedPropertyRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_add_purchase_order_extended_property_request = linnworks_api.generated.purchaseorder.PurchaseOrderAddPurchaseOrderExtendedPropertyRequest() # PurchaseOrderAddPurchaseOrderExtendedPropertyRequest | 

    try:
        # Add_PurchaseOrderExtendedProperty
        api_response = api_instance.add_purchase_order_extended_property(purchase_order_add_purchase_order_extended_property_request)
        print("The response of PurchaseOrderApi->add_purchase_order_extended_property:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->add_purchase_order_extended_property: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_add_purchase_order_extended_property_request** | [**PurchaseOrderAddPurchaseOrderExtendedPropertyRequest**](PurchaseOrderAddPurchaseOrderExtendedPropertyRequest.md)|  | 

### Return type

[**AddPurchaseOrderExtendedPropertyResponse**](AddPurchaseOrderExtendedPropertyResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **add_purchase_order_item**
> UpdatePurchaseOrderItemResponse add_purchase_order_item(purchase_order_add_purchase_order_item_request)

Add_PurchaseOrderItem

Method adds purchase order item to an existing PENDING order. Items can only be added to PENDING purchase orders. Returns class that represents modified/recalculated purchase order header and modified purchase order item line <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.EditPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.purchase_order_add_purchase_order_item_request import PurchaseOrderAddPurchaseOrderItemRequest
from linnworks_api.generated.purchaseorder.models.update_purchase_order_item_response import UpdatePurchaseOrderItemResponse
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_add_purchase_order_item_request = linnworks_api.generated.purchaseorder.PurchaseOrderAddPurchaseOrderItemRequest() # PurchaseOrderAddPurchaseOrderItemRequest | 

    try:
        # Add_PurchaseOrderItem
        api_response = api_instance.add_purchase_order_item(purchase_order_add_purchase_order_item_request)
        print("The response of PurchaseOrderApi->add_purchase_order_item:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->add_purchase_order_item: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_add_purchase_order_item_request** | [**PurchaseOrderAddPurchaseOrderItemRequest**](PurchaseOrderAddPurchaseOrderItemRequest.md)|  | 

### Return type

[**UpdatePurchaseOrderItemResponse**](UpdatePurchaseOrderItemResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **add_purchase_order_note**
> PurchaseOrderNote add_purchase_order_note(purchase_order_add_purchase_order_note_request)

Add_PurchaseOrderNote

Add purchase order note <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.EditPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.purchase_order_add_purchase_order_note_request import PurchaseOrderAddPurchaseOrderNoteRequest
from linnworks_api.generated.purchaseorder.models.purchase_order_note import PurchaseOrderNote
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_add_purchase_order_note_request = linnworks_api.generated.purchaseorder.PurchaseOrderAddPurchaseOrderNoteRequest() # PurchaseOrderAddPurchaseOrderNoteRequest | 

    try:
        # Add_PurchaseOrderNote
        api_response = api_instance.add_purchase_order_note(purchase_order_add_purchase_order_note_request)
        print("The response of PurchaseOrderApi->add_purchase_order_note:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->add_purchase_order_note: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_add_purchase_order_note_request** | [**PurchaseOrderAddPurchaseOrderNoteRequest**](PurchaseOrderAddPurchaseOrderNoteRequest.md)|  | 

### Return type

[**PurchaseOrderNote**](PurchaseOrderNote.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **change_purchase_order_status**
> CommonPurchaseOrderHeader change_purchase_order_status(purchase_order_change_purchase_order_status_request)

Change_PurchaseOrderStatus

Change purchase order status. Can change from:  PENDING to OPEN, which will populate Due (OnOrder) values in stock levels,  OPEN to DELIVERED, which will consolidate Due values in stock levels  PARTIAL to DELIVERED, which will consolidate Due values in stock levels <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.EditPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.common_purchase_order_header import CommonPurchaseOrderHeader
from linnworks_api.generated.purchaseorder.models.purchase_order_change_purchase_order_status_request import PurchaseOrderChangePurchaseOrderStatusRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_change_purchase_order_status_request = linnworks_api.generated.purchaseorder.PurchaseOrderChangePurchaseOrderStatusRequest() # PurchaseOrderChangePurchaseOrderStatusRequest | 

    try:
        # Change_PurchaseOrderStatus
        api_response = api_instance.change_purchase_order_status(purchase_order_change_purchase_order_status_request)
        print("The response of PurchaseOrderApi->change_purchase_order_status:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->change_purchase_order_status: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_change_purchase_order_status_request** | [**PurchaseOrderChangePurchaseOrderStatusRequest**](PurchaseOrderChangePurchaseOrderStatusRequest.md)|  | 

### Return type

[**CommonPurchaseOrderHeader**](CommonPurchaseOrderHeader.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_pos_from_inventory**
> CreatePOsFromInventoryResponse create_pos_from_inventory(purchase_order_create_pos_from_inventory_request)

CreatePOsFromInventory

 <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.EditPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.create_pos_from_inventory_response import CreatePOsFromInventoryResponse
from linnworks_api.generated.purchaseorder.models.purchase_order_create_pos_from_inventory_request import PurchaseOrderCreatePOsFromInventoryRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_create_pos_from_inventory_request = linnworks_api.generated.purchaseorder.PurchaseOrderCreatePOsFromInventoryRequest() # PurchaseOrderCreatePOsFromInventoryRequest | 

    try:
        # CreatePOsFromInventory
        api_response = api_instance.create_pos_from_inventory(purchase_order_create_pos_from_inventory_request)
        print("The response of PurchaseOrderApi->create_pos_from_inventory:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->create_pos_from_inventory: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_create_pos_from_inventory_request** | [**PurchaseOrderCreatePOsFromInventoryRequest**](PurchaseOrderCreatePOsFromInventoryRequest.md)|  | 

### Return type

[**CreatePOsFromInventoryResponse**](CreatePOsFromInventoryResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_purchase_order_initial**
> str create_purchase_order_initial(purchase_order_create_purchase_order_initial_request)

Create_PurchaseOrder_Initial

Creates initial purchase order in pending status. Once PO is created you can add stock items to it. <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.EditPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.purchase_order_create_purchase_order_initial_request import PurchaseOrderCreatePurchaseOrderInitialRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_create_purchase_order_initial_request = linnworks_api.generated.purchaseorder.PurchaseOrderCreatePurchaseOrderInitialRequest() # PurchaseOrderCreatePurchaseOrderInitialRequest | 

    try:
        # Create_PurchaseOrder_Initial
        api_response = api_instance.create_purchase_order_initial(purchase_order_create_purchase_order_initial_request)
        print("The response of PurchaseOrderApi->create_purchase_order_initial:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->create_purchase_order_initial: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_create_purchase_order_initial_request** | [**PurchaseOrderCreatePurchaseOrderInitialRequest**](PurchaseOrderCreatePurchaseOrderInitialRequest.md)|  | 

### Return type

**str**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_additional_cost_types**
> delete_additional_cost_types(purchase_order_delete_additional_cost_types_request)

Delete_AdditionalCostTypes

Delete additional cost type <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.ChangeAdditionalTypesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.purchase_order_delete_additional_cost_types_request import PurchaseOrderDeleteAdditionalCostTypesRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_delete_additional_cost_types_request = linnworks_api.generated.purchaseorder.PurchaseOrderDeleteAdditionalCostTypesRequest() # PurchaseOrderDeleteAdditionalCostTypesRequest | 

    try:
        # Delete_AdditionalCostTypes
        api_instance.delete_additional_cost_types(purchase_order_delete_additional_cost_types_request)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->delete_additional_cost_types: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_delete_additional_cost_types_request** | [**PurchaseOrderDeleteAdditionalCostTypesRequest**](PurchaseOrderDeleteAdditionalCostTypesRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_purchase_order**
> delete_purchase_order(purchase_order_delete_purchase_order_request)

Delete_PurchaseOrder

Delete a Purchase Order <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.EditPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.purchase_order_delete_purchase_order_request import PurchaseOrderDeletePurchaseOrderRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_delete_purchase_order_request = linnworks_api.generated.purchaseorder.PurchaseOrderDeletePurchaseOrderRequest() # PurchaseOrderDeletePurchaseOrderRequest | 

    try:
        # Delete_PurchaseOrder
        api_instance.delete_purchase_order(purchase_order_delete_purchase_order_request)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->delete_purchase_order: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_delete_purchase_order_request** | [**PurchaseOrderDeletePurchaseOrderRequest**](PurchaseOrderDeletePurchaseOrderRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_purchase_order_extended_property**
> delete_purchase_order_extended_property(purchase_order_delete_purchase_order_extended_property_request)

Delete_PurchaseOrderExtendedProperty

Delete extended property items by id <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.EditPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.purchase_order_delete_purchase_order_extended_property_request import PurchaseOrderDeletePurchaseOrderExtendedPropertyRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_delete_purchase_order_extended_property_request = linnworks_api.generated.purchaseorder.PurchaseOrderDeletePurchaseOrderExtendedPropertyRequest() # PurchaseOrderDeletePurchaseOrderExtendedPropertyRequest | 

    try:
        # Delete_PurchaseOrderExtendedProperty
        api_instance.delete_purchase_order_extended_property(purchase_order_delete_purchase_order_extended_property_request)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->delete_purchase_order_extended_property: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_delete_purchase_order_extended_property_request** | [**PurchaseOrderDeletePurchaseOrderExtendedPropertyRequest**](PurchaseOrderDeletePurchaseOrderExtendedPropertyRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_purchase_order_item**
> CommonPurchaseOrderHeader delete_purchase_order_item(purchase_order_delete_purchase_order_item_request)

Delete_PurchaseOrderItem

Delete purchase order item line from PENDING order. Returns recalculated/modified purchase order header <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.EditPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.common_purchase_order_header import CommonPurchaseOrderHeader
from linnworks_api.generated.purchaseorder.models.purchase_order_delete_purchase_order_item_request import PurchaseOrderDeletePurchaseOrderItemRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_delete_purchase_order_item_request = linnworks_api.generated.purchaseorder.PurchaseOrderDeletePurchaseOrderItemRequest() # PurchaseOrderDeletePurchaseOrderItemRequest | 

    try:
        # Delete_PurchaseOrderItem
        api_response = api_instance.delete_purchase_order_item(purchase_order_delete_purchase_order_item_request)
        print("The response of PurchaseOrderApi->delete_purchase_order_item:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->delete_purchase_order_item: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_delete_purchase_order_item_request** | [**PurchaseOrderDeletePurchaseOrderItemRequest**](PurchaseOrderDeletePurchaseOrderItemRequest.md)|  | 

### Return type

[**CommonPurchaseOrderHeader**](CommonPurchaseOrderHeader.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_purchase_order_note**
> int delete_purchase_order_note(purchase_order_delete_purchase_order_note_request)

Delete_PurchaseOrderNote

Delete Note for Purchase Order <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.EditPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.purchase_order_delete_purchase_order_note_request import PurchaseOrderDeletePurchaseOrderNoteRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_delete_purchase_order_note_request = linnworks_api.generated.purchaseorder.PurchaseOrderDeletePurchaseOrderNoteRequest() # PurchaseOrderDeletePurchaseOrderNoteRequest | 

    try:
        # Delete_PurchaseOrderNote
        api_response = api_instance.delete_purchase_order_note(purchase_order_delete_purchase_order_note_request)
        print("The response of PurchaseOrderApi->delete_purchase_order_note:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->delete_purchase_order_note: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_delete_purchase_order_note_request** | [**PurchaseOrderDeletePurchaseOrderNoteRequest**](PurchaseOrderDeletePurchaseOrderNoteRequest.md)|  | 

### Return type

**int**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **deliver_purchase_item**
> DeliverPurchaseOrderItemResponse deliver_purchase_item(purchase_order_deliver_purchase_item_request)

Deliver_PurchaseItem

Deliver purchase order item. This will affect current stock level according to the delivered quantity.  You can specify the total number of delivered items. If all items are delivered, the purchase order status will be changed to delivered <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.DeliverPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.deliver_purchase_order_item_response import DeliverPurchaseOrderItemResponse
from linnworks_api.generated.purchaseorder.models.purchase_order_deliver_purchase_item_request import PurchaseOrderDeliverPurchaseItemRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_deliver_purchase_item_request = linnworks_api.generated.purchaseorder.PurchaseOrderDeliverPurchaseItemRequest() # PurchaseOrderDeliverPurchaseItemRequest | 

    try:
        # Deliver_PurchaseItem
        api_response = api_instance.deliver_purchase_item(purchase_order_deliver_purchase_item_request)
        print("The response of PurchaseOrderApi->deliver_purchase_item:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->deliver_purchase_item: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_deliver_purchase_item_request** | [**PurchaseOrderDeliverPurchaseItemRequest**](PurchaseOrderDeliverPurchaseItemRequest.md)|  | 

### Return type

[**DeliverPurchaseOrderItemResponse**](DeliverPurchaseOrderItemResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **deliver_purchase_item_all**
> DeliverPurchaseOrderItemAllResponse deliver_purchase_item_all(purchase_order_deliver_purchase_item_all_request)

Deliver_PurchaseItemAll

Update purchase order item, quantity, cost, pack size, pack quantity, in PENDING order only. Returns class that represents modified/recalculated purchase order header and modified purchase order item line <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.DeliverPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.deliver_purchase_order_item_all_response import DeliverPurchaseOrderItemAllResponse
from linnworks_api.generated.purchaseorder.models.purchase_order_deliver_purchase_item_all_request import PurchaseOrderDeliverPurchaseItemAllRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_deliver_purchase_item_all_request = linnworks_api.generated.purchaseorder.PurchaseOrderDeliverPurchaseItemAllRequest() # PurchaseOrderDeliverPurchaseItemAllRequest | 

    try:
        # Deliver_PurchaseItemAll
        api_response = api_instance.deliver_purchase_item_all(purchase_order_deliver_purchase_item_all_request)
        print("The response of PurchaseOrderApi->deliver_purchase_item_all:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->deliver_purchase_item_all: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_deliver_purchase_item_all_request** | [**PurchaseOrderDeliverPurchaseItemAllRequest**](PurchaseOrderDeliverPurchaseItemAllRequest.md)|  | 

### Return type

[**DeliverPurchaseOrderItemAllResponse**](DeliverPurchaseOrderItemAllResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **deliver_purchase_item_all_except_batch_items**
> DeliverPurchaseOrderItemAllNoBatchResponse deliver_purchase_item_all_except_batch_items(purchase_order_deliver_purchase_item_all_except_batch_items_request)

Deliver_PurchaseItemAll_ExceptBatchItems

Update purchase order item, quantity, cost, pack size, pack quantity, in PENDING order only. Returns class that represents modified/recalculated purchase order header and modified purchase order item line <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.DeliverPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.deliver_purchase_order_item_all_no_batch_response import DeliverPurchaseOrderItemAllNoBatchResponse
from linnworks_api.generated.purchaseorder.models.purchase_order_deliver_purchase_item_all_except_batch_items_request import PurchaseOrderDeliverPurchaseItemAllExceptBatchItemsRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_deliver_purchase_item_all_except_batch_items_request = linnworks_api.generated.purchaseorder.PurchaseOrderDeliverPurchaseItemAllExceptBatchItemsRequest() # PurchaseOrderDeliverPurchaseItemAllExceptBatchItemsRequest | 

    try:
        # Deliver_PurchaseItemAll_ExceptBatchItems
        api_response = api_instance.deliver_purchase_item_all_except_batch_items(purchase_order_deliver_purchase_item_all_except_batch_items_request)
        print("The response of PurchaseOrderApi->deliver_purchase_item_all_except_batch_items:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->deliver_purchase_item_all_except_batch_items: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_deliver_purchase_item_all_except_batch_items_request** | [**PurchaseOrderDeliverPurchaseItemAllExceptBatchItemsRequest**](PurchaseOrderDeliverPurchaseItemAllExceptBatchItemsRequest.md)|  | 

### Return type

[**DeliverPurchaseOrderItemAllNoBatchResponse**](DeliverPurchaseOrderItemAllNoBatchResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **deliver_purchase_items_with_quantity**
> deliver_purchase_items_with_quantity(purchase_order_deliver_purchase_items_with_quantity_request)

Deliver_PurchaseItems_WithQuantity

 <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.DeliverPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.purchase_order_deliver_purchase_items_with_quantity_request import PurchaseOrderDeliverPurchaseItemsWithQuantityRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_deliver_purchase_items_with_quantity_request = linnworks_api.generated.purchaseorder.PurchaseOrderDeliverPurchaseItemsWithQuantityRequest() # PurchaseOrderDeliverPurchaseItemsWithQuantityRequest | 

    try:
        # Deliver_PurchaseItems_WithQuantity
        api_instance.deliver_purchase_items_with_quantity(purchase_order_deliver_purchase_items_with_quantity_request)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->deliver_purchase_items_with_quantity: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_deliver_purchase_items_with_quantity_request** | [**PurchaseOrderDeliverPurchaseItemsWithQuantityRequest**](PurchaseOrderDeliverPurchaseItemsWithQuantityRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **export_purchase_order**
> DownloadResponse export_purchase_order(purchase_order_export_purchase_order_request)

ExportPurchaseOrder

 <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.download_response import DownloadResponse
from linnworks_api.generated.purchaseorder.models.purchase_order_export_purchase_order_request import PurchaseOrderExportPurchaseOrderRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_export_purchase_order_request = linnworks_api.generated.purchaseorder.PurchaseOrderExportPurchaseOrderRequest() # PurchaseOrderExportPurchaseOrderRequest | 

    try:
        # ExportPurchaseOrder
        api_response = api_instance.export_purchase_order(purchase_order_export_purchase_order_request)
        print("The response of PurchaseOrderApi->export_purchase_order:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->export_purchase_order: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_export_purchase_order_request** | [**PurchaseOrderExportPurchaseOrderRequest**](PurchaseOrderExportPurchaseOrderRequest.md)|  | 

### Return type

[**DownloadResponse**](DownloadResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **find_stock_item**
> FindStockItemResponse find_stock_item(purchase_order_find_stock_item_request)

FindStockItem

Try to find an item by SKU of SpplierCode <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.ViewPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.find_stock_item_response import FindStockItemResponse
from linnworks_api.generated.purchaseorder.models.purchase_order_find_stock_item_request import PurchaseOrderFindStockItemRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_find_stock_item_request = linnworks_api.generated.purchaseorder.PurchaseOrderFindStockItemRequest() # PurchaseOrderFindStockItemRequest | 

    try:
        # FindStockItem
        api_response = api_instance.find_stock_item(purchase_order_find_stock_item_request)
        print("The response of PurchaseOrderApi->find_stock_item:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->find_stock_item: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_find_stock_item_request** | [**PurchaseOrderFindStockItemRequest**](PurchaseOrderFindStockItemRequest.md)|  | 

### Return type

[**FindStockItemResponse**](FindStockItemResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_additional_cost**
> GetAdditionalCostResponse get_additional_cost(purchase_order_get_additional_cost_request)

Get_Additional_Cost

Get additional costs of a purchase order <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.ViewPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.get_additional_cost_response import GetAdditionalCostResponse
from linnworks_api.generated.purchaseorder.models.purchase_order_get_additional_cost_request import PurchaseOrderGetAdditionalCostRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_get_additional_cost_request = linnworks_api.generated.purchaseorder.PurchaseOrderGetAdditionalCostRequest() # PurchaseOrderGetAdditionalCostRequest | 

    try:
        # Get_Additional_Cost
        api_response = api_instance.get_additional_cost(purchase_order_get_additional_cost_request)
        print("The response of PurchaseOrderApi->get_additional_cost:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->get_additional_cost: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_get_additional_cost_request** | [**PurchaseOrderGetAdditionalCostRequest**](PurchaseOrderGetAdditionalCostRequest.md)|  | 

### Return type

[**GetAdditionalCostResponse**](GetAdditionalCostResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_additional_cost_types**
> GetAdditionalCostTypesResponse get_additional_cost_types(purchase_order_get_additional_cost_types_request)

Get_AdditionalCostTypes

Get purchase order additional costs types <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.get_additional_cost_types_response import GetAdditionalCostTypesResponse
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_get_additional_cost_types_request = None # object | 

    try:
        # Get_AdditionalCostTypes
        api_response = api_instance.get_additional_cost_types(purchase_order_get_additional_cost_types_request)
        print("The response of PurchaseOrderApi->get_additional_cost_types:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->get_additional_cost_types: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_get_additional_cost_types_request** | **object**|  | 

### Return type

[**GetAdditionalCostTypesResponse**](GetAdditionalCostTypesResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_delivered_records**
> GetDeliveredRecordsResponse get_delivered_records(purchase_order_get_delivered_records_request)

Get_DeliveredRecords

Get delivered item records for specific PO <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.ViewPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.get_delivered_records_response import GetDeliveredRecordsResponse
from linnworks_api.generated.purchaseorder.models.purchase_order_get_delivered_records_request import PurchaseOrderGetDeliveredRecordsRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_get_delivered_records_request = linnworks_api.generated.purchaseorder.PurchaseOrderGetDeliveredRecordsRequest() # PurchaseOrderGetDeliveredRecordsRequest | 

    try:
        # Get_DeliveredRecords
        api_response = api_instance.get_delivered_records(purchase_order_get_delivered_records_request)
        print("The response of PurchaseOrderApi->get_delivered_records:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->get_delivered_records: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_get_delivered_records_request** | [**PurchaseOrderGetDeliveredRecordsRequest**](PurchaseOrderGetDeliveredRecordsRequest.md)|  | 

### Return type

[**GetDeliveredRecordsResponse**](GetDeliveredRecordsResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_email_csv_file**
> GetEmailCSVFileResponse get_email_csv_file(purchase_order_get_email_csv_file_request)

Get_EmailCSVFile

Get the URL of the CSV file for the specific purchase order <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.ViewPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.get_email_csv_file_response import GetEmailCSVFileResponse
from linnworks_api.generated.purchaseorder.models.purchase_order_get_email_csv_file_request import PurchaseOrderGetEmailCSVFileRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_get_email_csv_file_request = linnworks_api.generated.purchaseorder.PurchaseOrderGetEmailCSVFileRequest() # PurchaseOrderGetEmailCSVFileRequest | 

    try:
        # Get_EmailCSVFile
        api_response = api_instance.get_email_csv_file(purchase_order_get_email_csv_file_request)
        print("The response of PurchaseOrderApi->get_email_csv_file:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->get_email_csv_file: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_get_email_csv_file_request** | [**PurchaseOrderGetEmailCSVFileRequest**](PurchaseOrderGetEmailCSVFileRequest.md)|  | 

### Return type

[**GetEmailCSVFileResponse**](GetEmailCSVFileResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_emails_sent**
> GetEmailsSentResponse get_emails_sent(purchase_order_get_emails_sent_request)

Get_EmailsSent

Get delivered item records for specific PO <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.ViewPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.get_emails_sent_response import GetEmailsSentResponse
from linnworks_api.generated.purchaseorder.models.purchase_order_get_emails_sent_request import PurchaseOrderGetEmailsSentRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_get_emails_sent_request = linnworks_api.generated.purchaseorder.PurchaseOrderGetEmailsSentRequest() # PurchaseOrderGetEmailsSentRequest | 

    try:
        # Get_EmailsSent
        api_response = api_instance.get_emails_sent(purchase_order_get_emails_sent_request)
        print("The response of PurchaseOrderApi->get_emails_sent:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->get_emails_sent: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_get_emails_sent_request** | [**PurchaseOrderGetEmailsSentRequest**](PurchaseOrderGetEmailsSentRequest.md)|  | 

### Return type

[**GetEmailsSentResponse**](GetEmailsSentResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_payment_statement**
> GetPaymentStatementResponse get_payment_statement(purchase_order_get_payment_statement_request)

Get_Payment_Statement

Get payment statements of a purchase order <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.ViewPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.get_payment_statement_response import GetPaymentStatementResponse
from linnworks_api.generated.purchaseorder.models.purchase_order_get_payment_statement_request import PurchaseOrderGetPaymentStatementRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_get_payment_statement_request = linnworks_api.generated.purchaseorder.PurchaseOrderGetPaymentStatementRequest() # PurchaseOrderGetPaymentStatementRequest | 

    try:
        # Get_Payment_Statement
        api_response = api_instance.get_payment_statement(purchase_order_get_payment_statement_request)
        print("The response of PurchaseOrderApi->get_payment_statement:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->get_payment_statement: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_get_payment_statement_request** | [**PurchaseOrderGetPaymentStatementRequest**](PurchaseOrderGetPaymentStatementRequest.md)|  | 

### Return type

[**GetPaymentStatementResponse**](GetPaymentStatementResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_purchase_order**
> PurchaseOrderResponse get_purchase_order(purchase_order_get_purchase_order_request)

Get_PurchaseOrder

Get purchase order header and items in one call <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.ViewPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.purchase_order_get_purchase_order_request import PurchaseOrderGetPurchaseOrderRequest
from linnworks_api.generated.purchaseorder.models.purchase_order_response import PurchaseOrderResponse
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_get_purchase_order_request = linnworks_api.generated.purchaseorder.PurchaseOrderGetPurchaseOrderRequest() # PurchaseOrderGetPurchaseOrderRequest | 

    try:
        # Get_PurchaseOrder
        api_response = api_instance.get_purchase_order(purchase_order_get_purchase_order_request)
        print("The response of PurchaseOrderApi->get_purchase_order:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->get_purchase_order: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_get_purchase_order_request** | [**PurchaseOrderGetPurchaseOrderRequest**](PurchaseOrderGetPurchaseOrderRequest.md)|  | 

### Return type

[**PurchaseOrderResponse**](PurchaseOrderResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_purchase_order_audit**
> List[PurchaseOrderAudit] get_purchase_order_audit(purchase_order_get_purchase_order_audit_request)

Get_PurchaseOrderAudit

Get the Audit Log of a Purchase Order. Returns maxium 1000 records in descending order <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.ViewPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.purchase_order_audit import PurchaseOrderAudit
from linnworks_api.generated.purchaseorder.models.purchase_order_get_purchase_order_audit_request import PurchaseOrderGetPurchaseOrderAuditRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_get_purchase_order_audit_request = linnworks_api.generated.purchaseorder.PurchaseOrderGetPurchaseOrderAuditRequest() # PurchaseOrderGetPurchaseOrderAuditRequest | 

    try:
        # Get_PurchaseOrderAudit
        api_response = api_instance.get_purchase_order_audit(purchase_order_get_purchase_order_audit_request)
        print("The response of PurchaseOrderApi->get_purchase_order_audit:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->get_purchase_order_audit: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_get_purchase_order_audit_request** | [**PurchaseOrderGetPurchaseOrderAuditRequest**](PurchaseOrderGetPurchaseOrderAuditRequest.md)|  | 

### Return type

[**List[PurchaseOrderAudit]**](PurchaseOrderAudit.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_purchase_order_extended_property**
> GetPurchaseOrderExtendedPropertyResponse get_purchase_order_extended_property(purchase_order_get_purchase_order_extended_property_request)

Get_PurchaseOrderExtendedProperty

Get all purchase order extended properties <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.ViewPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.get_purchase_order_extended_property_response import GetPurchaseOrderExtendedPropertyResponse
from linnworks_api.generated.purchaseorder.models.purchase_order_get_purchase_order_extended_property_request import PurchaseOrderGetPurchaseOrderExtendedPropertyRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_get_purchase_order_extended_property_request = linnworks_api.generated.purchaseorder.PurchaseOrderGetPurchaseOrderExtendedPropertyRequest() # PurchaseOrderGetPurchaseOrderExtendedPropertyRequest | 

    try:
        # Get_PurchaseOrderExtendedProperty
        api_response = api_instance.get_purchase_order_extended_property(purchase_order_get_purchase_order_extended_property_request)
        print("The response of PurchaseOrderApi->get_purchase_order_extended_property:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->get_purchase_order_extended_property: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_get_purchase_order_extended_property_request** | [**PurchaseOrderGetPurchaseOrderExtendedPropertyRequest**](PurchaseOrderGetPurchaseOrderExtendedPropertyRequest.md)|  | 

### Return type

[**GetPurchaseOrderExtendedPropertyResponse**](GetPurchaseOrderExtendedPropertyResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_purchase_order_note**
> List[PurchaseOrderNote] get_purchase_order_note(purchase_order_get_purchase_order_note_request)

Get_PurchaseOrderNote

Get purchase order notes <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.ViewPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.purchase_order_get_purchase_order_note_request import PurchaseOrderGetPurchaseOrderNoteRequest
from linnworks_api.generated.purchaseorder.models.purchase_order_note import PurchaseOrderNote
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_get_purchase_order_note_request = linnworks_api.generated.purchaseorder.PurchaseOrderGetPurchaseOrderNoteRequest() # PurchaseOrderGetPurchaseOrderNoteRequest | 

    try:
        # Get_PurchaseOrderNote
        api_response = api_instance.get_purchase_order_note(purchase_order_get_purchase_order_note_request)
        print("The response of PurchaseOrderApi->get_purchase_order_note:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->get_purchase_order_note: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_get_purchase_order_note_request** | [**PurchaseOrderGetPurchaseOrderNoteRequest**](PurchaseOrderGetPurchaseOrderNoteRequest.md)|  | 

### Return type

[**List[PurchaseOrderNote]**](PurchaseOrderNote.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_purchase_order_status_list**
> List[str] get_purchase_order_status_list(purchase_order_get_purchase_order_status_list_request)

GetPurchaseOrderStatusList

Get a list of available statuses <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_get_purchase_order_status_list_request = None # object | 

    try:
        # GetPurchaseOrderStatusList
        api_response = api_instance.get_purchase_order_status_list(purchase_order_get_purchase_order_status_list_request)
        print("The response of PurchaseOrderApi->get_purchase_order_status_list:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->get_purchase_order_status_list: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_get_purchase_order_status_list_request** | **object**|  | 

### Return type

**List[str]**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_purchase_orders_with_stock_items**
> List[str] get_purchase_orders_with_stock_items(purchase_order_get_purchase_orders_with_stock_items_request)

GetPurchaseOrdersWithStockItems

Gets a list of Purchase Order Ids that contain undelivered stock items <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.SearchPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.purchase_order_get_purchase_orders_with_stock_items_request import PurchaseOrderGetPurchaseOrdersWithStockItemsRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_get_purchase_orders_with_stock_items_request = linnworks_api.generated.purchaseorder.PurchaseOrderGetPurchaseOrdersWithStockItemsRequest() # PurchaseOrderGetPurchaseOrdersWithStockItemsRequest | 

    try:
        # GetPurchaseOrdersWithStockItems
        api_response = api_instance.get_purchase_orders_with_stock_items(purchase_order_get_purchase_orders_with_stock_items_request)
        print("The response of PurchaseOrderApi->get_purchase_orders_with_stock_items:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->get_purchase_orders_with_stock_items: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_get_purchase_orders_with_stock_items_request** | [**PurchaseOrderGetPurchaseOrdersWithStockItemsRequest**](PurchaseOrderGetPurchaseOrdersWithStockItemsRequest.md)|  | 

### Return type

**List[str]**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **modify_additional_cost**
> PurchaseOrderModifyAdditionalCostResponse modify_additional_cost(purchase_order_modify_additional_cost_request)

Modify_AdditionalCost

Modify purchase order additional costs. You can add new lines, update and delete existing. The method will return modified list back to you with each record identified by unique identifier.  Purchase Order header will also be returned with new total recalculated <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.EditPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.purchase_order_modify_additional_cost_request import PurchaseOrderModifyAdditionalCostRequest
from linnworks_api.generated.purchaseorder.models.purchase_order_modify_additional_cost_response import PurchaseOrderModifyAdditionalCostResponse
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_modify_additional_cost_request = linnworks_api.generated.purchaseorder.PurchaseOrderModifyAdditionalCostRequest() # PurchaseOrderModifyAdditionalCostRequest | 

    try:
        # Modify_AdditionalCost
        api_response = api_instance.modify_additional_cost(purchase_order_modify_additional_cost_request)
        print("The response of PurchaseOrderApi->modify_additional_cost:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->modify_additional_cost: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_modify_additional_cost_request** | [**PurchaseOrderModifyAdditionalCostRequest**](PurchaseOrderModifyAdditionalCostRequest.md)|  | 

### Return type

[**PurchaseOrderModifyAdditionalCostResponse**](PurchaseOrderModifyAdditionalCostResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **modify_additional_cost_allocation**
> ModifyAdditionalCostAllocationResponse modify_additional_cost_allocation(purchase_order_modify_additional_cost_allocation_request)

Modify_AdditionalCostAllocation

Modify additional cost allocation items <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.EditPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.modify_additional_cost_allocation_response import ModifyAdditionalCostAllocationResponse
from linnworks_api.generated.purchaseorder.models.purchase_order_modify_additional_cost_allocation_request import PurchaseOrderModifyAdditionalCostAllocationRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_modify_additional_cost_allocation_request = linnworks_api.generated.purchaseorder.PurchaseOrderModifyAdditionalCostAllocationRequest() # PurchaseOrderModifyAdditionalCostAllocationRequest | 

    try:
        # Modify_AdditionalCostAllocation
        api_response = api_instance.modify_additional_cost_allocation(purchase_order_modify_additional_cost_allocation_request)
        print("The response of PurchaseOrderApi->modify_additional_cost_allocation:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->modify_additional_cost_allocation: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_modify_additional_cost_allocation_request** | [**PurchaseOrderModifyAdditionalCostAllocationRequest**](PurchaseOrderModifyAdditionalCostAllocationRequest.md)|  | 

### Return type

[**ModifyAdditionalCostAllocationResponse**](ModifyAdditionalCostAllocationResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **modify_payment_statement**
> PurchaseOrderModifyPaymentStatementResponse modify_payment_statement(purchase_order_modify_payment_statement_request)

Modify_PaymentStatement

Modify purchase order payment statements. You can add new lines, update and delete existing. The method will return modified list back to you with each record identified by unique identifier. <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.EditPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.purchase_order_modify_payment_statement_request import PurchaseOrderModifyPaymentStatementRequest
from linnworks_api.generated.purchaseorder.models.purchase_order_modify_payment_statement_response import PurchaseOrderModifyPaymentStatementResponse
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_modify_payment_statement_request = linnworks_api.generated.purchaseorder.PurchaseOrderModifyPaymentStatementRequest() # PurchaseOrderModifyPaymentStatementRequest | 

    try:
        # Modify_PaymentStatement
        api_response = api_instance.modify_payment_statement(purchase_order_modify_payment_statement_request)
        print("The response of PurchaseOrderApi->modify_payment_statement:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->modify_payment_statement: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_modify_payment_statement_request** | [**PurchaseOrderModifyPaymentStatementRequest**](PurchaseOrderModifyPaymentStatementRequest.md)|  | 

### Return type

[**PurchaseOrderModifyPaymentStatementResponse**](PurchaseOrderModifyPaymentStatementResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **modify_purchase_order_items_bulk**
> ModifyPurchaseOrderItemsBulkResponse modify_purchase_order_items_bulk(purchase_order_modify_purchase_order_items_bulk_request)

Modify_PurchaseOrderItems_Bulk

Delete, add and update purchase order items and cause purchase order totals recalculation <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.EditPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.modify_purchase_order_items_bulk_response import ModifyPurchaseOrderItemsBulkResponse
from linnworks_api.generated.purchaseorder.models.purchase_order_modify_purchase_order_items_bulk_request import PurchaseOrderModifyPurchaseOrderItemsBulkRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_modify_purchase_order_items_bulk_request = linnworks_api.generated.purchaseorder.PurchaseOrderModifyPurchaseOrderItemsBulkRequest() # PurchaseOrderModifyPurchaseOrderItemsBulkRequest | 

    try:
        # Modify_PurchaseOrderItems_Bulk
        api_response = api_instance.modify_purchase_order_items_bulk(purchase_order_modify_purchase_order_items_bulk_request)
        print("The response of PurchaseOrderApi->modify_purchase_order_items_bulk:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->modify_purchase_order_items_bulk: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_modify_purchase_order_items_bulk_request** | [**PurchaseOrderModifyPurchaseOrderItemsBulkRequest**](PurchaseOrderModifyPurchaseOrderItemsBulkRequest.md)|  | 

### Return type

[**ModifyPurchaseOrderItemsBulkResponse**](ModifyPurchaseOrderItemsBulkResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **search_purchase_orders**
> SearchPurchaseOrdersResult search_purchase_orders(purchase_order_search_purchase_orders_request)

Search_PurchaseOrders

Searches purchase order by a number of parameters, such as Date of Purchase, status, reference number.  Returns paged result of purchase order header. <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.SearchPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.purchase_order_search_purchase_orders_request import PurchaseOrderSearchPurchaseOrdersRequest
from linnworks_api.generated.purchaseorder.models.search_purchase_orders_result import SearchPurchaseOrdersResult
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_search_purchase_orders_request = linnworks_api.generated.purchaseorder.PurchaseOrderSearchPurchaseOrdersRequest() # PurchaseOrderSearchPurchaseOrdersRequest | 

    try:
        # Search_PurchaseOrders
        api_response = api_instance.search_purchase_orders(purchase_order_search_purchase_orders_request)
        print("The response of PurchaseOrderApi->search_purchase_orders:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->search_purchase_orders: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_search_purchase_orders_request** | [**PurchaseOrderSearchPurchaseOrdersRequest**](PurchaseOrderSearchPurchaseOrdersRequest.md)|  | 

### Return type

[**SearchPurchaseOrdersResult**](SearchPurchaseOrdersResult.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **search_purchase_orders2**
> SearchPurchaseOrdersResult search_purchase_orders2(request=request)

Search_PurchaseOrders2

Searches purchase order by a number of parameters, such as Date of Purchase, status, reference number.  Returns paged result of purchase order header. <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.SearchPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.search_purchase_order2_request import SearchPurchaseOrder2Request
from linnworks_api.generated.purchaseorder.models.search_purchase_orders_result import SearchPurchaseOrdersResult
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    request = linnworks_api.generated.purchaseorder.SearchPurchaseOrder2Request() # SearchPurchaseOrder2Request | Search Parameters (optional)

    try:
        # Search_PurchaseOrders2
        api_response = api_instance.search_purchase_orders2(request=request)
        print("The response of PurchaseOrderApi->search_purchase_orders2:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->search_purchase_orders2: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **request** | [**SearchPurchaseOrder2Request**](SearchPurchaseOrder2Request.md)| Search Parameters | [optional] 

### Return type

[**SearchPurchaseOrdersResult**](SearchPurchaseOrdersResult.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_additional_cost_types**
> UpdateAdditionalCostTypesResponse update_additional_cost_types(purchase_order_update_additional_cost_types_request)

Update_AdditionalCostTypes

Update additional cost type <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.ChangeAdditionalTypesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.purchase_order_update_additional_cost_types_request import PurchaseOrderUpdateAdditionalCostTypesRequest
from linnworks_api.generated.purchaseorder.models.update_additional_cost_types_response import UpdateAdditionalCostTypesResponse
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_update_additional_cost_types_request = linnworks_api.generated.purchaseorder.PurchaseOrderUpdateAdditionalCostTypesRequest() # PurchaseOrderUpdateAdditionalCostTypesRequest | 

    try:
        # Update_AdditionalCostTypes
        api_response = api_instance.update_additional_cost_types(purchase_order_update_additional_cost_types_request)
        print("The response of PurchaseOrderApi->update_additional_cost_types:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->update_additional_cost_types: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_update_additional_cost_types_request** | [**PurchaseOrderUpdateAdditionalCostTypesRequest**](PurchaseOrderUpdateAdditionalCostTypesRequest.md)|  | 

### Return type

[**UpdateAdditionalCostTypesResponse**](UpdateAdditionalCostTypesResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_purchase_order_extended_property**
> update_purchase_order_extended_property(purchase_order_update_purchase_order_extended_property_request)

Update_PurchaseOrderExtendedProperty

Updates purchase order extended property by id. If supplied id doesn't exists, the routine will throw an error  The routine checks for duplicated propery names and throws an error if duplicated property name. <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.EditPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.purchase_order_update_purchase_order_extended_property_request import PurchaseOrderUpdatePurchaseOrderExtendedPropertyRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_update_purchase_order_extended_property_request = linnworks_api.generated.purchaseorder.PurchaseOrderUpdatePurchaseOrderExtendedPropertyRequest() # PurchaseOrderUpdatePurchaseOrderExtendedPropertyRequest | 

    try:
        # Update_PurchaseOrderExtendedProperty
        api_instance.update_purchase_order_extended_property(purchase_order_update_purchase_order_extended_property_request)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->update_purchase_order_extended_property: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_update_purchase_order_extended_property_request** | [**PurchaseOrderUpdatePurchaseOrderExtendedPropertyRequest**](PurchaseOrderUpdatePurchaseOrderExtendedPropertyRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_purchase_order_header**
> CommonPurchaseOrderHeader update_purchase_order_header(purchase_order_update_purchase_order_header_request)

Update_PurchaseOrderHeader

Update purchase order header, only if status is not Delivered. Returns modified/recalculated purchase order header <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.EditPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.common_purchase_order_header import CommonPurchaseOrderHeader
from linnworks_api.generated.purchaseorder.models.purchase_order_update_purchase_order_header_request import PurchaseOrderUpdatePurchaseOrderHeaderRequest
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_update_purchase_order_header_request = linnworks_api.generated.purchaseorder.PurchaseOrderUpdatePurchaseOrderHeaderRequest() # PurchaseOrderUpdatePurchaseOrderHeaderRequest | 

    try:
        # Update_PurchaseOrderHeader
        api_response = api_instance.update_purchase_order_header(purchase_order_update_purchase_order_header_request)
        print("The response of PurchaseOrderApi->update_purchase_order_header:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->update_purchase_order_header: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_update_purchase_order_header_request** | [**PurchaseOrderUpdatePurchaseOrderHeaderRequest**](PurchaseOrderUpdatePurchaseOrderHeaderRequest.md)|  | 

### Return type

[**CommonPurchaseOrderHeader**](CommonPurchaseOrderHeader.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_purchase_order_item**
> UpdatePurchaseOrderItemResponse update_purchase_order_item(purchase_order_update_purchase_order_item_request)

Update_PurchaseOrderItem

Update purchase order item, quantity, cost, pack size, pack quantity, in PENDING order only. Returns class that represents modified/recalculated purchase order header and modified purchase order item line <b>Permissions Required: </b> GlobalPermissions.Inventory.PurchaseOrder.EditPurchaseOrderNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.purchaseorder
from linnworks_api.generated.purchaseorder.models.purchase_order_update_purchase_order_item_request import PurchaseOrderUpdatePurchaseOrderItemRequest
from linnworks_api.generated.purchaseorder.models.update_purchase_order_item_response import UpdatePurchaseOrderItemResponse
from linnworks_api.generated.purchaseorder.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.purchaseorder.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.purchaseorder.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.purchaseorder.PurchaseOrderApi(api_client)
    purchase_order_update_purchase_order_item_request = linnworks_api.generated.purchaseorder.PurchaseOrderUpdatePurchaseOrderItemRequest() # PurchaseOrderUpdatePurchaseOrderItemRequest | 

    try:
        # Update_PurchaseOrderItem
        api_response = api_instance.update_purchase_order_item(purchase_order_update_purchase_order_item_request)
        print("The response of PurchaseOrderApi->update_purchase_order_item:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PurchaseOrderApi->update_purchase_order_item: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **purchase_order_update_purchase_order_item_request** | [**PurchaseOrderUpdatePurchaseOrderItemRequest**](PurchaseOrderUpdatePurchaseOrderItemRequest.md)|  | 

### Return type

[**UpdatePurchaseOrderItemResponse**](UpdatePurchaseOrderItemResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

