# coding: utf-8

"""
    Purchase Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: purchaseorder
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.purchaseorder.models.common_purchase_order_additional_cost_allocation import CommonPurchaseOrderAdditionalCostAllocation
from typing import Optional, Set
from typing_extensions import Self

class CommonPurchaseOrderAdditionalCost(BaseModel):
    """
    CommonPurchaseOrderAdditionalCost
    """ # noqa: E501
    purchase_additional_cost_item_id: Optional[StrictInt] = Field(default=None, alias="PurchaseAdditionalCostItemId")
    additional_cost_type_id: Optional[StrictInt] = Field(default=None, alias="AdditionalCostTypeId")
    reference: Optional[StrictStr] = Field(default=None, alias="Reference")
    sub_total_line_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="SubTotalLineCost")
    tax_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="TaxRate")
    tax: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Tax")
    currency: Optional[StrictStr] = Field(default=None, alias="Currency")
    conversion_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ConversionRate")
    total_line_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="TotalLineCost")
    cost_allocation: Optional[List[CommonPurchaseOrderAdditionalCostAllocation]] = Field(default=None, alias="CostAllocation")
    allocation_locked: Optional[StrictBool] = Field(default=None, alias="AllocationLocked")
    additional_cost_type_name: Optional[StrictStr] = Field(default=None, alias="AdditionalCostTypeName")
    additional_cost_type_is_shipping_type: Optional[StrictBool] = Field(default=None, alias="AdditionalCostTypeIsShippingType")
    additional_cost_type_is_partial_allocation: Optional[StrictBool] = Field(default=None, alias="AdditionalCostTypeIsPartialAllocation")
    var_print: Optional[StrictBool] = Field(default=None, alias="Print")
    allocation_method: Optional[StrictStr] = Field(default=None, alias="AllocationMethod")
    __properties: ClassVar[List[str]] = ["PurchaseAdditionalCostItemId", "AdditionalCostTypeId", "Reference", "SubTotalLineCost", "TaxRate", "Tax", "Currency", "ConversionRate", "TotalLineCost", "CostAllocation", "AllocationLocked", "AdditionalCostTypeName", "AdditionalCostTypeIsShippingType", "AdditionalCostTypeIsPartialAllocation", "Print", "AllocationMethod"]

    @field_validator('allocation_method')
    def allocation_method_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ByValue', 'ByCBM']):
            raise ValueError("must be one of enum values ('ByValue', 'ByCBM')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CommonPurchaseOrderAdditionalCost from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in cost_allocation (list)
        _items = []
        if self.cost_allocation:
            for _item_cost_allocation in self.cost_allocation:
                if _item_cost_allocation:
                    _items.append(_item_cost_allocation.to_dict())
            _dict['CostAllocation'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CommonPurchaseOrderAdditionalCost from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "PurchaseAdditionalCostItemId": obj.get("PurchaseAdditionalCostItemId"),
            "AdditionalCostTypeId": obj.get("AdditionalCostTypeId"),
            "Reference": obj.get("Reference"),
            "SubTotalLineCost": obj.get("SubTotalLineCost"),
            "TaxRate": obj.get("TaxRate"),
            "Tax": obj.get("Tax"),
            "Currency": obj.get("Currency"),
            "ConversionRate": obj.get("ConversionRate"),
            "TotalLineCost": obj.get("TotalLineCost"),
            "CostAllocation": [CommonPurchaseOrderAdditionalCostAllocation.from_dict(_item) for _item in obj["CostAllocation"]] if obj.get("CostAllocation") is not None else None,
            "AllocationLocked": obj.get("AllocationLocked"),
            "AdditionalCostTypeName": obj.get("AdditionalCostTypeName"),
            "AdditionalCostTypeIsShippingType": obj.get("AdditionalCostTypeIsShippingType"),
            "AdditionalCostTypeIsPartialAllocation": obj.get("AdditionalCostTypeIsPartialAllocation"),
            "Print": obj.get("Print"),
            "AllocationMethod": obj.get("AllocationMethod")
        })
        return _obj


