# coding: utf-8

"""
    Purchase Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: purchaseorder
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class CommonPurchaseOrderItem(BaseModel):
    """
    CommonPurchaseOrderItem
    """ # noqa: E501
    pk_purchase_item_id: Optional[StrictStr] = Field(default=None, alias="pkPurchaseItemId")
    fk_stock_item_id: Optional[StrictStr] = Field(default=None, alias="fkStockItemId")
    stock_item_int_id: Optional[StrictInt] = Field(default=None, alias="StockItemIntId")
    quantity: Optional[StrictInt] = Field(default=None, alias="Quantity")
    cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Cost")
    delivered: Optional[StrictInt] = Field(default=None, alias="Delivered")
    tax_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="TaxRate")
    tax: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Tax")
    pack_quantity: Optional[StrictInt] = Field(default=None, alias="PackQuantity")
    pack_size: Optional[StrictInt] = Field(default=None, alias="PackSize")
    sku: Optional[StrictStr] = Field(default=None, alias="SKU")
    item_title: Optional[StrictStr] = Field(default=None, alias="ItemTitle")
    inventory_tracking_type: Optional[StrictInt] = Field(default=None, alias="InventoryTrackingType")
    is_deleted: Optional[StrictBool] = Field(default=None, alias="IsDeleted")
    sort_order: Optional[StrictInt] = Field(default=None, alias="SortOrder")
    dim_height: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="DimHeight")
    dim_width: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="DimWidth")
    barcode_number: Optional[StrictStr] = Field(default=None, alias="BarcodeNumber")
    dim_depth: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="DimDepth")
    bound_to_open_orders_items: Optional[StrictInt] = Field(default=None, alias="BoundToOpenOrdersItems")
    bin_rack: Optional[StrictStr] = Field(default=None, alias="BinRack")
    quantity_bound_to_open_orders_items: Optional[StrictInt] = Field(default=None, alias="QuantityBoundToOpenOrdersItems")
    supplier_code: Optional[StrictStr] = Field(default=None, alias="SupplierCode")
    supplier_barcode: Optional[StrictStr] = Field(default=None, alias="SupplierBarcode")
    sku_group_ids: Optional[List[StrictInt]] = Field(default=None, alias="SkuGroupIds")
    __properties: ClassVar[List[str]] = ["pkPurchaseItemId", "fkStockItemId", "StockItemIntId", "Quantity", "Cost", "Delivered", "TaxRate", "Tax", "PackQuantity", "PackSize", "SKU", "ItemTitle", "InventoryTrackingType", "IsDeleted", "SortOrder", "DimHeight", "DimWidth", "BarcodeNumber", "DimDepth", "BoundToOpenOrdersItems", "BinRack", "QuantityBoundToOpenOrdersItems", "SupplierCode", "SupplierBarcode", "SkuGroupIds"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CommonPurchaseOrderItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CommonPurchaseOrderItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pkPurchaseItemId": obj.get("pkPurchaseItemId"),
            "fkStockItemId": obj.get("fkStockItemId"),
            "StockItemIntId": obj.get("StockItemIntId"),
            "Quantity": obj.get("Quantity"),
            "Cost": obj.get("Cost"),
            "Delivered": obj.get("Delivered"),
            "TaxRate": obj.get("TaxRate"),
            "Tax": obj.get("Tax"),
            "PackQuantity": obj.get("PackQuantity"),
            "PackSize": obj.get("PackSize"),
            "SKU": obj.get("SKU"),
            "ItemTitle": obj.get("ItemTitle"),
            "InventoryTrackingType": obj.get("InventoryTrackingType"),
            "IsDeleted": obj.get("IsDeleted"),
            "SortOrder": obj.get("SortOrder"),
            "DimHeight": obj.get("DimHeight"),
            "DimWidth": obj.get("DimWidth"),
            "BarcodeNumber": obj.get("BarcodeNumber"),
            "DimDepth": obj.get("DimDepth"),
            "BoundToOpenOrdersItems": obj.get("BoundToOpenOrdersItems"),
            "BinRack": obj.get("BinRack"),
            "QuantityBoundToOpenOrdersItems": obj.get("QuantityBoundToOpenOrdersItems"),
            "SupplierCode": obj.get("SupplierCode"),
            "SupplierBarcode": obj.get("SupplierBarcode"),
            "SkuGroupIds": obj.get("SkuGroupIds")
        })
        return _obj


