# coding: utf-8

"""
    Purchase Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: purchaseorder
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class CreatePurchaseOrderInitialParameter(BaseModel):
    """
    Class that represents entry parameters for creating new PENDING purchase order
    """ # noqa: E501
    fk_supplier_id: Optional[StrictStr] = Field(default=None, description="Supplier unique identifier. Use Inventory/GetSupplierList to get the supplier ids", alias="fkSupplierId")
    fk_location_id: Optional[StrictStr] = Field(default=None, description="Location id where the PO will be delivered to. Use Inventory/GetStockLocations to get the location ids", alias="fkLocationId")
    external_invoice_number: Optional[StrictStr] = Field(default=None, description="Purchase order reference", alias="ExternalInvoiceNumber")
    currency: Optional[StrictStr] = Field(default=None, description="Currency of the purchase order", alias="Currency")
    supplier_reference_number: Optional[StrictStr] = Field(default=None, description="Supplier purchase order reference number", alias="SupplierReferenceNumber")
    unit_amount_tax_included_type: Optional[StrictInt] = Field(default=None, description="Unit amount includes,excludes or no tax. 0 - Excludes Tax, 1 - Includes tax, 2 - No Tax", alias="UnitAmountTaxIncludedType")
    date_of_purchase: Optional[datetime] = Field(default=None, description="DateTime of the purchase order", alias="DateOfPurchase")
    quoted_delivery_date: Optional[datetime] = Field(default=None, description="DateTime of the expected delivery date.", alias="QuotedDeliveryDate")
    postage_paid: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="**DEPRECIATED**   Use additional costs with Shipping flag to record shipping costs. This field remains available in the API for backward compatibility and acts pretty much like an additional cost item with type", alias="PostagePaid")
    shipping_tax_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="**DEPRECIATED**   Use additional costs with Shipping flag to record shipping costs. This field remains available in the API for backward compatibility and acts pretty much like an additional cost item with type", alias="ShippingTaxRate")
    conversion_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Currency conversion rate, multiplier to change the purchase order currency into the system currecny", alias="ConversionRate")
    __properties: ClassVar[List[str]] = ["fkSupplierId", "fkLocationId", "ExternalInvoiceNumber", "Currency", "SupplierReferenceNumber", "UnitAmountTaxIncludedType", "DateOfPurchase", "QuotedDeliveryDate", "PostagePaid", "ShippingTaxRate", "ConversionRate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreatePurchaseOrderInitialParameter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreatePurchaseOrderInitialParameter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fkSupplierId": obj.get("fkSupplierId"),
            "fkLocationId": obj.get("fkLocationId"),
            "ExternalInvoiceNumber": obj.get("ExternalInvoiceNumber"),
            "Currency": obj.get("Currency"),
            "SupplierReferenceNumber": obj.get("SupplierReferenceNumber"),
            "UnitAmountTaxIncludedType": obj.get("UnitAmountTaxIncludedType"),
            "DateOfPurchase": obj.get("DateOfPurchase"),
            "QuotedDeliveryDate": obj.get("QuotedDeliveryDate"),
            "PostagePaid": obj.get("PostagePaid"),
            "ShippingTaxRate": obj.get("ShippingTaxRate"),
            "ConversionRate": obj.get("ConversionRate")
        })
        return _obj


