# coding: utf-8

"""
    Purchase Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: purchaseorder
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SearchPurchaseOrder2Request(BaseModel):
    """
    Search Purchase order class
    """ # noqa: E501
    date_from: Optional[datetime] = Field(default=None, description="Purchase order date range from (optional)", alias="DateFrom")
    date_to: Optional[datetime] = Field(default=None, description="Purchase order date range to (optional)", alias="DateTo")
    status: Optional[StrictStr] = Field(default=None, description="Purchase order status: PENDING - purchase order can be changed, not yet affecting stock levels  OPEN - purchase order is created and stock levels Due are reflected  PARTIAL - partially delivered   DELIVERED - fully delivered", alias="Status")
    search_value: Optional[StrictStr] = Field(default=None, description="Specifies search value to filter with result set", alias="SearchValue")
    search_type: Optional[StrictStr] = Field(default=None, description="Specifies search value type for search value", alias="SearchType")
    entries_per_page: Optional[StrictInt] = Field(default=None, description="Number of records returned, sorted by Purchase Order Date", alias="EntriesPerPage")
    page_number: Optional[StrictInt] = Field(default=None, description="Page Number", alias="PageNumber")
    location: Optional[List[StrictStr]] = Field(default=None, description="Current Location", alias="Location")
    supplier: Optional[List[StrictStr]] = Field(default=None, description="Current Supplier", alias="Supplier")
    __properties: ClassVar[List[str]] = ["DateFrom", "DateTo", "Status", "SearchValue", "SearchType", "EntriesPerPage", "PageNumber", "Location", "Supplier"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PENDING', 'OPEN', 'PARTIAL', 'DELIVERED']):
            raise ValueError("must be one of enum values ('PENDING', 'OPEN', 'PARTIAL', 'DELIVERED')")
        return value

    @field_validator('search_type')
    def search_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['All', 'Reference', 'StockItemSKU', 'SupplierCode', 'SupplierReference']):
            raise ValueError("must be one of enum values ('All', 'Reference', 'StockItemSKU', 'SupplierCode', 'SupplierReference')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SearchPurchaseOrder2Request from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SearchPurchaseOrder2Request from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "DateFrom": obj.get("DateFrom"),
            "DateTo": obj.get("DateTo"),
            "Status": obj.get("Status"),
            "SearchValue": obj.get("SearchValue"),
            "SearchType": obj.get("SearchType"),
            "EntriesPerPage": obj.get("EntriesPerPage"),
            "PageNumber": obj.get("PageNumber"),
            "Location": obj.get("Location"),
            "Supplier": obj.get("Supplier")
        })
        return _obj


