# coding: utf-8

"""
    Purchase Orders API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: purchaseorder
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class UpdatePurchaseOrderHeaderParameter(BaseModel):
    """
    Change purchase order status. You can change from PENDING to OPEN, from OPEN to DELIVERED, from PARTIAL to DELIVERED
    """ # noqa: E501
    pk_purchase_id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the purchase order. You have to use this ID for all updates to the PO", alias="pkPurchaseID")
    supplier_reference_number: Optional[StrictStr] = Field(default=None, description="Supplier reference number for the purchase order", alias="SupplierReferenceNumber")
    fk_location_id: Optional[StrictStr] = Field(default=None, description="Unique idenfidier of the location where the PO is expected to be delivered to. Empty Guid is default location. Use Locations API methods to get the names and additional details for the locations", alias="fkLocationId")
    fk_supplier_id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the supplier. Empty Guid is default supplier. Otherwise use Supplier API to get the names and additional data for the supplier", alias="fkSupplierId")
    currency: Optional[StrictStr] = Field(default=None, description="Currency of the values in the purchase order", alias="Currency")
    external_invoice_number: Optional[StrictStr] = Field(default=None, description="Purchase order reference", alias="ExternalInvoiceNumber")
    unit_amount_tax_included_type: Optional[StrictInt] = Field(default=None, description="Unit amount includes,excludes or no tax. 0 - Excludes Tax, 1 - Includes tax, 2 - No Tax. Nullable if null, the value not updated", alias="UnitAmountTaxIncludedType")
    date_of_purchase: Optional[datetime] = Field(default=None, description="DateTime of the purchase order delivered, will be set to DateOfPurchase until the PO is fully delivered UTC", alias="DateOfPurchase")
    quoted_delivery_date: Optional[datetime] = Field(default=None, description="DateTime of the purchase order quoted/expected delivery date UTC", alias="QuotedDeliveryDate")
    shipping_tax_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="**DEPRECIATED**   Use additional costs with Shipping flag to record shipping costs. This field remains available in the API for backward compatibility and acts pretty much like an additional cost item with type", alias="ShippingTaxRate")
    conversion_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Conversion rate of the purchase order currency. When PO is delivered Stock Value will be multipled by this conversion rate. For example if your system currency is GBP and Purchase order is in EUR the conversion rate is 0.81.", alias="ConversionRate")
    postage_paid: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="**DEPRECIATED**   Use additional costs with Shipping flag to record shipping costs. This field remains available in the API for backward compatibility and acts pretty much like an additional cost item with type", alias="PostagePaid")
    __properties: ClassVar[List[str]] = ["pkPurchaseID", "SupplierReferenceNumber", "fkLocationId", "fkSupplierId", "Currency", "ExternalInvoiceNumber", "UnitAmountTaxIncludedType", "DateOfPurchase", "QuotedDeliveryDate", "ShippingTaxRate", "ConversionRate", "PostagePaid"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdatePurchaseOrderHeaderParameter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdatePurchaseOrderHeaderParameter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pkPurchaseID": obj.get("pkPurchaseID"),
            "SupplierReferenceNumber": obj.get("SupplierReferenceNumber"),
            "fkLocationId": obj.get("fkLocationId"),
            "fkSupplierId": obj.get("fkSupplierId"),
            "Currency": obj.get("Currency"),
            "ExternalInvoiceNumber": obj.get("ExternalInvoiceNumber"),
            "UnitAmountTaxIncludedType": obj.get("UnitAmountTaxIncludedType"),
            "DateOfPurchase": obj.get("DateOfPurchase"),
            "QuotedDeliveryDate": obj.get("QuotedDeliveryDate"),
            "ShippingTaxRate": obj.get("ShippingTaxRate"),
            "ConversionRate": obj.get("ConversionRate"),
            "PostagePaid": obj.get("PostagePaid")
        })
        return _obj


