# coding: utf-8

"""
    Returns and Refunds API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: returnsrefunds
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.returnsrefunds.models.channel_sub_reason import ChannelSubReason
from typing import Optional, Set
from typing_extensions import Self

class ChannelReason(BaseModel):
    """
    ChannelReason
    """ # noqa: E501
    types: Optional[StrictStr] = Field(default=None, alias="Types")
    tag: Optional[StrictStr] = Field(default=None, alias="Tag")
    display_name: Optional[StrictStr] = Field(default=None, alias="DisplayName")
    sub_reasons: Optional[List[ChannelSubReason]] = Field(default=None, alias="SubReasons")
    __properties: ClassVar[List[str]] = ["Types", "Tag", "DisplayName", "SubReasons"]

    @field_validator('types')
    def types_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['None', 'Cancellation', 'ItemRefund', 'ShippingRefund', 'ServiceRefund', 'ItemReturn', 'InsufficientRefund', 'AdditionalRefund', 'RejectReturn', 'RejectRefund']):
            raise ValueError("must be one of enum values ('None', 'Cancellation', 'ItemRefund', 'ShippingRefund', 'ServiceRefund', 'ItemReturn', 'InsufficientRefund', 'AdditionalRefund', 'RejectReturn', 'RejectRefund')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChannelReason from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in sub_reasons (list)
        _items = []
        if self.sub_reasons:
            for _item_sub_reasons in self.sub_reasons:
                if _item_sub_reasons:
                    _items.append(_item_sub_reasons.to_dict())
            _dict['SubReasons'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChannelReason from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Types": obj.get("Types"),
            "Tag": obj.get("Tag"),
            "DisplayName": obj.get("DisplayName"),
            "SubReasons": [ChannelSubReason.from_dict(_item) for _item in obj["SubReasons"]] if obj.get("SubReasons") is not None else None
        })
        return _obj


