# coding: utf-8

"""
    Returns and Refunds API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: returnsrefunds
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.returnsrefunds.models.post_sale_status import PostSaleStatus
from linnworks_api.generated.returnsrefunds.models.verified_refund import VerifiedRefund
from typing import Optional, Set
from typing_extensions import Self

class CreateRefundResponse(BaseModel):
    """
    CreateRefundResponse
    """ # noqa: E501
    refund_header_id: Optional[StrictInt] = Field(default=None, description="The unique identifier for the refund header.", alias="RefundHeaderId")
    refund_reference: Optional[StrictStr] = Field(default=None, description="An automatically generated string to help identify the refund", alias="RefundReference")
    status: Optional[PostSaleStatus] = Field(default=None, alias="Status")
    cannot_refund_reason: Optional[StrictStr] = Field(default=None, description="If the validation has failed at any stage, this field identifies the cause of the failure", alias="CannotRefundReason")
    errors: Optional[List[StrictStr]] = Field(default=None, description="Any global validation errors are added to this list, as well as any errors from the RefundLines collection", alias="Errors")
    refund_lines: Optional[List[VerifiedRefund]] = Field(default=None, description="A collection of validated line-level refunds, with any applicable errors included", alias="RefundLines")
    __properties: ClassVar[List[str]] = ["RefundHeaderId", "RefundReference", "Status", "CannotRefundReason", "Errors", "RefundLines"]

    @field_validator('cannot_refund_reason')
    def cannot_refund_reason_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['None', 'NotImplemented', 'DisabledInConfig', 'MissingOrderInLinnworks', 'OpenOrderInLinnworks', 'OrderIsFullyRefundedInLinnworks', 'NoNewRefundsSpecified', 'NoUpdatedRefundsSpecified', 'MultipleReferences', 'SubStatusTagNotInTheSystem', 'SubStatusTagIsNotActionable', 'MultipleSubStatusTags', 'RefundNotInSystem', 'Other']):
            raise ValueError("must be one of enum values ('None', 'NotImplemented', 'DisabledInConfig', 'MissingOrderInLinnworks', 'OpenOrderInLinnworks', 'OrderIsFullyRefundedInLinnworks', 'NoNewRefundsSpecified', 'NoUpdatedRefundsSpecified', 'MultipleReferences', 'SubStatusTagNotInTheSystem', 'SubStatusTagIsNotActionable', 'MultipleSubStatusTags', 'RefundNotInSystem', 'Other')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateRefundResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['Status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in refund_lines (list)
        _items = []
        if self.refund_lines:
            for _item_refund_lines in self.refund_lines:
                if _item_refund_lines:
                    _items.append(_item_refund_lines.to_dict())
            _dict['RefundLines'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateRefundResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "RefundHeaderId": obj.get("RefundHeaderId"),
            "RefundReference": obj.get("RefundReference"),
            "Status": PostSaleStatus.from_dict(obj["Status"]) if obj.get("Status") is not None else None,
            "CannotRefundReason": obj.get("CannotRefundReason"),
            "Errors": obj.get("Errors"),
            "RefundLines": [VerifiedRefund.from_dict(_item) for _item in obj["RefundLines"]] if obj.get("RefundLines") is not None else None
        })
        return _obj


