# coding: utf-8

"""
    Returns and Refunds API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: returnsrefunds
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class RefundOrder(BaseModel):
    """
    RefundOrder
    """ # noqa: E501
    pk_order_id: Optional[StrictStr] = Field(default=None, alias="pkOrderID")
    n_order_id: Optional[StrictInt] = Field(default=None, alias="nOrderId")
    c_full_name: Optional[StrictStr] = Field(default=None, alias="cFullName")
    source: Optional[StrictStr] = Field(default=None, alias="Source")
    sub_source: Optional[StrictStr] = Field(default=None, alias="SubSource")
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Amount")
    issue_refund_url: Optional[StrictStr] = Field(default=None, alias="IssueRefundUrl")
    c_currency: Optional[StrictStr] = Field(default=None, alias="cCurrency")
    reference_num: Optional[StrictStr] = Field(default=None, alias="ReferenceNum")
    secondary_reference: Optional[StrictStr] = Field(default=None, alias="SecondaryReference")
    refund_reference: Optional[StrictStr] = Field(default=None, alias="RefundReference")
    refund_date: Optional[datetime] = Field(default=None, alias="RefundDate")
    sub_total: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="SubTotal")
    total: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Total")
    tax_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="TaxRate")
    __properties: ClassVar[List[str]] = ["pkOrderID", "nOrderId", "cFullName", "Source", "SubSource", "Amount", "IssueRefundUrl", "cCurrency", "ReferenceNum", "SecondaryReference", "RefundReference", "RefundDate", "SubTotal", "Total", "TaxRate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RefundOrder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RefundOrder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pkOrderID": obj.get("pkOrderID"),
            "nOrderId": obj.get("nOrderId"),
            "cFullName": obj.get("cFullName"),
            "Source": obj.get("Source"),
            "SubSource": obj.get("SubSource"),
            "Amount": obj.get("Amount"),
            "IssueRefundUrl": obj.get("IssueRefundUrl"),
            "cCurrency": obj.get("cCurrency"),
            "ReferenceNum": obj.get("ReferenceNum"),
            "SecondaryReference": obj.get("SecondaryReference"),
            "RefundReference": obj.get("RefundReference"),
            "RefundDate": obj.get("RefundDate"),
            "SubTotal": obj.get("SubTotal"),
            "Total": obj.get("Total"),
            "TaxRate": obj.get("TaxRate")
        })
        return _obj


