# coding: utf-8

"""
    Returns and Refunds API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: returnsrefunds
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.returnsrefunds.models.channel_reason import ChannelReason
from linnworks_api.generated.returnsrefunds.models.order_details import OrderDetails
from linnworks_api.generated.returnsrefunds.models.order_rma_header import OrderRMAHeader
from linnworks_api.generated.returnsrefunds.models.post_sale_sub_status import PostSaleSubStatus
from linnworks_api.generated.returnsrefunds.models.refund_options import RefundOptions
from linnworks_api.generated.returnsrefunds.models.verified_rma_item import VerifiedRMAItem
from typing import Optional, Set
from typing_extensions import Self

class ReturnOptions(BaseModel):
    """
    ReturnOptions
    """ # noqa: E501
    can_send_rejection_if_deleted: Optional[StrictBool] = Field(default=None, alias="CanSendRejectionIfDeleted")
    can_return: Optional[StrictBool] = Field(default=None, alias="CanReturn")
    can_return_internally: Optional[StrictBool] = Field(default=None, alias="CanReturnInternally")
    must_have_refund: Optional[StrictBool] = Field(default=None, alias="MustHaveRefund")
    refund_auto_populated: Optional[StrictBool] = Field(default=None, alias="RefundAutoPopulated")
    can_have_refund: Optional[StrictBool] = Field(default=None, alias="CanHaveRefund")
    return_reasons: Optional[List[ChannelReason]] = Field(default=None, alias="ReturnReasons")
    rejection_reasons: Optional[List[ChannelReason]] = Field(default=None, alias="RejectionReasons")
    sub_statuses: Optional[List[PostSaleSubStatus]] = Field(default=None, alias="SubStatuses")
    refund_options: Optional[RefundOptions] = Field(default=None, alias="RefundOptions")
    cannot_return_reason: Optional[StrictStr] = Field(default=None, alias="CannotReturnReason")
    order: Optional[OrderDetails] = Field(default=None, alias="Order")
    rma_header: Optional[OrderRMAHeader] = Field(default=None, alias="RMAHeader")
    all_existing_rmas: Optional[List[VerifiedRMAItem]] = Field(default=None, alias="AllExistingRMAs")
    errors: Optional[List[StrictStr]] = Field(default=None, alias="Errors")
    info: Optional[List[StrictStr]] = Field(default=None, alias="Info")
    __properties: ClassVar[List[str]] = ["CanSendRejectionIfDeleted", "CanReturn", "CanReturnInternally", "MustHaveRefund", "RefundAutoPopulated", "CanHaveRefund", "ReturnReasons", "RejectionReasons", "SubStatuses", "RefundOptions", "CannotReturnReason", "Order", "RMAHeader", "AllExistingRMAs", "Errors", "Info"]

    @field_validator('cannot_return_reason')
    def cannot_return_reason_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['None', 'NotImplemented', 'DisabledInConfig', 'MissingOrderInLinnworks', 'OpenOrderInLinnworks', 'AlreadyReturnedOnChannel', 'AlreadyReturnedInLinnworks', 'NoNewRMAsSpecified', 'SubStatusTagNotInTheSystem', 'SubStatusTagIsNotActionable', 'MultipleSubStatusTags', 'Other']):
            raise ValueError("must be one of enum values ('None', 'NotImplemented', 'DisabledInConfig', 'MissingOrderInLinnworks', 'OpenOrderInLinnworks', 'AlreadyReturnedOnChannel', 'AlreadyReturnedInLinnworks', 'NoNewRMAsSpecified', 'SubStatusTagNotInTheSystem', 'SubStatusTagIsNotActionable', 'MultipleSubStatusTags', 'Other')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReturnOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "can_return",
            "can_return_internally",
            "must_have_refund",
            "refund_auto_populated",
            "can_have_refund",
            "return_reasons",
            "sub_statuses",
            "all_existing_rmas",
            "errors",
            "info",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in return_reasons (list)
        _items = []
        if self.return_reasons:
            for _item_return_reasons in self.return_reasons:
                if _item_return_reasons:
                    _items.append(_item_return_reasons.to_dict())
            _dict['ReturnReasons'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in rejection_reasons (list)
        _items = []
        if self.rejection_reasons:
            for _item_rejection_reasons in self.rejection_reasons:
                if _item_rejection_reasons:
                    _items.append(_item_rejection_reasons.to_dict())
            _dict['RejectionReasons'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in sub_statuses (list)
        _items = []
        if self.sub_statuses:
            for _item_sub_statuses in self.sub_statuses:
                if _item_sub_statuses:
                    _items.append(_item_sub_statuses.to_dict())
            _dict['SubStatuses'] = _items
        # override the default output from pydantic by calling `to_dict()` of refund_options
        if self.refund_options:
            _dict['RefundOptions'] = self.refund_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order
        if self.order:
            _dict['Order'] = self.order.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rma_header
        if self.rma_header:
            _dict['RMAHeader'] = self.rma_header.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in all_existing_rmas (list)
        _items = []
        if self.all_existing_rmas:
            for _item_all_existing_rmas in self.all_existing_rmas:
                if _item_all_existing_rmas:
                    _items.append(_item_all_existing_rmas.to_dict())
            _dict['AllExistingRMAs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReturnOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "CanSendRejectionIfDeleted": obj.get("CanSendRejectionIfDeleted"),
            "CanReturn": obj.get("CanReturn"),
            "CanReturnInternally": obj.get("CanReturnInternally"),
            "MustHaveRefund": obj.get("MustHaveRefund"),
            "RefundAutoPopulated": obj.get("RefundAutoPopulated"),
            "CanHaveRefund": obj.get("CanHaveRefund"),
            "ReturnReasons": [ChannelReason.from_dict(_item) for _item in obj["ReturnReasons"]] if obj.get("ReturnReasons") is not None else None,
            "RejectionReasons": [ChannelReason.from_dict(_item) for _item in obj["RejectionReasons"]] if obj.get("RejectionReasons") is not None else None,
            "SubStatuses": [PostSaleSubStatus.from_dict(_item) for _item in obj["SubStatuses"]] if obj.get("SubStatuses") is not None else None,
            "RefundOptions": RefundOptions.from_dict(obj["RefundOptions"]) if obj.get("RefundOptions") is not None else None,
            "CannotReturnReason": obj.get("CannotReturnReason"),
            "Order": OrderDetails.from_dict(obj["Order"]) if obj.get("Order") is not None else None,
            "RMAHeader": OrderRMAHeader.from_dict(obj["RMAHeader"]) if obj.get("RMAHeader") is not None else None,
            "AllExistingRMAs": [VerifiedRMAItem.from_dict(_item) for _item in obj["AllExistingRMAs"]] if obj.get("AllExistingRMAs") is not None else None,
            "Errors": obj.get("Errors"),
            "Info": obj.get("Info")
        })
        return _obj


