# coding: utf-8

"""
    Returns and Refunds API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: returnsrefunds
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.returnsrefunds.models.post_sale_status import PostSaleStatus
from typing import Optional, Set
from typing_extensions import Self

class UpdatedExchangeItem(BaseModel):
    """
    UpdatedExchangeItem
    """ # noqa: E501
    rma_row_id: Optional[StrictInt] = Field(default=None, alias="RMARowId")
    remove_from_booking: Optional[StrictBool] = Field(default=None, alias="RemoveFromBooking")
    exchange_stock_item_id: Optional[StrictStr] = Field(default=None, alias="ExchangeStockItemId")
    exchange_sku: Optional[StrictStr] = Field(default=None, alias="ExchangeSKU")
    exchange_title: Optional[StrictStr] = Field(default=None, alias="ExchangeTitle")
    exchange_quantity: Optional[StrictInt] = Field(default=None, alias="ExchangeQuantity")
    despatch_location_id: Optional[StrictStr] = Field(default=None, alias="DespatchLocationId")
    additional_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="AdditionalCost")
    order_item_row_id: Optional[StrictStr] = Field(default=None, alias="OrderItemRowId")
    return_item_sku: Optional[StrictStr] = Field(default=None, alias="ReturnItemSKU")
    return_item_title: Optional[StrictStr] = Field(default=None, alias="ReturnItemTitle")
    batch_inventory_id: Optional[StrictInt] = Field(default=None, alias="BatchInventoryId")
    return_location: Optional[StrictStr] = Field(default=None, alias="ReturnLocation")
    return_quantity: Optional[StrictInt] = Field(default=None, alias="ReturnQuantity")
    refund_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="RefundAmount")
    refund_row_id: Optional[StrictStr] = Field(default=None, alias="RefundRowId")
    scrap_quantity: Optional[StrictInt] = Field(default=None, alias="ScrapQuantity")
    reason_category: Optional[StrictStr] = Field(default=None, alias="ReasonCategory")
    is_free_text: Optional[StrictBool] = Field(default=None, alias="IsFreeText")
    reason: Optional[StrictStr] = Field(default=None, alias="Reason")
    reason_tag: Optional[StrictStr] = Field(default=None, alias="ReasonTag")
    sub_reason_tag: Optional[StrictStr] = Field(default=None, alias="SubReasonTag")
    status: Optional[PostSaleStatus] = Field(default=None, alias="Status")
    binrack_override: Optional[StrictStr] = Field(default=None, alias="BinrackOverride")
    __properties: ClassVar[List[str]] = ["RMARowId", "RemoveFromBooking", "ExchangeStockItemId", "ExchangeSKU", "ExchangeTitle", "ExchangeQuantity", "DespatchLocationId", "AdditionalCost", "OrderItemRowId", "ReturnItemSKU", "ReturnItemTitle", "BatchInventoryId", "ReturnLocation", "ReturnQuantity", "RefundAmount", "RefundRowId", "ScrapQuantity", "ReasonCategory", "IsFreeText", "Reason", "ReasonTag", "SubReasonTag", "Status", "BinrackOverride"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdatedExchangeItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "is_free_text",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['Status'] = self.status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdatedExchangeItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "RMARowId": obj.get("RMARowId"),
            "RemoveFromBooking": obj.get("RemoveFromBooking"),
            "ExchangeStockItemId": obj.get("ExchangeStockItemId"),
            "ExchangeSKU": obj.get("ExchangeSKU"),
            "ExchangeTitle": obj.get("ExchangeTitle"),
            "ExchangeQuantity": obj.get("ExchangeQuantity"),
            "DespatchLocationId": obj.get("DespatchLocationId"),
            "AdditionalCost": obj.get("AdditionalCost"),
            "OrderItemRowId": obj.get("OrderItemRowId"),
            "ReturnItemSKU": obj.get("ReturnItemSKU"),
            "ReturnItemTitle": obj.get("ReturnItemTitle"),
            "BatchInventoryId": obj.get("BatchInventoryId"),
            "ReturnLocation": obj.get("ReturnLocation"),
            "ReturnQuantity": obj.get("ReturnQuantity"),
            "RefundAmount": obj.get("RefundAmount"),
            "RefundRowId": obj.get("RefundRowId"),
            "ScrapQuantity": obj.get("ScrapQuantity"),
            "ReasonCategory": obj.get("ReasonCategory"),
            "IsFreeText": obj.get("IsFreeText"),
            "Reason": obj.get("Reason"),
            "ReasonTag": obj.get("ReasonTag"),
            "SubReasonTag": obj.get("SubReasonTag"),
            "Status": PostSaleStatus.from_dict(obj["Status"]) if obj.get("Status") is not None else None,
            "BinrackOverride": obj.get("BinrackOverride")
        })
        return _obj


