# coding: utf-8

"""
    Returns and Refunds API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: returnsrefunds
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.returnsrefunds.models.post_sale_status import PostSaleStatus
from linnworks_api.generated.returnsrefunds.models.rma_error import RMAError
from typing import Optional, Set
from typing_extensions import Self

class VerifiedRMAItem(BaseModel):
    """
    VerifiedRMAItem
    """ # noqa: E501
    rma_row_id: Optional[StrictInt] = Field(default=None, alias="RMARowId")
    rma_header_id: Optional[StrictInt] = Field(default=None, alias="RMAHeaderId")
    type: Optional[StrictStr] = Field(default=None, alias="Type")
    status: Optional[PostSaleStatus] = Field(default=None, alias="Status")
    external_reference: Optional[StrictStr] = Field(default=None, alias="ExternalReference")
    created_date: Optional[datetime] = Field(default=None, alias="CreatedDate")
    actioned: Optional[StrictBool] = Field(default=None, alias="Actioned")
    actioned_date: Optional[datetime] = Field(default=None, alias="ActionedDate")
    deleted: Optional[StrictBool] = Field(default=None, alias="Deleted")
    resend_quantity: Optional[StrictInt] = Field(default=None, alias="ResendQuantity")
    new_order_id: Optional[StrictStr] = Field(default=None, alias="NewOrderId")
    validation_error: Optional[StrictStr] = Field(default=None, alias="ValidationError")
    error: Optional[StrictStr] = Field(default=None, alias="Error")
    errors: Optional[List[RMAError]] = Field(default=None, alias="Errors")
    info: Optional[StrictStr] = Field(default=None, alias="Info")
    exchange_stock_item_id: Optional[StrictStr] = Field(default=None, alias="ExchangeStockItemId")
    exchange_sku: Optional[StrictStr] = Field(default=None, alias="ExchangeSKU")
    exchange_title: Optional[StrictStr] = Field(default=None, alias="ExchangeTitle")
    exchange_quantity: Optional[StrictInt] = Field(default=None, alias="ExchangeQuantity")
    despatch_location_id: Optional[StrictStr] = Field(default=None, alias="DespatchLocationId")
    additional_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="AdditionalCost")
    order_item_row_id: Optional[StrictStr] = Field(default=None, alias="OrderItemRowId")
    return_item_sku: Optional[StrictStr] = Field(default=None, alias="ReturnItemSKU")
    return_item_title: Optional[StrictStr] = Field(default=None, alias="ReturnItemTitle")
    batch_inventory_id: Optional[StrictInt] = Field(default=None, alias="BatchInventoryId")
    return_location: Optional[StrictStr] = Field(default=None, alias="ReturnLocation")
    return_quantity: Optional[StrictInt] = Field(default=None, alias="ReturnQuantity")
    refund_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="RefundAmount")
    refund_row_id: Optional[StrictStr] = Field(default=None, alias="RefundRowId")
    scrap_quantity: Optional[StrictInt] = Field(default=None, alias="ScrapQuantity")
    reason_category: Optional[StrictStr] = Field(default=None, alias="ReasonCategory")
    is_free_text: Optional[StrictBool] = Field(default=None, alias="IsFreeText")
    reason: Optional[StrictStr] = Field(default=None, alias="Reason")
    reason_tag: Optional[StrictStr] = Field(default=None, alias="ReasonTag")
    sub_reason_tag: Optional[StrictStr] = Field(default=None, alias="SubReasonTag")
    binrack_override: Optional[StrictStr] = Field(default=None, alias="BinrackOverride")
    __properties: ClassVar[List[str]] = ["RMARowId", "RMAHeaderId", "Type", "Status", "ExternalReference", "CreatedDate", "Actioned", "ActionedDate", "Deleted", "ResendQuantity", "NewOrderId", "ValidationError", "Error", "Errors", "Info", "ExchangeStockItemId", "ExchangeSKU", "ExchangeTitle", "ExchangeQuantity", "DespatchLocationId", "AdditionalCost", "OrderItemRowId", "ReturnItemSKU", "ReturnItemTitle", "BatchInventoryId", "ReturnLocation", "ReturnQuantity", "RefundAmount", "RefundRowId", "ScrapQuantity", "ReasonCategory", "IsFreeText", "Reason", "ReasonTag", "SubReasonTag", "BinrackOverride"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Return', 'Exchange', 'Resend']):
            raise ValueError("must be one of enum values ('Return', 'Exchange', 'Resend')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VerifiedRMAItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "resend_quantity",
            "is_free_text",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['Status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in errors (list)
        _items = []
        if self.errors:
            for _item_errors in self.errors:
                if _item_errors:
                    _items.append(_item_errors.to_dict())
            _dict['Errors'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VerifiedRMAItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "RMARowId": obj.get("RMARowId"),
            "RMAHeaderId": obj.get("RMAHeaderId"),
            "Type": obj.get("Type"),
            "Status": PostSaleStatus.from_dict(obj["Status"]) if obj.get("Status") is not None else None,
            "ExternalReference": obj.get("ExternalReference"),
            "CreatedDate": obj.get("CreatedDate"),
            "Actioned": obj.get("Actioned"),
            "ActionedDate": obj.get("ActionedDate"),
            "Deleted": obj.get("Deleted"),
            "ResendQuantity": obj.get("ResendQuantity"),
            "NewOrderId": obj.get("NewOrderId"),
            "ValidationError": obj.get("ValidationError"),
            "Error": obj.get("Error"),
            "Errors": [RMAError.from_dict(_item) for _item in obj["Errors"]] if obj.get("Errors") is not None else None,
            "Info": obj.get("Info"),
            "ExchangeStockItemId": obj.get("ExchangeStockItemId"),
            "ExchangeSKU": obj.get("ExchangeSKU"),
            "ExchangeTitle": obj.get("ExchangeTitle"),
            "ExchangeQuantity": obj.get("ExchangeQuantity"),
            "DespatchLocationId": obj.get("DespatchLocationId"),
            "AdditionalCost": obj.get("AdditionalCost"),
            "OrderItemRowId": obj.get("OrderItemRowId"),
            "ReturnItemSKU": obj.get("ReturnItemSKU"),
            "ReturnItemTitle": obj.get("ReturnItemTitle"),
            "BatchInventoryId": obj.get("BatchInventoryId"),
            "ReturnLocation": obj.get("ReturnLocation"),
            "ReturnQuantity": obj.get("ReturnQuantity"),
            "RefundAmount": obj.get("RefundAmount"),
            "RefundRowId": obj.get("RefundRowId"),
            "ScrapQuantity": obj.get("ScrapQuantity"),
            "ReasonCategory": obj.get("ReasonCategory"),
            "IsFreeText": obj.get("IsFreeText"),
            "Reason": obj.get("Reason"),
            "ReasonTag": obj.get("ReasonTag"),
            "SubReasonTag": obj.get("SubReasonTag"),
            "BinrackOverride": obj.get("BinrackOverride")
        })
        return _obj


