# coding: utf-8

"""
    Rules Engine API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: rulesengine
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.rulesengine.models.action_type_descriptor_properties import ActionTypeDescriptorProperties
from typing import Optional, Set
from typing_extensions import Self

class ActionTypeDescriptor(BaseModel):
    """
    ActionTypeDescriptor
    """ # noqa: E501
    value: Optional[StrictStr] = Field(default=None, alias="Value")
    display_name: Optional[StrictStr] = Field(default=None, alias="DisplayName")
    properties: Optional[List[ActionTypeDescriptorProperties]] = Field(default=None, alias="Properties")
    display_type: Optional[StrictStr] = Field(default=None, alias="DisplayType")
    field_type: Optional[StrictStr] = Field(default=None, alias="FieldType")
    __properties: ClassVar[List[str]] = ["Value", "DisplayName", "Properties", "DisplayType", "FieldType"]

    @field_validator('value')
    def value_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['AssignShippingService', 'AssignToFolder', 'AssignToLocation', 'SplitOrderByWeight', 'SplitOrderByValue', 'SplitOrderSingle', 'AssignOrderExtendedProperty', 'ChangeOrderLockStatus', 'ChangeOrderParkStatus', 'AssignTagToOrder', 'ExecuteMacro', 'AssignIdentifierToOrder', 'BlockOrderFromMerging', 'SendToFulfillmentNetwork']):
            raise ValueError("must be one of enum values ('AssignShippingService', 'AssignToFolder', 'AssignToLocation', 'SplitOrderByWeight', 'SplitOrderByValue', 'SplitOrderSingle', 'AssignOrderExtendedProperty', 'ChangeOrderLockStatus', 'ChangeOrderParkStatus', 'AssignTagToOrder', 'ExecuteMacro', 'AssignIdentifierToOrder', 'BlockOrderFromMerging', 'SendToFulfillmentNetwork')")
        return value

    @field_validator('display_type')
    def display_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FreeText', 'AutoComplete', 'Dropdown', 'None']):
            raise ValueError("must be one of enum values ('FreeText', 'AutoComplete', 'Dropdown', 'None')")
        return value

    @field_validator('field_type')
    def field_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Default', 'String', 'Int', 'Bool', 'Guid', 'Float', 'Double']):
            raise ValueError("must be one of enum values ('Default', 'String', 'Int', 'Bool', 'Guid', 'Float', 'Double')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ActionTypeDescriptor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "display_type",
            "field_type",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in properties (list)
        _items = []
        if self.properties:
            for _item_properties in self.properties:
                if _item_properties:
                    _items.append(_item_properties.to_dict())
            _dict['Properties'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ActionTypeDescriptor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Value": obj.get("Value"),
            "DisplayName": obj.get("DisplayName"),
            "Properties": [ActionTypeDescriptorProperties.from_dict(_item) for _item in obj["Properties"]] if obj.get("Properties") is not None else None,
            "DisplayType": obj.get("DisplayType"),
            "FieldType": obj.get("FieldType")
        })
        return _obj


