# coding: utf-8

"""
    Shipping service API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: shippingservice
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.shippingservice.models.manifest_package import ManifestPackage
from linnworks_api.generated.shippingservice.models.service_property import ServiceProperty
from typing import Optional, Set
from typing_extensions import Self

class Consignment(BaseModel):
    """
    Consignment
    """ # noqa: E501
    consignment_id: Optional[StrictInt] = Field(default=None, alias="ConsignmentId")
    order_id: Optional[StrictInt] = Field(default=None, alias="OrderId")
    customer: Optional[StrictStr] = Field(default=None, alias="Customer")
    email: Optional[StrictStr] = Field(default=None, alias="Email")
    postal_code: Optional[StrictStr] = Field(default=None, alias="PostalCode")
    country: Optional[StrictStr] = Field(default=None, alias="Country")
    weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Weight")
    tracking_numbers: Optional[List[StrictStr]] = Field(default=None, alias="TrackingNumbers")
    packages: Optional[StrictInt] = Field(default=None, alias="Packages")
    consignment_packages: Optional[List[ManifestPackage]] = Field(default=None, alias="ConsignmentPackages")
    properties: Optional[List[ServiceProperty]] = Field(default=None, alias="Properties")
    deferred: Optional[StrictBool] = Field(default=None, alias="Deferred")
    service: Optional[StrictStr] = Field(default=None, alias="Service")
    __properties: ClassVar[List[str]] = ["ConsignmentId", "OrderId", "Customer", "Email", "PostalCode", "Country", "Weight", "TrackingNumbers", "Packages", "ConsignmentPackages", "Properties", "Deferred", "Service"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Consignment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in consignment_packages (list)
        _items = []
        if self.consignment_packages:
            for _item_consignment_packages in self.consignment_packages:
                if _item_consignment_packages:
                    _items.append(_item_consignment_packages.to_dict())
            _dict['ConsignmentPackages'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in properties (list)
        _items = []
        if self.properties:
            for _item_properties in self.properties:
                if _item_properties:
                    _items.append(_item_properties.to_dict())
            _dict['Properties'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Consignment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ConsignmentId": obj.get("ConsignmentId"),
            "OrderId": obj.get("OrderId"),
            "Customer": obj.get("Customer"),
            "Email": obj.get("Email"),
            "PostalCode": obj.get("PostalCode"),
            "Country": obj.get("Country"),
            "Weight": obj.get("Weight"),
            "TrackingNumbers": obj.get("TrackingNumbers"),
            "Packages": obj.get("Packages"),
            "ConsignmentPackages": [ManifestPackage.from_dict(_item) for _item in obj["ConsignmentPackages"]] if obj.get("ConsignmentPackages") is not None else None,
            "Properties": [ServiceProperty.from_dict(_item) for _item in obj["Properties"]] if obj.get("Properties") is not None else None,
            "Deferred": obj.get("Deferred"),
            "Service": obj.get("Service")
        })
        return _obj


