# coding: utf-8

"""
    Shipping service API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: shippingservice
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.shippingservice.models.print_zone_config import PrintZoneConfig
from linnworks_api.generated.shippingservice.models.printer_user_config import PrinterUserConfig
from typing import Optional, Set
from typing_extensions import Self

class PrinterConfig(BaseModel):
    """
    PrinterConfig
    """ # noqa: E501
    printer_name: Optional[StrictStr] = Field(default=None, alias="PrinterName")
    template_id: Optional[StrictStr] = Field(default=None, alias="TemplateId")
    label_format: Optional[StrictStr] = Field(default=None, alias="LabelFormat")
    margin_left: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="MarginLeft")
    margin_top: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="MarginTop")
    duplex: Optional[StrictBool] = Field(default=None, alias="Duplex")
    user_config: Optional[List[PrinterUserConfig]] = Field(default=None, alias="UserConfig")
    print_zone_config: Optional[List[PrintZoneConfig]] = Field(default=None, alias="PrintZoneConfig")
    __properties: ClassVar[List[str]] = ["PrinterName", "TemplateId", "LabelFormat", "MarginLeft", "MarginTop", "Duplex", "UserConfig", "PrintZoneConfig"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PrinterConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in user_config (list)
        _items = []
        if self.user_config:
            for _item_user_config in self.user_config:
                if _item_user_config:
                    _items.append(_item_user_config.to_dict())
            _dict['UserConfig'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in print_zone_config (list)
        _items = []
        if self.print_zone_config:
            for _item_print_zone_config in self.print_zone_config:
                if _item_print_zone_config:
                    _items.append(_item_print_zone_config.to_dict())
            _dict['PrintZoneConfig'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PrinterConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "PrinterName": obj.get("PrinterName"),
            "TemplateId": obj.get("TemplateId"),
            "LabelFormat": obj.get("LabelFormat"),
            "MarginLeft": obj.get("MarginLeft"),
            "MarginTop": obj.get("MarginTop"),
            "Duplex": obj.get("Duplex"),
            "UserConfig": [PrinterUserConfig.from_dict(_item) for _item in obj["UserConfig"]] if obj.get("UserConfig") is not None else None,
            "PrintZoneConfig": [PrintZoneConfig.from_dict(_item) for _item in obj["PrintZoneConfig"]] if obj.get("PrintZoneConfig") is not None else None
        })
        return _obj


