# coding: utf-8

"""
    Stock API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: stock
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.stock.models.stock_item_level import StockItemLevel
from typing import Optional, Set
from typing_extensions import Self

class GetStockLevelBatchResponse(BaseModel):
    """
    Response class with info about stock level in each location for a list of stock items
    """ # noqa: E501
    pk_stock_item_id: Optional[StrictStr] = Field(default=None, description="Id of the stock item", alias="pkStockItemId")
    stock_item_levels: Optional[List[StockItemLevel]] = Field(default=None, description="List of stock level for each location", alias="StockItemLevels")
    __properties: ClassVar[List[str]] = ["pkStockItemId", "StockItemLevels"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetStockLevelBatchResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in stock_item_levels (list)
        _items = []
        if self.stock_item_levels:
            for _item_stock_item_levels in self.stock_item_levels:
                if _item_stock_item_levels:
                    _items.append(_item_stock_item_levels.to_dict())
            _dict['StockItemLevels'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetStockLevelBatchResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pkStockItemId": obj.get("pkStockItemId"),
            "StockItemLevels": [StockItemLevel.from_dict(_item) for _item in obj["StockItemLevels"]] if obj.get("StockItemLevels") is not None else None
        })
        return _obj


