# coding: utf-8

"""
    Stock API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: stock
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.stock.models.inventory_stock_location import InventoryStockLocation
from typing import Optional, Set
from typing_extensions import Self

class StockItemLevel(BaseModel):
    """
    StockItemLevel
    """ # noqa: E501
    location: Optional[InventoryStockLocation] = Field(default=None, alias="Location")
    stock_level: Optional[StrictInt] = Field(default=None, alias="StockLevel")
    stock_value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="StockValue")
    minimum_level: Optional[StrictInt] = Field(default=None, alias="MinimumLevel")
    in_order_book: Optional[StrictInt] = Field(default=None, alias="InOrderBook")
    due: Optional[StrictInt] = Field(default=None, alias="Due")
    jit: Optional[StrictBool] = Field(default=None, alias="JIT")
    in_orders: Optional[StrictInt] = Field(default=None, alias="InOrders")
    available: Optional[StrictInt] = Field(default=None, alias="Available")
    unit_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="UnitCost")
    sku: Optional[StrictStr] = Field(default=None, alias="SKU")
    auto_adjust: Optional[StrictBool] = Field(default=None, alias="AutoAdjust")
    last_update_date: Optional[datetime] = Field(default=None, alias="LastUpdateDate")
    last_update_operation: Optional[StrictStr] = Field(default=None, alias="LastUpdateOperation")
    rowid: Optional[StrictStr] = None
    pending_update: Optional[StrictBool] = Field(default=None, alias="PendingUpdate")
    stock_item_purchase_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="StockItemPurchasePrice")
    stock_item_id: Optional[StrictStr] = Field(default=None, alias="StockItemId")
    stock_item_int_id: Optional[StrictInt] = Field(default=None, alias="StockItemIntId")
    __properties: ClassVar[List[str]] = ["Location", "StockLevel", "StockValue", "MinimumLevel", "InOrderBook", "Due", "JIT", "InOrders", "Available", "UnitCost", "SKU", "AutoAdjust", "LastUpdateDate", "LastUpdateOperation", "rowid", "PendingUpdate", "StockItemPurchasePrice", "StockItemId", "StockItemIntId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StockItemLevel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "in_orders",
            "available",
            "unit_cost",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['Location'] = self.location.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StockItemLevel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Location": InventoryStockLocation.from_dict(obj["Location"]) if obj.get("Location") is not None else None,
            "StockLevel": obj.get("StockLevel"),
            "StockValue": obj.get("StockValue"),
            "MinimumLevel": obj.get("MinimumLevel"),
            "InOrderBook": obj.get("InOrderBook"),
            "Due": obj.get("Due"),
            "JIT": obj.get("JIT"),
            "InOrders": obj.get("InOrders"),
            "Available": obj.get("Available"),
            "UnitCost": obj.get("UnitCost"),
            "SKU": obj.get("SKU"),
            "AutoAdjust": obj.get("AutoAdjust"),
            "LastUpdateDate": obj.get("LastUpdateDate"),
            "LastUpdateOperation": obj.get("LastUpdateOperation"),
            "rowid": obj.get("rowid"),
            "PendingUpdate": obj.get("PendingUpdate"),
            "StockItemPurchasePrice": obj.get("StockItemPurchasePrice"),
            "StockItemId": obj.get("StockItemId"),
            "StockItemIntId": obj.get("StockItemIntId")
        })
        return _obj


