# coding: utf-8

"""
    Stock API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: stock
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UpdateWarehouseMoveRequest(BaseModel):
    """
    UpdateWarehouseMoveRequest
    """ # noqa: E501
    move_id: Optional[StrictInt] = Field(default=None, description="The Id of the stock move to update", alias="MoveId")
    batch_inventory_id: Optional[StrictInt] = Field(default=None, description="Batch Inventory Id of the stock item you are moving", alias="BatchInventoryId")
    quantity: Optional[StrictInt] = Field(default=None, description="Quantity of items being moved", alias="Quantity")
    binrack_id_destination: Optional[StrictInt] = Field(default=None, description="Destination if known, can be null", alias="BinrackIdDestination")
    job_id: Optional[StrictInt] = Field(default=None, description="If the move is part of a specific job, specify job id so it can be marked off from the job", alias="JobId")
    tot_id: Optional[StrictInt] = Field(default=None, description="(Optional) Move to TOT id, create or retrive tot scan barcode first. To unassign from Tot send 0", alias="TotId")
    tx_type: Optional[StrictStr] = Field(default=None, description="Type of the move. Open means its an instruction to move, In Transit actually marks the item as unavilable and physically being moved", alias="TxType")
    user_id: Optional[StrictStr] = Field(default=None, alias="UserId")
    __properties: ClassVar[List[str]] = ["MoveId", "BatchInventoryId", "Quantity", "BinrackIdDestination", "JobId", "TotId", "TxType", "UserId"]

    @field_validator('tx_type')
    def tx_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Open', 'InTransit']):
            raise ValueError("must be one of enum values ('Open', 'InTransit')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateWarehouseMoveRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateWarehouseMoveRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "MoveId": obj.get("MoveId"),
            "BatchInventoryId": obj.get("BatchInventoryId"),
            "Quantity": obj.get("Quantity"),
            "BinrackIdDestination": obj.get("BinrackIdDestination"),
            "JobId": obj.get("JobId"),
            "TotId": obj.get("TotId"),
            "TxType": obj.get("TxType"),
            "UserId": obj.get("UserId")
        })
        return _obj


