# coding: utf-8

"""
    Stock API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: stock
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.stock.models.dimension import Dimension
from linnworks_api.generated.stock.models.geo_position import GeoPosition
from linnworks_api.generated.stock.models.warehouse_bin_rack_items_info import WarehouseBinRackItemsInfo
from linnworks_api.generated.stock.models.warehouse_bin_rack_type import WarehouseBinRackType
from typing import Optional, Set
from typing_extensions import Self

class WarehouseBinRack(BaseModel):
    """
    WarehouseBinRack
    """ # noqa: E501
    bin_rack_id: Optional[StrictInt] = Field(default=None, alias="BinRackId")
    bin_rack_type_id: Optional[StrictInt] = Field(default=None, alias="BinRackTypeId")
    bin_rack: Optional[StrictStr] = Field(default=None, alias="BinRack")
    geo_position: Optional[GeoPosition] = Field(default=None, alias="GeoPosition")
    dimension: Optional[Dimension] = Field(default=None, alias="Dimension")
    routing_sequence: Optional[StrictInt] = Field(default=None, alias="RoutingSequence")
    max_capacity_volumetric: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="MaxCapacityVolumetric")
    current_full_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="CurrentFullPercentage")
    max_quantity_capacity: Optional[StrictInt] = Field(default=None, alias="MaxQuantityCapacity")
    current_quantity: Optional[StrictInt] = Field(default=None, alias="CurrentQuantity")
    current_volumetric: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="CurrentVolumetric")
    optimal_replenish_full_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="OptimalReplenishFullPercentage")
    critical_replenish_full_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="CriticalReplenishFullPercentage")
    item_restriction: Optional[StrictBool] = Field(default=None, alias="ItemRestriction")
    group_restriction: Optional[StrictBool] = Field(default=None, alias="GroupRestriction")
    location_id: Optional[StrictStr] = Field(default=None, alias="LocationId")
    type_name: Optional[StrictStr] = Field(default=None, alias="TypeName")
    standard_type: Optional[StrictInt] = Field(default=None, alias="StandardType")
    is_volumetric: Optional[StrictBool] = Field(default=None, alias="IsVolumetric")
    access_orientation: Optional[StrictStr] = Field(default=None, alias="AccessOrientation")
    storage_groups: Optional[List[StrictStr]] = Field(default=None, alias="StorageGroups")
    unique_skus: Optional[StrictInt] = Field(default=None, alias="UniqueSkus")
    items_info: Optional[WarehouseBinRackItemsInfo] = Field(default=None, alias="ItemsInfo")
    binrack_type: Optional[WarehouseBinRackType] = Field(default=None, alias="BinrackType")
    is_valid_for_stock_item: Optional[StrictBool] = Field(default=None, alias="IsValidForStockItem")
    __properties: ClassVar[List[str]] = ["BinRackId", "BinRackTypeId", "BinRack", "GeoPosition", "Dimension", "RoutingSequence", "MaxCapacityVolumetric", "CurrentFullPercentage", "MaxQuantityCapacity", "CurrentQuantity", "CurrentVolumetric", "OptimalReplenishFullPercentage", "CriticalReplenishFullPercentage", "ItemRestriction", "GroupRestriction", "LocationId", "TypeName", "StandardType", "IsVolumetric", "AccessOrientation", "StorageGroups", "UniqueSkus", "ItemsInfo", "BinrackType", "IsValidForStockItem"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WarehouseBinRack from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of geo_position
        if self.geo_position:
            _dict['GeoPosition'] = self.geo_position.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dimension
        if self.dimension:
            _dict['Dimension'] = self.dimension.to_dict()
        # override the default output from pydantic by calling `to_dict()` of items_info
        if self.items_info:
            _dict['ItemsInfo'] = self.items_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of binrack_type
        if self.binrack_type:
            _dict['BinrackType'] = self.binrack_type.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WarehouseBinRack from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "BinRackId": obj.get("BinRackId"),
            "BinRackTypeId": obj.get("BinRackTypeId"),
            "BinRack": obj.get("BinRack"),
            "GeoPosition": GeoPosition.from_dict(obj["GeoPosition"]) if obj.get("GeoPosition") is not None else None,
            "Dimension": Dimension.from_dict(obj["Dimension"]) if obj.get("Dimension") is not None else None,
            "RoutingSequence": obj.get("RoutingSequence"),
            "MaxCapacityVolumetric": obj.get("MaxCapacityVolumetric"),
            "CurrentFullPercentage": obj.get("CurrentFullPercentage"),
            "MaxQuantityCapacity": obj.get("MaxQuantityCapacity"),
            "CurrentQuantity": obj.get("CurrentQuantity"),
            "CurrentVolumetric": obj.get("CurrentVolumetric"),
            "OptimalReplenishFullPercentage": obj.get("OptimalReplenishFullPercentage"),
            "CriticalReplenishFullPercentage": obj.get("CriticalReplenishFullPercentage"),
            "ItemRestriction": obj.get("ItemRestriction"),
            "GroupRestriction": obj.get("GroupRestriction"),
            "LocationId": obj.get("LocationId"),
            "TypeName": obj.get("TypeName"),
            "StandardType": obj.get("StandardType"),
            "IsVolumetric": obj.get("IsVolumetric"),
            "AccessOrientation": obj.get("AccessOrientation"),
            "StorageGroups": obj.get("StorageGroups"),
            "UniqueSkus": obj.get("UniqueSkus"),
            "ItemsInfo": WarehouseBinRackItemsInfo.from_dict(obj["ItemsInfo"]) if obj.get("ItemsInfo") is not None else None,
            "BinrackType": WarehouseBinRackType.from_dict(obj["BinrackType"]) if obj.get("BinrackType") is not None else None,
            "IsValidForStockItem": obj.get("IsValidForStockItem")
        })
        return _obj


