# linnworks_api.generated.warehousetransfer.WarehouseTransferApi

All URIs are relative to *https://eu-ext.linnworks.net*

Method | HTTP request | Description
------------- | ------------- | -------------
[**add_item_to_transfer**](WarehouseTransferApi.md#add_item_to_transfer) | **POST** /api/WarehouseTransfer/AddItemToTransfer | AddItemToTransfer
[**add_items_to_transfer**](WarehouseTransferApi.md#add_items_to_transfer) | **POST** /api/WarehouseTransfer/AddItemsToTransfer | AddItemsToTransfer
[**add_transfer_bin_note**](WarehouseTransferApi.md#add_transfer_bin_note) | **POST** /api/WarehouseTransfer/AddTransferBinNote | AddTransferBinNote
[**add_transfer_item_note**](WarehouseTransferApi.md#add_transfer_item_note) | **POST** /api/WarehouseTransfer/AddTransferItemNote | AddTransferItemNote
[**add_transfer_note**](WarehouseTransferApi.md#add_transfer_note) | **POST** /api/WarehouseTransfer/AddTransferNote | AddTransferNote
[**add_transfer_property**](WarehouseTransferApi.md#add_transfer_property) | **POST** /api/WarehouseTransfer/AddTransferProperty | AddTransferProperty
[**allocate_item_to_bin**](WarehouseTransferApi.md#allocate_item_to_bin) | **POST** /api/WarehouseTransfer/AllocateItemToBin | AllocateItemToBin
[**change_bin_details**](WarehouseTransferApi.md#change_bin_details) | **POST** /api/WarehouseTransfer/ChangeBinDetails | ChangeBinDetails
[**change_transfer_from_location**](WarehouseTransferApi.md#change_transfer_from_location) | **POST** /api/WarehouseTransfer/ChangeTransferFromLocation | ChangeTransferFromLocation
[**change_transfer_item_received_quantity**](WarehouseTransferApi.md#change_transfer_item_received_quantity) | **POST** /api/WarehouseTransfer/ChangeTransferItemReceivedQuantity | ChangeTransferItemReceivedQuantity
[**change_transfer_item_request_quantity**](WarehouseTransferApi.md#change_transfer_item_request_quantity) | **POST** /api/WarehouseTransfer/ChangeTransferItemRequestQuantity | ChangeTransferItemRequestQuantity
[**change_transfer_item_sent_quantity**](WarehouseTransferApi.md#change_transfer_item_sent_quantity) | **POST** /api/WarehouseTransfer/ChangeTransferItemSentQuantity | ChangeTransferItemSentQuantity
[**change_transfer_locations**](WarehouseTransferApi.md#change_transfer_locations) | **POST** /api/WarehouseTransfer/ChangeTransferLocations | ChangeTransferLocations
[**change_transfer_property**](WarehouseTransferApi.md#change_transfer_property) | **POST** /api/WarehouseTransfer/ChangeTransferProperty | ChangeTransferProperty
[**change_transfer_status**](WarehouseTransferApi.md#change_transfer_status) | **POST** /api/WarehouseTransfer/ChangeTransferStatus | ChangeTransferStatus
[**change_transfer_to_location**](WarehouseTransferApi.md#change_transfer_to_location) | **POST** /api/WarehouseTransfer/ChangeTransferToLocation | ChangeTransferToLocation
[**check_for_draft_transfer**](WarehouseTransferApi.md#check_for_draft_transfer) | **GET** /api/WarehouseTransfer/CheckForDraftTransfer | CheckForDraftTransfer
[**create_new_bin**](WarehouseTransferApi.md#create_new_bin) | **POST** /api/WarehouseTransfer/CreateNewBin | CreateNewBin
[**create_transfer_from_descrepancies**](WarehouseTransferApi.md#create_transfer_from_descrepancies) | **POST** /api/WarehouseTransfer/CreateTransferFromDescrepancies | CreateTransferFromDescrepancies
[**create_transfer_request_with_return**](WarehouseTransferApi.md#create_transfer_request_with_return) | **POST** /api/WarehouseTransfer/CreateTransferRequestWithReturn | CreateTransferRequestWithReturn
[**delete_empty_draft_transfer**](WarehouseTransferApi.md#delete_empty_draft_transfer) | **POST** /api/WarehouseTransfer/DeleteEmptyDraftTransfer | DeleteEmptyDraftTransfer
[**delete_transfer**](WarehouseTransferApi.md#delete_transfer) | **POST** /api/WarehouseTransfer/DeleteTransfer | DeleteTransfer
[**delete_transfer_property**](WarehouseTransferApi.md#delete_transfer_property) | **POST** /api/WarehouseTransfer/DeleteTransferProperty | DeleteTransferProperty
[**get_active_transfers_all_locations**](WarehouseTransferApi.md#get_active_transfers_all_locations) | **GET** /api/WarehouseTransfer/GetActiveTransfersAllLocations | GetActiveTransfersAllLocations
[**get_active_transfers_for_location**](WarehouseTransferApi.md#get_active_transfers_for_location) | **GET** /api/WarehouseTransfer/GetActiveTransfersForLocation | GetActiveTransfersForLocation
[**get_archived_transfers**](WarehouseTransferApi.md#get_archived_transfers) | **GET** /api/WarehouseTransfer/GetArchivedTransfers | GetArchivedTransfers
[**get_archived_transfers_between_archived_dates**](WarehouseTransferApi.md#get_archived_transfers_between_archived_dates) | **GET** /api/WarehouseTransfer/GetArchivedTransfersBetweenArchivedDates | GetArchivedTransfersBetweenArchivedDates
[**get_archived_transfers_between_dates**](WarehouseTransferApi.md#get_archived_transfers_between_dates) | **GET** /api/WarehouseTransfer/GetArchivedTransfersBetweenDates | GetArchivedTransfersBetweenDates
[**get_archived_transfers_filtered**](WarehouseTransferApi.md#get_archived_transfers_filtered) | **GET** /api/WarehouseTransfer/GetArchivedTransfersFiltered | GetArchivedTransfersFiltered
[**get_discrepancy_items**](WarehouseTransferApi.md#get_discrepancy_items) | **GET** /api/WarehouseTransfer/GetDiscrepancyItems | GetDiscrepancyItems
[**get_list_transfers**](WarehouseTransferApi.md#get_list_transfers) | **POST** /api/WarehouseTransfer/GetListTransfers | GetListTransfers
[**get_modified_basic**](WarehouseTransferApi.md#get_modified_basic) | **GET** /api/WarehouseTransfer/GetModifiedBasic | GetModifiedBasic
[**get_server_time**](WarehouseTransferApi.md#get_server_time) | **GET** /api/WarehouseTransfer/GetServerTime | GetServerTime
[**get_stock_availability**](WarehouseTransferApi.md#get_stock_availability) | **GET** /api/WarehouseTransfer/GetStockAvailability | GetStockAvailability
[**get_transfer_audit**](WarehouseTransferApi.md#get_transfer_audit) | **GET** /api/WarehouseTransfer/GetTransferAudit | GetTransferAudit
[**get_transfer_bin_notes**](WarehouseTransferApi.md#get_transfer_bin_notes) | **GET** /api/WarehouseTransfer/GetTransferBinNotes | GetTransferBinNotes
[**get_transfer_item_notes**](WarehouseTransferApi.md#get_transfer_item_notes) | **GET** /api/WarehouseTransfer/GetTransferItemNotes | GetTransferItemNotes
[**get_transfer_items**](WarehouseTransferApi.md#get_transfer_items) | **GET** /api/WarehouseTransfer/GetTransferItems | GetTransferItems
[**get_transfer_notes**](WarehouseTransferApi.md#get_transfer_notes) | **GET** /api/WarehouseTransfer/GetTransferNotes | GetTransferNotes
[**get_transfer_properties**](WarehouseTransferApi.md#get_transfer_properties) | **GET** /api/WarehouseTransfer/GetTransferProperties | GetTransferProperties
[**get_transfer_with_items**](WarehouseTransferApi.md#get_transfer_with_items) | **GET** /api/WarehouseTransfer/GetTransferWithItems | GetTransferWithItems
[**get_transfer_with_notes**](WarehouseTransferApi.md#get_transfer_with_notes) | **GET** /api/WarehouseTransfer/GetTransferWithNotes | GetTransferWithNotes
[**is_draft_transfer_changed**](WarehouseTransferApi.md#is_draft_transfer_changed) | **GET** /api/WarehouseTransfer/IsDraftTransferChanged | IsDraftTransferChanged
[**print_transfer**](WarehouseTransferApi.md#print_transfer) | **POST** /api/WarehouseTransfer/PrintTransfer | PrintTransfer
[**remove_all_empty_bins**](WarehouseTransferApi.md#remove_all_empty_bins) | **POST** /api/WarehouseTransfer/RemoveAllEmptyBins | RemoveAllEmptyBins
[**remove_item_from_transfer**](WarehouseTransferApi.md#remove_item_from_transfer) | **POST** /api/WarehouseTransfer/RemoveItemFromTransfer | RemoveItemFromTransfer
[**search_transfers_all_locations**](WarehouseTransferApi.md#search_transfers_all_locations) | **GET** /api/WarehouseTransfer/SearchTransfersAllLocations | SearchTransfersAllLocations
[**search_transfers_by_location**](WarehouseTransferApi.md#search_transfers_by_location) | **GET** /api/WarehouseTransfer/SearchTransfersByLocation | SearchTransfersByLocation
[**set_reference_number**](WarehouseTransferApi.md#set_reference_number) | **POST** /api/WarehouseTransfer/SetReferenceNumber | SetReferenceNumber


# **add_item_to_transfer**
> WarehouseTransferItem add_item_to_transfer(warehouse_transfer_add_item_to_transfer_request)

AddItemToTransfer

Use this call to add an item to the transfer (only works for transfers in draft/request states) <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_add_item_to_transfer_request import WarehouseTransferAddItemToTransferRequest
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_item import WarehouseTransferItem
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_add_item_to_transfer_request = linnworks_api.generated.warehousetransfer.WarehouseTransferAddItemToTransferRequest() # WarehouseTransferAddItemToTransferRequest | 

    try:
        # AddItemToTransfer
        api_response = api_instance.add_item_to_transfer(warehouse_transfer_add_item_to_transfer_request)
        print("The response of WarehouseTransferApi->add_item_to_transfer:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->add_item_to_transfer: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_add_item_to_transfer_request** | [**WarehouseTransferAddItemToTransferRequest**](WarehouseTransferAddItemToTransferRequest.md)|  | 

### Return type

[**WarehouseTransferItem**](WarehouseTransferItem.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **add_items_to_transfer**
> AddItemsToTransferResponse add_items_to_transfer(request=request)

AddItemsToTransfer

Use this call to add multiple items to the transfer (only works for transfers in draft/request states) <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.add_items_to_transfer_request import AddItemsToTransferRequest
from linnworks_api.generated.warehousetransfer.models.add_items_to_transfer_response import AddItemsToTransferResponse
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    request = linnworks_api.generated.warehousetransfer.AddItemsToTransferRequest() # AddItemsToTransferRequest | Request object with data needed (optional)

    try:
        # AddItemsToTransfer
        api_response = api_instance.add_items_to_transfer(request=request)
        print("The response of WarehouseTransferApi->add_items_to_transfer:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->add_items_to_transfer: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **request** | [**AddItemsToTransferRequest**](AddItemsToTransferRequest.md)| Request object with data needed | [optional] 

### Return type

[**AddItemsToTransferResponse**](AddItemsToTransferResponse.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **add_transfer_bin_note**
> str add_transfer_bin_note(warehouse_transfer_add_transfer_bin_note_request)

AddTransferBinNote

Use this call to add a note to a bin <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_add_transfer_bin_note_request import WarehouseTransferAddTransferBinNoteRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_add_transfer_bin_note_request = linnworks_api.generated.warehousetransfer.WarehouseTransferAddTransferBinNoteRequest() # WarehouseTransferAddTransferBinNoteRequest | 

    try:
        # AddTransferBinNote
        api_response = api_instance.add_transfer_bin_note(warehouse_transfer_add_transfer_bin_note_request)
        print("The response of WarehouseTransferApi->add_transfer_bin_note:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->add_transfer_bin_note: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_add_transfer_bin_note_request** | [**WarehouseTransferAddTransferBinNoteRequest**](WarehouseTransferAddTransferBinNoteRequest.md)|  | 

### Return type

**str**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **add_transfer_item_note**
> str add_transfer_item_note(warehouse_transfer_add_transfer_item_note_request)

AddTransferItemNote

Use this call to add a note to a transfer item. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_add_transfer_item_note_request import WarehouseTransferAddTransferItemNoteRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_add_transfer_item_note_request = linnworks_api.generated.warehousetransfer.WarehouseTransferAddTransferItemNoteRequest() # WarehouseTransferAddTransferItemNoteRequest | 

    try:
        # AddTransferItemNote
        api_response = api_instance.add_transfer_item_note(warehouse_transfer_add_transfer_item_note_request)
        print("The response of WarehouseTransferApi->add_transfer_item_note:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->add_transfer_item_note: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_add_transfer_item_note_request** | [**WarehouseTransferAddTransferItemNoteRequest**](WarehouseTransferAddTransferItemNoteRequest.md)|  | 

### Return type

**str**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **add_transfer_note**
> str add_transfer_note(warehouse_transfer_add_transfer_note_request)

AddTransferNote

Use this call to add a note to the transfer <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_add_transfer_note_request import WarehouseTransferAddTransferNoteRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_add_transfer_note_request = linnworks_api.generated.warehousetransfer.WarehouseTransferAddTransferNoteRequest() # WarehouseTransferAddTransferNoteRequest | 

    try:
        # AddTransferNote
        api_response = api_instance.add_transfer_note(warehouse_transfer_add_transfer_note_request)
        print("The response of WarehouseTransferApi->add_transfer_note:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->add_transfer_note: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_add_transfer_note_request** | [**WarehouseTransferAddTransferNoteRequest**](WarehouseTransferAddTransferNoteRequest.md)|  | 

### Return type

**str**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **add_transfer_property**
> str add_transfer_property(warehouse_transfer_add_transfer_property_request)

AddTransferProperty

Use this call to add a property to the transfer. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_add_transfer_property_request import WarehouseTransferAddTransferPropertyRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_add_transfer_property_request = linnworks_api.generated.warehousetransfer.WarehouseTransferAddTransferPropertyRequest() # WarehouseTransferAddTransferPropertyRequest | 

    try:
        # AddTransferProperty
        api_response = api_instance.add_transfer_property(warehouse_transfer_add_transfer_property_request)
        print("The response of WarehouseTransferApi->add_transfer_property:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->add_transfer_property: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_add_transfer_property_request** | [**WarehouseTransferAddTransferPropertyRequest**](WarehouseTransferAddTransferPropertyRequest.md)|  | 

### Return type

**str**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **allocate_item_to_bin**
> int allocate_item_to_bin(warehouse_transfer_allocate_item_to_bin_request)

AllocateItemToBin

Use this call to allocate stock, in part or in full, from one bin to another. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_allocate_item_to_bin_request import WarehouseTransferAllocateItemToBinRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_allocate_item_to_bin_request = linnworks_api.generated.warehousetransfer.WarehouseTransferAllocateItemToBinRequest() # WarehouseTransferAllocateItemToBinRequest | 

    try:
        # AllocateItemToBin
        api_response = api_instance.allocate_item_to_bin(warehouse_transfer_allocate_item_to_bin_request)
        print("The response of WarehouseTransferApi->allocate_item_to_bin:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->allocate_item_to_bin: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_allocate_item_to_bin_request** | [**WarehouseTransferAllocateItemToBinRequest**](WarehouseTransferAllocateItemToBinRequest.md)|  | 

### Return type

**int**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **change_bin_details**
> change_bin_details(warehouse_transfer_change_bin_details_request)

ChangeBinDetails

Use this call to change details of a bin. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_change_bin_details_request import WarehouseTransferChangeBinDetailsRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_change_bin_details_request = linnworks_api.generated.warehousetransfer.WarehouseTransferChangeBinDetailsRequest() # WarehouseTransferChangeBinDetailsRequest | 

    try:
        # ChangeBinDetails
        api_instance.change_bin_details(warehouse_transfer_change_bin_details_request)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->change_bin_details: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_change_bin_details_request** | [**WarehouseTransferChangeBinDetailsRequest**](WarehouseTransferChangeBinDetailsRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **change_transfer_from_location**
> change_transfer_from_location(warehouse_transfer_change_transfer_from_location_request)

ChangeTransferFromLocation

Use this call to update the from location of a transfer. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_change_transfer_from_location_request import WarehouseTransferChangeTransferFromLocationRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_change_transfer_from_location_request = linnworks_api.generated.warehousetransfer.WarehouseTransferChangeTransferFromLocationRequest() # WarehouseTransferChangeTransferFromLocationRequest | 

    try:
        # ChangeTransferFromLocation
        api_instance.change_transfer_from_location(warehouse_transfer_change_transfer_from_location_request)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->change_transfer_from_location: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_change_transfer_from_location_request** | [**WarehouseTransferChangeTransferFromLocationRequest**](WarehouseTransferChangeTransferFromLocationRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **change_transfer_item_received_quantity**
> change_transfer_item_received_quantity(warehouse_transfer_change_transfer_item_received_quantity_request)

ChangeTransferItemReceivedQuantity

Use this call to change the received quantity of a transfer item. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_change_transfer_item_received_quantity_request import WarehouseTransferChangeTransferItemReceivedQuantityRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_change_transfer_item_received_quantity_request = linnworks_api.generated.warehousetransfer.WarehouseTransferChangeTransferItemReceivedQuantityRequest() # WarehouseTransferChangeTransferItemReceivedQuantityRequest | 

    try:
        # ChangeTransferItemReceivedQuantity
        api_instance.change_transfer_item_received_quantity(warehouse_transfer_change_transfer_item_received_quantity_request)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->change_transfer_item_received_quantity: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_change_transfer_item_received_quantity_request** | [**WarehouseTransferChangeTransferItemReceivedQuantityRequest**](WarehouseTransferChangeTransferItemReceivedQuantityRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **change_transfer_item_request_quantity**
> change_transfer_item_request_quantity(warehouse_transfer_change_transfer_item_request_quantity_request)

ChangeTransferItemRequestQuantity

Use this call to change the requested quantity for an item on a transfer in Draft or Request states. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_change_transfer_item_request_quantity_request import WarehouseTransferChangeTransferItemRequestQuantityRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_change_transfer_item_request_quantity_request = linnworks_api.generated.warehousetransfer.WarehouseTransferChangeTransferItemRequestQuantityRequest() # WarehouseTransferChangeTransferItemRequestQuantityRequest | 

    try:
        # ChangeTransferItemRequestQuantity
        api_instance.change_transfer_item_request_quantity(warehouse_transfer_change_transfer_item_request_quantity_request)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->change_transfer_item_request_quantity: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_change_transfer_item_request_quantity_request** | [**WarehouseTransferChangeTransferItemRequestQuantityRequest**](WarehouseTransferChangeTransferItemRequestQuantityRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **change_transfer_item_sent_quantity**
> WarehouseTransferItem change_transfer_item_sent_quantity(warehouse_transfer_change_transfer_item_sent_quantity_request)

ChangeTransferItemSentQuantity

Use this call to change the sent quantity of an item in the specified bin. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_change_transfer_item_sent_quantity_request import WarehouseTransferChangeTransferItemSentQuantityRequest
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_item import WarehouseTransferItem
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_change_transfer_item_sent_quantity_request = linnworks_api.generated.warehousetransfer.WarehouseTransferChangeTransferItemSentQuantityRequest() # WarehouseTransferChangeTransferItemSentQuantityRequest | 

    try:
        # ChangeTransferItemSentQuantity
        api_response = api_instance.change_transfer_item_sent_quantity(warehouse_transfer_change_transfer_item_sent_quantity_request)
        print("The response of WarehouseTransferApi->change_transfer_item_sent_quantity:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->change_transfer_item_sent_quantity: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_change_transfer_item_sent_quantity_request** | [**WarehouseTransferChangeTransferItemSentQuantityRequest**](WarehouseTransferChangeTransferItemSentQuantityRequest.md)|  | 

### Return type

[**WarehouseTransferItem**](WarehouseTransferItem.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **change_transfer_locations**
> change_transfer_locations(warehouse_transfer_change_transfer_locations_request)

ChangeTransferLocations

Use this call to update the from and to locations of a transfer. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_change_transfer_locations_request import WarehouseTransferChangeTransferLocationsRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_change_transfer_locations_request = linnworks_api.generated.warehousetransfer.WarehouseTransferChangeTransferLocationsRequest() # WarehouseTransferChangeTransferLocationsRequest | 

    try:
        # ChangeTransferLocations
        api_instance.change_transfer_locations(warehouse_transfer_change_transfer_locations_request)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->change_transfer_locations: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_change_transfer_locations_request** | [**WarehouseTransferChangeTransferLocationsRequest**](WarehouseTransferChangeTransferLocationsRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **change_transfer_property**
> change_transfer_property(warehouse_transfer_change_transfer_property_request)

ChangeTransferProperty

Use this call to change a property belonging to a given transfer. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_change_transfer_property_request import WarehouseTransferChangeTransferPropertyRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_change_transfer_property_request = linnworks_api.generated.warehousetransfer.WarehouseTransferChangeTransferPropertyRequest() # WarehouseTransferChangeTransferPropertyRequest | 

    try:
        # ChangeTransferProperty
        api_instance.change_transfer_property(warehouse_transfer_change_transfer_property_request)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->change_transfer_property: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_change_transfer_property_request** | [**WarehouseTransferChangeTransferPropertyRequest**](WarehouseTransferChangeTransferPropertyRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **change_transfer_status**
> change_transfer_status(warehouse_transfer_change_transfer_status_request)

ChangeTransferStatus

Use this call to change a transfer's status <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_change_transfer_status_request import WarehouseTransferChangeTransferStatusRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_change_transfer_status_request = linnworks_api.generated.warehousetransfer.WarehouseTransferChangeTransferStatusRequest() # WarehouseTransferChangeTransferStatusRequest | 

    try:
        # ChangeTransferStatus
        api_instance.change_transfer_status(warehouse_transfer_change_transfer_status_request)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->change_transfer_status: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_change_transfer_status_request** | [**WarehouseTransferChangeTransferStatusRequest**](WarehouseTransferChangeTransferStatusRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **change_transfer_to_location**
> change_transfer_to_location(warehouse_transfer_change_transfer_to_location_request)

ChangeTransferToLocation

Use this call to update the to location of a transfer. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_change_transfer_to_location_request import WarehouseTransferChangeTransferToLocationRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_change_transfer_to_location_request = linnworks_api.generated.warehousetransfer.WarehouseTransferChangeTransferToLocationRequest() # WarehouseTransferChangeTransferToLocationRequest | 

    try:
        # ChangeTransferToLocation
        api_instance.change_transfer_to_location(warehouse_transfer_change_transfer_to_location_request)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->change_transfer_to_location: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_change_transfer_to_location_request** | [**WarehouseTransferChangeTransferToLocationRequest**](WarehouseTransferChangeTransferToLocationRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **check_for_draft_transfer**
> str check_for_draft_transfer(to_location_id=to_location_id, from_location_id=from_location_id)

CheckForDraftTransfer

Use this call to see if a draft transfer already exists for the two locations <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    to_location_id = 'to_location_id_example' # str | The id of the location the transfer should be going to (optional)
    from_location_id = 'from_location_id_example' # str | The id of the location the transfer should be coming from (optional)

    try:
        # CheckForDraftTransfer
        api_response = api_instance.check_for_draft_transfer(to_location_id=to_location_id, from_location_id=from_location_id)
        print("The response of WarehouseTransferApi->check_for_draft_transfer:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->check_for_draft_transfer: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **to_location_id** | **str**| The id of the location the transfer should be going to | [optional] 
 **from_location_id** | **str**| The id of the location the transfer should be coming from | [optional] 

### Return type

**str**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_new_bin**
> WarehouseTransferBin create_new_bin(warehouse_transfer_create_new_bin_request)

CreateNewBin

Use this call to create a new bin. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_bin import WarehouseTransferBin
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_create_new_bin_request import WarehouseTransferCreateNewBinRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_create_new_bin_request = linnworks_api.generated.warehousetransfer.WarehouseTransferCreateNewBinRequest() # WarehouseTransferCreateNewBinRequest | 

    try:
        # CreateNewBin
        api_response = api_instance.create_new_bin(warehouse_transfer_create_new_bin_request)
        print("The response of WarehouseTransferApi->create_new_bin:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->create_new_bin: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_create_new_bin_request** | [**WarehouseTransferCreateNewBinRequest**](WarehouseTransferCreateNewBinRequest.md)|  | 

### Return type

[**WarehouseTransferBin**](WarehouseTransferBin.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_transfer_from_descrepancies**
> WarehouseTransfer create_transfer_from_descrepancies(warehouse_transfer_create_transfer_from_descrepancies_request)

CreateTransferFromDescrepancies

Use this call to create a new transfer request from discrepancies <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer import WarehouseTransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_create_transfer_from_descrepancies_request import WarehouseTransferCreateTransferFromDescrepanciesRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_create_transfer_from_descrepancies_request = linnworks_api.generated.warehousetransfer.WarehouseTransferCreateTransferFromDescrepanciesRequest() # WarehouseTransferCreateTransferFromDescrepanciesRequest | 

    try:
        # CreateTransferFromDescrepancies
        api_response = api_instance.create_transfer_from_descrepancies(warehouse_transfer_create_transfer_from_descrepancies_request)
        print("The response of WarehouseTransferApi->create_transfer_from_descrepancies:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->create_transfer_from_descrepancies: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_create_transfer_from_descrepancies_request** | [**WarehouseTransferCreateTransferFromDescrepanciesRequest**](WarehouseTransferCreateTransferFromDescrepanciesRequest.md)|  | 

### Return type

[**WarehouseTransfer**](WarehouseTransfer.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_transfer_request_with_return**
> WarehouseTransfer create_transfer_request_with_return(warehouse_transfer_create_transfer_request_with_return_request)

CreateTransferRequestWithReturn

Use this call to create a new transfer request with default reference number <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer import WarehouseTransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_create_transfer_request_with_return_request import WarehouseTransferCreateTransferRequestWithReturnRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_create_transfer_request_with_return_request = linnworks_api.generated.warehousetransfer.WarehouseTransferCreateTransferRequestWithReturnRequest() # WarehouseTransferCreateTransferRequestWithReturnRequest | 

    try:
        # CreateTransferRequestWithReturn
        api_response = api_instance.create_transfer_request_with_return(warehouse_transfer_create_transfer_request_with_return_request)
        print("The response of WarehouseTransferApi->create_transfer_request_with_return:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->create_transfer_request_with_return: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_create_transfer_request_with_return_request** | [**WarehouseTransferCreateTransferRequestWithReturnRequest**](WarehouseTransferCreateTransferRequestWithReturnRequest.md)|  | 

### Return type

[**WarehouseTransfer**](WarehouseTransfer.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_empty_draft_transfer**
> delete_empty_draft_transfer(warehouse_transfer_delete_empty_draft_transfer_request)

DeleteEmptyDraftTransfer

Use this call to delete a draft transfer with no items, properties or notes. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_delete_empty_draft_transfer_request import WarehouseTransferDeleteEmptyDraftTransferRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_delete_empty_draft_transfer_request = linnworks_api.generated.warehousetransfer.WarehouseTransferDeleteEmptyDraftTransferRequest() # WarehouseTransferDeleteEmptyDraftTransferRequest | 

    try:
        # DeleteEmptyDraftTransfer
        api_instance.delete_empty_draft_transfer(warehouse_transfer_delete_empty_draft_transfer_request)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->delete_empty_draft_transfer: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_delete_empty_draft_transfer_request** | [**WarehouseTransferDeleteEmptyDraftTransferRequest**](WarehouseTransferDeleteEmptyDraftTransferRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_transfer**
> delete_transfer(warehouse_transfer_delete_transfer_request)

DeleteTransfer

Use this call to delete a transfer <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_delete_transfer_request import WarehouseTransferDeleteTransferRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_delete_transfer_request = linnworks_api.generated.warehousetransfer.WarehouseTransferDeleteTransferRequest() # WarehouseTransferDeleteTransferRequest | 

    try:
        # DeleteTransfer
        api_instance.delete_transfer(warehouse_transfer_delete_transfer_request)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->delete_transfer: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_delete_transfer_request** | [**WarehouseTransferDeleteTransferRequest**](WarehouseTransferDeleteTransferRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_transfer_property**
> delete_transfer_property(warehouse_transfer_delete_transfer_property_request)

DeleteTransferProperty

Use this call to delete a property from the transfer <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_delete_transfer_property_request import WarehouseTransferDeleteTransferPropertyRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_delete_transfer_property_request = linnworks_api.generated.warehousetransfer.WarehouseTransferDeleteTransferPropertyRequest() # WarehouseTransferDeleteTransferPropertyRequest | 

    try:
        # DeleteTransferProperty
        api_instance.delete_transfer_property(warehouse_transfer_delete_transfer_property_request)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->delete_transfer_property: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_delete_transfer_property_request** | [**WarehouseTransferDeleteTransferPropertyRequest**](WarehouseTransferDeleteTransferPropertyRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_active_transfers_all_locations**
> List[WarehouseTransfer] get_active_transfers_all_locations()

GetActiveTransfersAllLocations

Use this call to get all active transfers for all locations <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer import WarehouseTransfer
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)

    try:
        # GetActiveTransfersAllLocations
        api_response = api_instance.get_active_transfers_all_locations()
        print("The response of WarehouseTransferApi->get_active_transfers_all_locations:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->get_active_transfers_all_locations: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**List[WarehouseTransfer]**](WarehouseTransfer.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_active_transfers_for_location**
> List[WarehouseTransfer] get_active_transfers_for_location(location_id=location_id)

GetActiveTransfersForLocation

Use this call to get all of the active transfers related to this location <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer import WarehouseTransfer
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    location_id = 'location_id_example' # str | pkLocationId for (optional)

    try:
        # GetActiveTransfersForLocation
        api_response = api_instance.get_active_transfers_for_location(location_id=location_id)
        print("The response of WarehouseTransferApi->get_active_transfers_for_location:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->get_active_transfers_for_location: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **location_id** | **str**| pkLocationId for | [optional] 

### Return type

[**List[WarehouseTransfer]**](WarehouseTransfer.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_archived_transfers**
> GenericPagedResultWarehouseTransfer get_archived_transfers(page_number=page_number, entries_per_page=entries_per_page)

GetArchivedTransfers

Use this call to retrieve all of the archived transfers in the system (i.e. Delivered or Deleted). <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.generic_paged_result_warehouse_transfer import GenericPagedResultWarehouseTransfer
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    page_number = 56 # int | The page number (starting at 1). (optional)
    entries_per_page = 56 # int | The number of entries to be returned per page. (optional)

    try:
        # GetArchivedTransfers
        api_response = api_instance.get_archived_transfers(page_number=page_number, entries_per_page=entries_per_page)
        print("The response of WarehouseTransferApi->get_archived_transfers:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->get_archived_transfers: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_number** | **int**| The page number (starting at 1). | [optional] 
 **entries_per_page** | **int**| The number of entries to be returned per page. | [optional] 

### Return type

[**GenericPagedResultWarehouseTransfer**](GenericPagedResultWarehouseTransfer.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_archived_transfers_between_archived_dates**
> GenericPagedResultWarehouseTransfer get_archived_transfers_between_archived_dates(start=start, end=end, page_number=page_number, entries_per_page=entries_per_page)

GetArchivedTransfersBetweenArchivedDates

Use this call to search for archived transfers which were archived between two dates. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.generic_paged_result_warehouse_transfer import GenericPagedResultWarehouseTransfer
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    start = '2013-10-20T19:20:30+01:00' # datetime | The start date. (optional)
    end = '2013-10-20T19:20:30+01:00' # datetime | The end date. (optional)
    page_number = 56 # int | The page number (starting at 1). (optional)
    entries_per_page = 56 # int | The number of entries to be returned per page. (optional)

    try:
        # GetArchivedTransfersBetweenArchivedDates
        api_response = api_instance.get_archived_transfers_between_archived_dates(start=start, end=end, page_number=page_number, entries_per_page=entries_per_page)
        print("The response of WarehouseTransferApi->get_archived_transfers_between_archived_dates:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->get_archived_transfers_between_archived_dates: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **start** | **datetime**| The start date. | [optional] 
 **end** | **datetime**| The end date. | [optional] 
 **page_number** | **int**| The page number (starting at 1). | [optional] 
 **entries_per_page** | **int**| The number of entries to be returned per page. | [optional] 

### Return type

[**GenericPagedResultWarehouseTransfer**](GenericPagedResultWarehouseTransfer.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_archived_transfers_between_dates**
> GenericPagedResultWarehouseTransfer get_archived_transfers_between_dates(start=start, end=end, page_number=page_number, entries_per_page=entries_per_page)

GetArchivedTransfersBetweenDates

Use this call to search for archived transfers which were created between two dates. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.generic_paged_result_warehouse_transfer import GenericPagedResultWarehouseTransfer
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    start = '2013-10-20T19:20:30+01:00' # datetime | The start date. (optional)
    end = '2013-10-20T19:20:30+01:00' # datetime | The end date. (optional)
    page_number = 56 # int | The page number (starting at 1). (optional)
    entries_per_page = 56 # int | The number of entries to be returned per page. (optional)

    try:
        # GetArchivedTransfersBetweenDates
        api_response = api_instance.get_archived_transfers_between_dates(start=start, end=end, page_number=page_number, entries_per_page=entries_per_page)
        print("The response of WarehouseTransferApi->get_archived_transfers_between_dates:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->get_archived_transfers_between_dates: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **start** | **datetime**| The start date. | [optional] 
 **end** | **datetime**| The end date. | [optional] 
 **page_number** | **int**| The page number (starting at 1). | [optional] 
 **entries_per_page** | **int**| The number of entries to be returned per page. | [optional] 

### Return type

[**GenericPagedResultWarehouseTransfer**](GenericPagedResultWarehouseTransfer.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_archived_transfers_filtered**
> GenericPagedResultWarehouseTransfer get_archived_transfers_filtered(search_type=search_type, filter=filter, page_number=page_number, entries_per_page=entries_per_page)

GetArchivedTransfersFiltered

Use this call to search for archived transfers which match a specific search term. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.generic_paged_result_warehouse_transfer import GenericPagedResultWarehouseTransfer
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    search_type = 'search_type_example' # str | The type of search. (optional)
    filter = 'filter_example' # str | The search term. (optional)
    page_number = 56 # int | The page number (starting at 1). (optional)
    entries_per_page = 56 # int | The number of entries to be returned per page. (optional)

    try:
        # GetArchivedTransfersFiltered
        api_response = api_instance.get_archived_transfers_filtered(search_type=search_type, filter=filter, page_number=page_number, entries_per_page=entries_per_page)
        print("The response of WarehouseTransferApi->get_archived_transfers_filtered:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->get_archived_transfers_filtered: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **search_type** | **str**| The type of search. | [optional] 
 **filter** | **str**| The search term. | [optional] 
 **page_number** | **int**| The page number (starting at 1). | [optional] 
 **entries_per_page** | **int**| The number of entries to be returned per page. | [optional] 

### Return type

[**GenericPagedResultWarehouseTransfer**](GenericPagedResultWarehouseTransfer.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_discrepancy_items**
> List[WarehouseTransferItem] get_discrepancy_items(pk_transfer_id=pk_transfer_id)

GetDiscrepancyItems

Use this call to get a list of items whose quantities do not match those that were originally expected. E.g. Received &lt; Sent when Delivered or Sent &lt; Requested when Accepted. Only call this method once after the transfer is Accepted and once when it has been Delivered. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_item import WarehouseTransferItem
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    pk_transfer_id = 'pk_transfer_id_example' # str | The id of the transfer. (optional)

    try:
        # GetDiscrepancyItems
        api_response = api_instance.get_discrepancy_items(pk_transfer_id=pk_transfer_id)
        print("The response of WarehouseTransferApi->get_discrepancy_items:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->get_discrepancy_items: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pk_transfer_id** | **str**| The id of the transfer. | [optional] 

### Return type

[**List[WarehouseTransferItem]**](WarehouseTransferItem.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_list_transfers**
> List[WarehouseTransfer] get_list_transfers(warehouse_transfer_get_list_transfers_request)

GetListTransfers

Use this call to load a list of basic transfers <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer import WarehouseTransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_get_list_transfers_request import WarehouseTransferGetListTransfersRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_get_list_transfers_request = linnworks_api.generated.warehousetransfer.WarehouseTransferGetListTransfersRequest() # WarehouseTransferGetListTransfersRequest | 

    try:
        # GetListTransfers
        api_response = api_instance.get_list_transfers(warehouse_transfer_get_list_transfers_request)
        print("The response of WarehouseTransferApi->get_list_transfers:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->get_list_transfers: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_get_list_transfers_request** | [**WarehouseTransferGetListTransfersRequest**](WarehouseTransferGetListTransfersRequest.md)|  | 

### Return type

[**List[WarehouseTransfer]**](WarehouseTransfer.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_modified_basic**
> List[WarehouseTransfer] get_modified_basic(update_date=update_date)

GetModifiedBasic

Use this call to retrieve a basic list of transfers which have been significantly modified between the specified UTC date and now. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer import WarehouseTransfer
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    update_date = '2013-10-20T19:20:30+01:00' # datetime | A UTC date/time (optional)

    try:
        # GetModifiedBasic
        api_response = api_instance.get_modified_basic(update_date=update_date)
        print("The response of WarehouseTransferApi->get_modified_basic:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->get_modified_basic: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **update_date** | **datetime**| A UTC date/time | [optional] 

### Return type

[**List[WarehouseTransfer]**](WarehouseTransfer.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_server_time**
> datetime get_server_time()

GetServerTime

Use this call to get the current UTC date <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)

    try:
        # GetServerTime
        api_response = api_instance.get_server_time()
        print("The response of WarehouseTransferApi->get_server_time:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->get_server_time: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

**datetime**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_stock_availability**
> List[StockAvailability] get_stock_availability(pk_transfer_item_id=pk_transfer_item_id)

GetStockAvailability

Use this call to retrieve information on inbound transfers and purchase orders for the given transfer item. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.stock_availability import StockAvailability
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    pk_transfer_item_id = 'pk_transfer_item_id_example' # str | The transfer item id. (optional)

    try:
        # GetStockAvailability
        api_response = api_instance.get_stock_availability(pk_transfer_item_id=pk_transfer_item_id)
        print("The response of WarehouseTransferApi->get_stock_availability:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->get_stock_availability: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pk_transfer_item_id** | **str**| The transfer item id. | [optional] 

### Return type

[**List[StockAvailability]**](StockAvailability.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_transfer_audit**
> List[WarehouseTransferAudit] get_transfer_audit(pk_transfer_id=pk_transfer_id)

GetTransferAudit

Use this call to retrieve all of the audit entries for the specified transfer. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_audit import WarehouseTransferAudit
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    pk_transfer_id = 'pk_transfer_id_example' # str | The id of the transfer to retrieve audit entries for. (optional)

    try:
        # GetTransferAudit
        api_response = api_instance.get_transfer_audit(pk_transfer_id=pk_transfer_id)
        print("The response of WarehouseTransferApi->get_transfer_audit:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->get_transfer_audit: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pk_transfer_id** | **str**| The id of the transfer to retrieve audit entries for. | [optional] 

### Return type

[**List[WarehouseTransferAudit]**](WarehouseTransferAudit.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_transfer_bin_notes**
> List[WarehouseTransferBinNote] get_transfer_bin_notes(pk_bin_id=pk_bin_id)

GetTransferBinNotes

Use this call to retrieve notes from a specific bin. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_bin_note import WarehouseTransferBinNote
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    pk_bin_id = 'pk_bin_id_example' # str | The id of the bin. (optional)

    try:
        # GetTransferBinNotes
        api_response = api_instance.get_transfer_bin_notes(pk_bin_id=pk_bin_id)
        print("The response of WarehouseTransferApi->get_transfer_bin_notes:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->get_transfer_bin_notes: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pk_bin_id** | **str**| The id of the bin. | [optional] 

### Return type

[**List[WarehouseTransferBinNote]**](WarehouseTransferBinNote.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_transfer_item_notes**
> List[WarehouseTransferItemNote] get_transfer_item_notes(pk_transfer_id=pk_transfer_id, pk_transfer_item_id=pk_transfer_item_id)

GetTransferItemNotes

Use this call to retrieve the notes from a transfer item. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_item_note import WarehouseTransferItemNote
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    pk_transfer_id = 'pk_transfer_id_example' # str | The id of the transfer to which the item belongs. (optional)
    pk_transfer_item_id = 'pk_transfer_item_id_example' # str | The id of the transfer item. (optional)

    try:
        # GetTransferItemNotes
        api_response = api_instance.get_transfer_item_notes(pk_transfer_id=pk_transfer_id, pk_transfer_item_id=pk_transfer_item_id)
        print("The response of WarehouseTransferApi->get_transfer_item_notes:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->get_transfer_item_notes: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pk_transfer_id** | **str**| The id of the transfer to which the item belongs. | [optional] 
 **pk_transfer_item_id** | **str**| The id of the transfer item. | [optional] 

### Return type

[**List[WarehouseTransferItemNote]**](WarehouseTransferItemNote.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_transfer_items**
> List[WarehouseTransferItem] get_transfer_items(pk_transfer_id=pk_transfer_id)

GetTransferItems

Use this call to retrieve a list of items on  the order and request/sent/received levels. This method will return multiple entries for a single item if the item exists in multiple bins. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_item import WarehouseTransferItem
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    pk_transfer_id = 'pk_transfer_id_example' # str | The id of the transfer. (optional)

    try:
        # GetTransferItems
        api_response = api_instance.get_transfer_items(pk_transfer_id=pk_transfer_id)
        print("The response of WarehouseTransferApi->get_transfer_items:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->get_transfer_items: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pk_transfer_id** | **str**| The id of the transfer. | [optional] 

### Return type

[**List[WarehouseTransferItem]**](WarehouseTransferItem.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_transfer_notes**
> List[WarehouseTransferNote] get_transfer_notes(pk_transfer_id=pk_transfer_id)

GetTransferNotes

Use this call to retrieve a list of transfer-level notes for a given transfer. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_note import WarehouseTransferNote
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    pk_transfer_id = 'pk_transfer_id_example' # str | The id of the transfer (optional)

    try:
        # GetTransferNotes
        api_response = api_instance.get_transfer_notes(pk_transfer_id=pk_transfer_id)
        print("The response of WarehouseTransferApi->get_transfer_notes:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->get_transfer_notes: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pk_transfer_id** | **str**| The id of the transfer | [optional] 

### Return type

[**List[WarehouseTransferNote]**](WarehouseTransferNote.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_transfer_properties**
> List[WarehouseTransferProperty] get_transfer_properties(pk_transfer_id=pk_transfer_id)

GetTransferProperties

Use this call to retrieve a list of properties associated with a given transfer. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_property import WarehouseTransferProperty
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    pk_transfer_id = 'pk_transfer_id_example' # str | The id of the transfer. (optional)

    try:
        # GetTransferProperties
        api_response = api_instance.get_transfer_properties(pk_transfer_id=pk_transfer_id)
        print("The response of WarehouseTransferApi->get_transfer_properties:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->get_transfer_properties: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pk_transfer_id** | **str**| The id of the transfer. | [optional] 

### Return type

[**List[WarehouseTransferProperty]**](WarehouseTransferProperty.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_transfer_with_items**
> WarehouseTransfer get_transfer_with_items(pk_transfer_id=pk_transfer_id)

GetTransferWithItems

Use this call to get a transfer object with its items. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer import WarehouseTransfer
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    pk_transfer_id = 'pk_transfer_id_example' # str | The id of the transfer to be loaded. (optional)

    try:
        # GetTransferWithItems
        api_response = api_instance.get_transfer_with_items(pk_transfer_id=pk_transfer_id)
        print("The response of WarehouseTransferApi->get_transfer_with_items:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->get_transfer_with_items: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pk_transfer_id** | **str**| The id of the transfer to be loaded. | [optional] 

### Return type

[**WarehouseTransfer**](WarehouseTransfer.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_transfer_with_notes**
> WarehouseTransfer get_transfer_with_notes(pk_transfer_id=pk_transfer_id)

GetTransferWithNotes

Use this call to get a warehouse transfer object with items <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer import WarehouseTransfer
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    pk_transfer_id = 'pk_transfer_id_example' # str | pkTransferId for required Transfer (optional)

    try:
        # GetTransferWithNotes
        api_response = api_instance.get_transfer_with_notes(pk_transfer_id=pk_transfer_id)
        print("The response of WarehouseTransferApi->get_transfer_with_notes:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->get_transfer_with_notes: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pk_transfer_id** | **str**| pkTransferId for required Transfer | [optional] 

### Return type

[**WarehouseTransfer**](WarehouseTransfer.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **is_draft_transfer_changed**
> bool is_draft_transfer_changed(pk_transfer_id=pk_transfer_id)

IsDraftTransferChanged

Use this call to work out if a draft transfer has been changed since it was created. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    pk_transfer_id = 'pk_transfer_id_example' # str | The id of the transfer to check. (optional)

    try:
        # IsDraftTransferChanged
        api_response = api_instance.is_draft_transfer_changed(pk_transfer_id=pk_transfer_id)
        print("The response of WarehouseTransferApi->is_draft_transfer_changed:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->is_draft_transfer_changed: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pk_transfer_id** | **str**| The id of the transfer to check. | [optional] 

### Return type

**bool**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **print_transfer**
> str print_transfer(warehouse_transfer_print_transfer_request)

PrintTransfer

Creates a PDF for this transfer and returns the URL <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_print_transfer_request import WarehouseTransferPrintTransferRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_print_transfer_request = linnworks_api.generated.warehousetransfer.WarehouseTransferPrintTransferRequest() # WarehouseTransferPrintTransferRequest | 

    try:
        # PrintTransfer
        api_response = api_instance.print_transfer(warehouse_transfer_print_transfer_request)
        print("The response of WarehouseTransferApi->print_transfer:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->print_transfer: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_print_transfer_request** | [**WarehouseTransferPrintTransferRequest**](WarehouseTransferPrintTransferRequest.md)|  | 

### Return type

**str**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **remove_all_empty_bins**
> remove_all_empty_bins(warehouse_transfer_remove_all_empty_bins_request)

RemoveAllEmptyBins

Use this call to delete bins with no items. To be used if a bin is created and no items are assigned to it. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_remove_all_empty_bins_request = None # object | 

    try:
        # RemoveAllEmptyBins
        api_instance.remove_all_empty_bins(warehouse_transfer_remove_all_empty_bins_request)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->remove_all_empty_bins: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_remove_all_empty_bins_request** | **object**|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **remove_item_from_transfer**
> remove_item_from_transfer(warehouse_transfer_remove_item_from_transfer_request)

RemoveItemFromTransfer

Use this call to remove an item from a transfer. <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_remove_item_from_transfer_request import WarehouseTransferRemoveItemFromTransferRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_remove_item_from_transfer_request = linnworks_api.generated.warehousetransfer.WarehouseTransferRemoveItemFromTransferRequest() # WarehouseTransferRemoveItemFromTransferRequest | 

    try:
        # RemoveItemFromTransfer
        api_instance.remove_item_from_transfer(warehouse_transfer_remove_item_from_transfer_request)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->remove_item_from_transfer: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_remove_item_from_transfer_request** | [**WarehouseTransferRemoveItemFromTransferRequest**](WarehouseTransferRemoveItemFromTransferRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **search_transfers_all_locations**
> List[str] search_transfers_all_locations(search_type=search_type, search_text=search_text)

SearchTransfersAllLocations

Use this call to search for transfers which match a specific criteria <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    search_type = 'search_type_example' # str | The type of search. (optional)
    search_text = 'search_text_example' # str | The search term. (optional)

    try:
        # SearchTransfersAllLocations
        api_response = api_instance.search_transfers_all_locations(search_type=search_type, search_text=search_text)
        print("The response of WarehouseTransferApi->search_transfers_all_locations:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->search_transfers_all_locations: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **search_type** | **str**| The type of search. | [optional] 
 **search_text** | **str**| The search term. | [optional] 

### Return type

**List[str]**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **search_transfers_by_location**
> List[str] search_transfers_by_location(search_type=search_type, search_text=search_text, location_id=location_id)

SearchTransfersByLocation

Use this call to search for transfers which match a specific criteria <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    search_type = 'search_type_example' # str | The type of search. (optional)
    search_text = 'search_text_example' # str | The search term. (optional)
    location_id = 'location_id_example' # str | The location ID to search. (optional)

    try:
        # SearchTransfersByLocation
        api_response = api_instance.search_transfers_by_location(search_type=search_type, search_text=search_text, location_id=location_id)
        print("The response of WarehouseTransferApi->search_transfers_by_location:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->search_transfers_by_location: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **search_type** | **str**| The type of search. | [optional] 
 **search_text** | **str**| The search term. | [optional] 
 **location_id** | **str**| The location ID to search. | [optional] 

### Return type

**List[str]**

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json, text/json, application/xml, text/xml

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **set_reference_number**
> set_reference_number(warehouse_transfer_set_reference_number_request)

SetReferenceNumber

Use this call to change the transfer reference number (this call only works before the transfer is in transit) <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseTransferNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

* Api Key Authentication (token):

```python
import linnworks_api.generated.warehousetransfer
from linnworks_api.generated.warehousetransfer.models.warehouse_transfer_set_reference_number_request import WarehouseTransferSetReferenceNumberRequest
from linnworks_api.generated.warehousetransfer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-ext.linnworks.net
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer.Configuration(
    host = "https://eu-ext.linnworks.net"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: token
configuration.api_key['token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer.WarehouseTransferApi(api_client)
    warehouse_transfer_set_reference_number_request = linnworks_api.generated.warehousetransfer.WarehouseTransferSetReferenceNumberRequest() # WarehouseTransferSetReferenceNumberRequest | 

    try:
        # SetReferenceNumber
        api_instance.set_reference_number(warehouse_transfer_set_reference_number_request)
    except Exception as e:
        print("Exception when calling WarehouseTransferApi->set_reference_number: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **warehouse_transfer_set_reference_number_request** | [**WarehouseTransferSetReferenceNumberRequest**](WarehouseTransferSetReferenceNumberRequest.md)|  | 

### Return type

void (empty response body)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

