# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from linnworks_api.generated.warehousetransfer_new.models.item_received_batches_model import ItemReceivedBatchesModel
from typing import Optional, Set
from typing_extensions import Self

class AddItemReceivedBatchesRequest(BaseModel):
    """
    AddItemReceivedBatchesRequest
    """ # noqa: E501
    batches: ItemReceivedBatchesModel
    transfer_item_id: StrictInt = Field(alias="transferItemId")
    transfer_id: StrictInt = Field(alias="transferId")
    stock_item_id: StrictStr = Field(alias="stockItemId")
    __properties: ClassVar[List[str]] = ["batches", "transferItemId", "transferId", "stockItemId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddItemReceivedBatchesRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of batches
        if self.batches:
            _dict['batches'] = self.batches.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddItemReceivedBatchesRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "batches": ItemReceivedBatchesModel.from_dict(obj["batches"]) if obj.get("batches") is not None else None,
            "transferItemId": obj.get("transferItemId"),
            "transferId": obj.get("transferId"),
            "stockItemId": obj.get("stockItemId")
        })
        return _obj


