# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.warehousetransfer_new.models.amazon_shipment_dimension_unit import AmazonShipmentDimensionUnit
from linnworks_api.generated.warehousetransfer_new.models.amazon_shipment_weight_unit import AmazonShipmentWeightUnit
from typing import Optional, Set
from typing_extensions import Self

class AddShipmentBoxesResponse(BaseModel):
    """
    AddShipmentBoxesResponse
    """ # noqa: E501
    shipment_box_id: Optional[StrictInt] = Field(default=None, alias="shipmentBoxId")
    shipment_id: Optional[StrictInt] = Field(default=None, alias="shipmentId")
    shipment_pallet_id: Optional[StrictInt] = Field(default=None, alias="shipmentPalletId")
    name: Optional[StrictStr] = None
    height: Optional[Union[StrictFloat, StrictInt]] = None
    depth: Optional[Union[StrictFloat, StrictInt]] = None
    width: Optional[Union[StrictFloat, StrictInt]] = None
    weight: Optional[Union[StrictFloat, StrictInt]] = None
    tracking_number: Optional[StrictStr] = Field(default=None, alias="trackingNumber")
    shipment_dimension_unit: Optional[AmazonShipmentDimensionUnit] = Field(default=None, alias="shipmentDimensionUnit")
    shipment_weight_unit: Optional[AmazonShipmentWeightUnit] = Field(default=None, alias="shipmentWeightUnit")
    __properties: ClassVar[List[str]] = ["shipmentBoxId", "shipmentId", "shipmentPalletId", "name", "height", "depth", "width", "weight", "trackingNumber", "shipmentDimensionUnit", "shipmentWeightUnit"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddShipmentBoxesResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if shipment_pallet_id (nullable) is None
        # and model_fields_set contains the field
        if self.shipment_pallet_id is None and "shipment_pallet_id" in self.model_fields_set:
            _dict['shipmentPalletId'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if tracking_number (nullable) is None
        # and model_fields_set contains the field
        if self.tracking_number is None and "tracking_number" in self.model_fields_set:
            _dict['trackingNumber'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddShipmentBoxesResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "shipmentBoxId": obj.get("shipmentBoxId"),
            "shipmentId": obj.get("shipmentId"),
            "shipmentPalletId": obj.get("shipmentPalletId"),
            "name": obj.get("name"),
            "height": obj.get("height"),
            "depth": obj.get("depth"),
            "width": obj.get("width"),
            "weight": obj.get("weight"),
            "trackingNumber": obj.get("trackingNumber"),
            "shipmentDimensionUnit": obj.get("shipmentDimensionUnit"),
            "shipmentWeightUnit": obj.get("shipmentWeightUnit")
        })
        return _obj


