# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.warehousetransfer_new.models.amazon_shipment_type import AmazonShipmentType
from linnworks_api.generated.warehousetransfer_new.models.shipment_transportation_status import ShipmentTransportationStatus
from typing import Optional, Set
from typing_extensions import Self

class GetTransportDetailResponse(BaseModel):
    """
    GetTransportDetailResponse
    """ # noqa: E501
    shipment_id: Optional[StrictInt] = Field(default=None, alias="shipmentId")
    shipment_carrier_id: Optional[StrictInt] = Field(default=None, alias="shipmentCarrierId")
    shipment_type: Optional[AmazonShipmentType] = Field(default=None, alias="shipmentType")
    transportation_status: Optional[ShipmentTransportationStatus] = Field(default=None, alias="transportationStatus")
    shipment_seller_freight_id: Optional[StrictInt] = Field(default=None, alias="shipmentSellerFreightId")
    contact_name: Optional[StrictStr] = Field(default=None, alias="contactName")
    contact_phone: Optional[StrictStr] = Field(default=None, alias="contactPhone")
    contact_email: Optional[StrictStr] = Field(default=None, alias="contactEmail")
    contact_fax: Optional[StrictStr] = Field(default=None, alias="contactFax")
    seller_freight_date: Optional[datetime] = Field(default=None, alias="sellerFreightDate")
    pro_number: Optional[StrictStr] = Field(default=None, alias="proNumber")
    seller_declared_currency: Optional[StrictStr] = Field(default=None, alias="sellerDeclaredCurrency")
    seller_declared_value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="sellerDeclaredValue")
    partnered_estimated_currency_code: Optional[StrictStr] = Field(default=None, alias="partneredEstimatedCurrencyCode")
    partnered_estimated_value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="partneredEstimatedValue")
    partnered_estimated_confirm_deadline: Optional[datetime] = Field(default=None, alias="partneredEstimatedConfirmDeadline")
    partnered_estimated_void_deadline: Optional[datetime] = Field(default=None, alias="partneredEstimatedVoidDeadline")
    site_code: Optional[StrictStr] = Field(default=None, alias="siteCode")
    __properties: ClassVar[List[str]] = ["shipmentId", "shipmentCarrierId", "shipmentType", "transportationStatus", "shipmentSellerFreightId", "contactName", "contactPhone", "contactEmail", "contactFax", "sellerFreightDate", "proNumber", "sellerDeclaredCurrency", "sellerDeclaredValue", "partneredEstimatedCurrencyCode", "partneredEstimatedValue", "partneredEstimatedConfirmDeadline", "partneredEstimatedVoidDeadline", "siteCode"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetTransportDetailResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if shipment_seller_freight_id (nullable) is None
        # and model_fields_set contains the field
        if self.shipment_seller_freight_id is None and "shipment_seller_freight_id" in self.model_fields_set:
            _dict['shipmentSellerFreightId'] = None

        # set to None if contact_name (nullable) is None
        # and model_fields_set contains the field
        if self.contact_name is None and "contact_name" in self.model_fields_set:
            _dict['contactName'] = None

        # set to None if contact_phone (nullable) is None
        # and model_fields_set contains the field
        if self.contact_phone is None and "contact_phone" in self.model_fields_set:
            _dict['contactPhone'] = None

        # set to None if contact_email (nullable) is None
        # and model_fields_set contains the field
        if self.contact_email is None and "contact_email" in self.model_fields_set:
            _dict['contactEmail'] = None

        # set to None if contact_fax (nullable) is None
        # and model_fields_set contains the field
        if self.contact_fax is None and "contact_fax" in self.model_fields_set:
            _dict['contactFax'] = None

        # set to None if seller_freight_date (nullable) is None
        # and model_fields_set contains the field
        if self.seller_freight_date is None and "seller_freight_date" in self.model_fields_set:
            _dict['sellerFreightDate'] = None

        # set to None if pro_number (nullable) is None
        # and model_fields_set contains the field
        if self.pro_number is None and "pro_number" in self.model_fields_set:
            _dict['proNumber'] = None

        # set to None if seller_declared_currency (nullable) is None
        # and model_fields_set contains the field
        if self.seller_declared_currency is None and "seller_declared_currency" in self.model_fields_set:
            _dict['sellerDeclaredCurrency'] = None

        # set to None if seller_declared_value (nullable) is None
        # and model_fields_set contains the field
        if self.seller_declared_value is None and "seller_declared_value" in self.model_fields_set:
            _dict['sellerDeclaredValue'] = None

        # set to None if partnered_estimated_currency_code (nullable) is None
        # and model_fields_set contains the field
        if self.partnered_estimated_currency_code is None and "partnered_estimated_currency_code" in self.model_fields_set:
            _dict['partneredEstimatedCurrencyCode'] = None

        # set to None if partnered_estimated_value (nullable) is None
        # and model_fields_set contains the field
        if self.partnered_estimated_value is None and "partnered_estimated_value" in self.model_fields_set:
            _dict['partneredEstimatedValue'] = None

        # set to None if partnered_estimated_confirm_deadline (nullable) is None
        # and model_fields_set contains the field
        if self.partnered_estimated_confirm_deadline is None and "partnered_estimated_confirm_deadline" in self.model_fields_set:
            _dict['partneredEstimatedConfirmDeadline'] = None

        # set to None if partnered_estimated_void_deadline (nullable) is None
        # and model_fields_set contains the field
        if self.partnered_estimated_void_deadline is None and "partnered_estimated_void_deadline" in self.model_fields_set:
            _dict['partneredEstimatedVoidDeadline'] = None

        # set to None if site_code (nullable) is None
        # and model_fields_set contains the field
        if self.site_code is None and "site_code" in self.model_fields_set:
            _dict['siteCode'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetTransportDetailResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "shipmentId": obj.get("shipmentId"),
            "shipmentCarrierId": obj.get("shipmentCarrierId"),
            "shipmentType": obj.get("shipmentType"),
            "transportationStatus": obj.get("transportationStatus"),
            "shipmentSellerFreightId": obj.get("shipmentSellerFreightId"),
            "contactName": obj.get("contactName"),
            "contactPhone": obj.get("contactPhone"),
            "contactEmail": obj.get("contactEmail"),
            "contactFax": obj.get("contactFax"),
            "sellerFreightDate": obj.get("sellerFreightDate"),
            "proNumber": obj.get("proNumber"),
            "sellerDeclaredCurrency": obj.get("sellerDeclaredCurrency"),
            "sellerDeclaredValue": obj.get("sellerDeclaredValue"),
            "partneredEstimatedCurrencyCode": obj.get("partneredEstimatedCurrencyCode"),
            "partneredEstimatedValue": obj.get("partneredEstimatedValue"),
            "partneredEstimatedConfirmDeadline": obj.get("partneredEstimatedConfirmDeadline"),
            "partneredEstimatedVoidDeadline": obj.get("partneredEstimatedVoidDeadline"),
            "siteCode": obj.get("siteCode")
        })
        return _obj


