# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_new.models.int32_string_key_value_pair import Int32StringKeyValuePair
from linnworks_api.generated.warehousetransfer_new.models.shipment_carrier_model import ShipmentCarrierModel
from linnworks_api.generated.warehousetransfer_new.models.shipment_items_import_meta_fields import ShipmentItemsImportMetaFields
from linnworks_api.generated.warehousetransfer_new.models.shipment_package_label_type_model import ShipmentPackageLabelTypeModel
from linnworks_api.generated.warehousetransfer_new.models.shipment_seller_freight_model import ShipmentSellerFreightModel
from linnworks_api.generated.warehousetransfer_new.models.shipment_type_model import ShipmentTypeModel
from typing import Optional, Set
from typing_extensions import Self

class GetViewMetaDataResponse(BaseModel):
    """
    This model contains metadata which used by fba and warehouse transfers views
    """ # noqa: E501
    packing_types: Optional[List[Int32StringKeyValuePair]] = Field(default=None, alias="packingTypes")
    shipment_statuses: Optional[List[Int32StringKeyValuePair]] = Field(default=None, alias="shipmentStatuses")
    shipping_plan_statuses: Optional[List[Int32StringKeyValuePair]] = Field(default=None, alias="shippingPlanStatuses")
    prep_owners: Optional[List[Int32StringKeyValuePair]] = Field(default=None, alias="prepOwners")
    who_prepares: Optional[List[Int32StringKeyValuePair]] = Field(default=None, alias="whoPrepares")
    import_meta_fields: Optional[ShipmentItemsImportMetaFields] = Field(default=None, alias="importMetaFields")
    amazon_shipment_types: Optional[List[ShipmentTypeModel]] = Field(default=None, alias="amazonShipmentTypes")
    amazon_shipment_carriers: Optional[List[ShipmentCarrierModel]] = Field(default=None, alias="amazonShipmentCarriers")
    amazon_shipment_seller_freights: Optional[List[ShipmentSellerFreightModel]] = Field(default=None, alias="amazonShipmentSellerFreights")
    amazon_shipment_package_label_types: Optional[List[ShipmentPackageLabelTypeModel]] = Field(default=None, alias="amazonShipmentPackageLabelTypes")
    amazon_partnered_carrier_supported_countries: Optional[List[StrictStr]] = Field(default=None, alias="amazonPartneredCarrierSupportedCountries")
    __properties: ClassVar[List[str]] = ["packingTypes", "shipmentStatuses", "shippingPlanStatuses", "prepOwners", "whoPrepares", "importMetaFields", "amazonShipmentTypes", "amazonShipmentCarriers", "amazonShipmentSellerFreights", "amazonShipmentPackageLabelTypes", "amazonPartneredCarrierSupportedCountries"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetViewMetaDataResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in packing_types (list)
        _items = []
        if self.packing_types:
            for _item_packing_types in self.packing_types:
                if _item_packing_types:
                    _items.append(_item_packing_types.to_dict())
            _dict['packingTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in shipment_statuses (list)
        _items = []
        if self.shipment_statuses:
            for _item_shipment_statuses in self.shipment_statuses:
                if _item_shipment_statuses:
                    _items.append(_item_shipment_statuses.to_dict())
            _dict['shipmentStatuses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in shipping_plan_statuses (list)
        _items = []
        if self.shipping_plan_statuses:
            for _item_shipping_plan_statuses in self.shipping_plan_statuses:
                if _item_shipping_plan_statuses:
                    _items.append(_item_shipping_plan_statuses.to_dict())
            _dict['shippingPlanStatuses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in prep_owners (list)
        _items = []
        if self.prep_owners:
            for _item_prep_owners in self.prep_owners:
                if _item_prep_owners:
                    _items.append(_item_prep_owners.to_dict())
            _dict['prepOwners'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in who_prepares (list)
        _items = []
        if self.who_prepares:
            for _item_who_prepares in self.who_prepares:
                if _item_who_prepares:
                    _items.append(_item_who_prepares.to_dict())
            _dict['whoPrepares'] = _items
        # override the default output from pydantic by calling `to_dict()` of import_meta_fields
        if self.import_meta_fields:
            _dict['importMetaFields'] = self.import_meta_fields.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in amazon_shipment_types (list)
        _items = []
        if self.amazon_shipment_types:
            for _item_amazon_shipment_types in self.amazon_shipment_types:
                if _item_amazon_shipment_types:
                    _items.append(_item_amazon_shipment_types.to_dict())
            _dict['amazonShipmentTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in amazon_shipment_carriers (list)
        _items = []
        if self.amazon_shipment_carriers:
            for _item_amazon_shipment_carriers in self.amazon_shipment_carriers:
                if _item_amazon_shipment_carriers:
                    _items.append(_item_amazon_shipment_carriers.to_dict())
            _dict['amazonShipmentCarriers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in amazon_shipment_seller_freights (list)
        _items = []
        if self.amazon_shipment_seller_freights:
            for _item_amazon_shipment_seller_freights in self.amazon_shipment_seller_freights:
                if _item_amazon_shipment_seller_freights:
                    _items.append(_item_amazon_shipment_seller_freights.to_dict())
            _dict['amazonShipmentSellerFreights'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in amazon_shipment_package_label_types (list)
        _items = []
        if self.amazon_shipment_package_label_types:
            for _item_amazon_shipment_package_label_types in self.amazon_shipment_package_label_types:
                if _item_amazon_shipment_package_label_types:
                    _items.append(_item_amazon_shipment_package_label_types.to_dict())
            _dict['amazonShipmentPackageLabelTypes'] = _items
        # set to None if packing_types (nullable) is None
        # and model_fields_set contains the field
        if self.packing_types is None and "packing_types" in self.model_fields_set:
            _dict['packingTypes'] = None

        # set to None if shipment_statuses (nullable) is None
        # and model_fields_set contains the field
        if self.shipment_statuses is None and "shipment_statuses" in self.model_fields_set:
            _dict['shipmentStatuses'] = None

        # set to None if shipping_plan_statuses (nullable) is None
        # and model_fields_set contains the field
        if self.shipping_plan_statuses is None and "shipping_plan_statuses" in self.model_fields_set:
            _dict['shippingPlanStatuses'] = None

        # set to None if prep_owners (nullable) is None
        # and model_fields_set contains the field
        if self.prep_owners is None and "prep_owners" in self.model_fields_set:
            _dict['prepOwners'] = None

        # set to None if who_prepares (nullable) is None
        # and model_fields_set contains the field
        if self.who_prepares is None and "who_prepares" in self.model_fields_set:
            _dict['whoPrepares'] = None

        # set to None if amazon_shipment_types (nullable) is None
        # and model_fields_set contains the field
        if self.amazon_shipment_types is None and "amazon_shipment_types" in self.model_fields_set:
            _dict['amazonShipmentTypes'] = None

        # set to None if amazon_shipment_carriers (nullable) is None
        # and model_fields_set contains the field
        if self.amazon_shipment_carriers is None and "amazon_shipment_carriers" in self.model_fields_set:
            _dict['amazonShipmentCarriers'] = None

        # set to None if amazon_shipment_seller_freights (nullable) is None
        # and model_fields_set contains the field
        if self.amazon_shipment_seller_freights is None and "amazon_shipment_seller_freights" in self.model_fields_set:
            _dict['amazonShipmentSellerFreights'] = None

        # set to None if amazon_shipment_package_label_types (nullable) is None
        # and model_fields_set contains the field
        if self.amazon_shipment_package_label_types is None and "amazon_shipment_package_label_types" in self.model_fields_set:
            _dict['amazonShipmentPackageLabelTypes'] = None

        # set to None if amazon_partnered_carrier_supported_countries (nullable) is None
        # and model_fields_set contains the field
        if self.amazon_partnered_carrier_supported_countries is None and "amazon_partnered_carrier_supported_countries" in self.model_fields_set:
            _dict['amazonPartneredCarrierSupportedCountries'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetViewMetaDataResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "packingTypes": [Int32StringKeyValuePair.from_dict(_item) for _item in obj["packingTypes"]] if obj.get("packingTypes") is not None else None,
            "shipmentStatuses": [Int32StringKeyValuePair.from_dict(_item) for _item in obj["shipmentStatuses"]] if obj.get("shipmentStatuses") is not None else None,
            "shippingPlanStatuses": [Int32StringKeyValuePair.from_dict(_item) for _item in obj["shippingPlanStatuses"]] if obj.get("shippingPlanStatuses") is not None else None,
            "prepOwners": [Int32StringKeyValuePair.from_dict(_item) for _item in obj["prepOwners"]] if obj.get("prepOwners") is not None else None,
            "whoPrepares": [Int32StringKeyValuePair.from_dict(_item) for _item in obj["whoPrepares"]] if obj.get("whoPrepares") is not None else None,
            "importMetaFields": ShipmentItemsImportMetaFields.from_dict(obj["importMetaFields"]) if obj.get("importMetaFields") is not None else None,
            "amazonShipmentTypes": [ShipmentTypeModel.from_dict(_item) for _item in obj["amazonShipmentTypes"]] if obj.get("amazonShipmentTypes") is not None else None,
            "amazonShipmentCarriers": [ShipmentCarrierModel.from_dict(_item) for _item in obj["amazonShipmentCarriers"]] if obj.get("amazonShipmentCarriers") is not None else None,
            "amazonShipmentSellerFreights": [ShipmentSellerFreightModel.from_dict(_item) for _item in obj["amazonShipmentSellerFreights"]] if obj.get("amazonShipmentSellerFreights") is not None else None,
            "amazonShipmentPackageLabelTypes": [ShipmentPackageLabelTypeModel.from_dict(_item) for _item in obj["amazonShipmentPackageLabelTypes"]] if obj.get("amazonShipmentPackageLabelTypes") is not None else None,
            "amazonPartneredCarrierSupportedCountries": obj.get("amazonPartneredCarrierSupportedCountries")
        })
        return _obj


